#!/bin/sh

PATHFILE=./src/DefaultBinaryPaths.h

FOUNDTEX=0
BINPATHS=":"

if [ -x /usr/share/libtool/config.guess ]; then
	PLATFORM=`/usr/share/libtool/config.guess`
	ARCH=`echo $PLATFORM | sed 's/-.*//;s/i.86/i386/'`
else
	PLATFORM=`uname -s | tr A-Z a-z`
	ARCH=`uname -m | tr A-Z a-z | sed 's/i.86/i386/'`
fi

# append a path to $BINPATHS unless already present
appendPath()
{
	NEWPATH="$1"
	case "$BINPATHS" in
		*:"$NEWPATH":*)	echo $NEWPATH already present;;
		*)				# note that BINPATHS already ends with colon
						BINPATHS="$BINPATHS$NEWPATH:";;
	esac
}

# (0) for Mac OS X, start with /usr/texbin
case $PLATFORM in
	*darwin*)	appendPath "/usr/texbin";;
esac

# (1) try to find tex and ghostscript

TEX=`which tex`
if [ "$TEX" != "" ]; then
	if [ -x "$TEX" ]; then
		appendPath `dirname "$TEX"`
		FOUNDTEX=1
	fi
fi

GS=`which gs`
if [ "$GS" != "" ]; then
	if [ -x "$GS" ]; then
		appendPath `dirname "$GS"`
	fi
fi

# (2) try to guess default TL path for the current system
# (no idea how much of this actually works....)

case $PLATFORM in
	*aix*)		OS=aix;;
	*cygwin*)	OS=cygwin;;
	*darwin*)	OS=darwin;;
	*freebsd*)	OS=freebsd;;
	*hpux*)		OS=hpux;;
	*irix*)		OS=irix;;
	*linux*)	OS=linux;;
	*netbsd*)	OS=netbsd;;
	*openbsd*)	OS=openbsd;;
	*solaris*)	OS=solaris;;
	*)			OS=`echo $PLATFORM | sed 's/.*-//'`
esac

appendPath "/usr/local/texlive/2009/bin/$ARCH-$OS"
appendPath "/usr/local/texlive/2008/bin/$ARCH-$OS"
appendPath "/usr/local/texlive/2007/bin/$ARCH-$OS"

# (3) append default paths that we should always check

appendPath "/usr/local/bin"
appendPath "/usr/bin"

# strip leading and trailing colons from the list
BINPATHS=`echo $BINPATHS | sed 's/^://;s/:$//'`

echo "// Default paths to TeX binaries, for TeXworks" > $PATHFILE
echo "// Generated by $0" >> $PATHFILE
echo "#define DEFAULT_BIN_PATHS \"$BINPATHS\"" >> $PATHFILE

echo "configuring default paths for TeX binaries as:"
echo "$BINPATHS"

exit $FOUNDTEX
