/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 2001-2003, William Chia-Wei Cheng.
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Trolltech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/stretch.e,v 4.14 2003/02/25 01:17:41 william Exp $
 */

#ifndef _STRETCH_E_
#define _STRETCH_E_

extern int	stretchableText;
extern int	rotationIncrement;

#ifdef _INCLUDE_FROM_STRETCH_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_STRETCH_C_*/

extern int	PtInPolyMark ARGS_DECL((struct ObjRec *, int XOff, int YOff,
		                        int NumPts, IntPoint *, int *Index));
extern int	RetractedArrowAttr ARGS_DECL((struct ObjRec *));
extern int	AutoRetractedArrowAttr ARGS_DECL((struct ObjRec *,
		                                  int CheckVCount));
extern int	AutoCenterAttr ARGS_DECL((struct ObjRec *));
extern void	CenterObjInOBBox ARGS_DECL((struct ObjRec *TextObjPtr,
                                            struct BBRec OBBox,
                                            struct BBRec *OBBoxReturn));
extern struct SelRec	* PtInSelMark ARGS_DECL((int XOff, int YOff,
			                         int * Corner));
extern void	ShearObj ARGS_DECL((struct ObjRec *, int Corner, double dXShear,
		                    double dYShear, double dXScale,
		                    double dYScale, int *RealLtX,
		                    int *RealLtY));
extern void	StretchSel ARGS_DECL((int XGridOff, int YGridOff,
		                      struct ObjRec *, int Corner));
extern void	ScaleAnEPSObj ARGS_DECL((struct ObjRec *, float * Scale));
extern void	ScaleAllSelObj ARGS_DECL((void));
extern void	PreciseScaleEverything ARGS_DECL((void));
extern void	ScaleObjLikeScaleEverything ARGS_DECL((struct ObjRec *,
		                                       double Scale,
		                                       int Redraw));
extern void	SizeAllSelObj ARGS_DECL((int AbsW, int AbsH));
extern void	SizeAnObj ARGS_DECL((struct ObjRec *ObjPtr,
		                     struct ObjRec *TopOwner,
		                     int AbsW, int AbsH));
extern void	SizeAllSelToGivenWidthHeight ARGS_DECL((int AbsW, int AbsH));
extern void	SizeAllSelToGivenWidth ARGS_DECL((int AbsW));
extern void	SizeAllSelToGivenHeight ARGS_DECL((int AbsH));
extern void	FlipObjHorizontal ARGS_DECL((struct ObjRec *));
extern void	FlipIconHorizontal ARGS_DECL((struct ObjRec *));
extern void	FlipObjVertical ARGS_DECL((struct ObjRec *));
extern void	FlipIconVertical ARGS_DECL((struct ObjRec *));

extern void	SetRotatePivot ARGS_DECL((void));
extern void	SetRotatePivotByObject ARGS_DECL((struct ObjRec *));
extern void	RotateObjForLayout ARGS_DECL((struct ObjRec *, double, int));
extern void	RotateObj ARGS_DECL((struct ObjRec *, int Corner,
		                     int AngleDelta, int *RealLtX,
		                     int *RealLtY));
extern void	RotateObjClockWise ARGS_DECL((struct ObjRec *));
extern void	RotateIconClockWise ARGS_DECL((struct ObjRec *));
extern void	RotateObjCounter ARGS_DECL((struct ObjRec *));
extern void	RotateIconCounter ARGS_DECL((struct ObjRec *));
extern void	FlipHorizontal ARGS_DECL((void));
extern void	FlipVertical ARGS_DECL((void));
extern void	RotateClockWise ARGS_DECL((void));
extern void	RotateCounter ARGS_DECL((void));
extern void	SetTextRotation ARGS_DECL((char*));
extern void	SetRotationIncrement ARGS_DECL((char*));
extern void	SetSelCTM ARGS_DECL((int nTransformed, struct XfrmMtrxRec *));
extern void	RotateShearSel ARGS_DECL((int XGridOff, int YGridOff,
		                          struct ObjRec *, int Corner));

#ifdef _INCLUDE_FROM_STRETCH_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_STRETCH_C_*/

#endif /*_STRETCH_E_*/
