/***************************************************************************
                              th-prefs-dialog.c
                              -----------------
    begin                : Sun Jun 27 2004
    copyright            : (C) 2004 by Tim-Philipp Mller
    email                : tim centricular net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "th-preferences.h"
#include "th-preferences-dialog.h"
#include "th-utils.h"

#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <string.h>

/* model columns for the selector on the left */
enum
{
	COL_STOCK_ID,
	COL_LABEL,
	COL_PAGENUM
};

enum
{
	PAGE_GENERAL = 0
};

struct _ThPreferencesDialogPrivate 
{
	ThPreferences    *prefs;

	gboolean          ui_loaded;

	GtkWidget        *errlabel; /* if we couldn't load the .glade file */
	GtkWidget        *notebook;
	
	/* list view on the left to select the section */
	GtkWidget        *treeview;
	GtkListStore     *store;
	GtkTreeSelection *sel;

	/* General */

	GtkWidget        *delete_partial_cb;
};

static void         prefs_dialog_class_init     (ThPreferencesDialogClass *klass);

static void         prefs_dialog_instance_init  (ThPreferencesDialog *pd);

static void         prefs_dialog_finalize       (GObject *obj);

static void         prefs_dialog_selection_changed_cb (ThPreferencesDialog *pd, GtkTreeSelection *sel);

static void         prefs_dialog_realize_cb     (ThPreferencesDialog *pd, gpointer data);

static void         prefs_dialog_init_general   (ThPreferencesDialog *pd);


static gpointer     pd_parent_class; /* NULL */

/***************************************************************************
 *                                                                         
 *   th_preferences_dialog_get_type
 *                                                                         
 ***************************************************************************/

GType        
th_preferences_dialog_get_type (void)
{
	static GType pd_type = 0;

	if (!pd_type)
	{
		static const GTypeInfo pd_info =
		{
			sizeof (ThPreferencesDialogClass),
			NULL,                                               /* base_init */
			NULL,                                               /* base_finalize */
			(GClassInitFunc) prefs_dialog_class_init,
			NULL,                                               /* class finalize */
			NULL,                                               /* class_data */
			sizeof (ThPreferencesDialog),
			0,                                                  /* n_preallocs */
			(GInstanceInitFunc) prefs_dialog_instance_init
		};

		pd_type = g_type_register_static (GTK_TYPE_DIALOG, "ThPreferencesDialog",
		                                  &pd_info, (GTypeFlags)0);
	}

	return pd_type;
}

/***************************************************************************
 *   
 *   prefs_dialog_instance_init
 *   
 ***************************************************************************/

static void
prefs_dialog_instance_init (ThPreferencesDialog *pd)
{
	GdkScreen *screen;
	
	pd->priv = g_new0 (ThPreferencesDialogPrivate, 1);
	
	g_signal_connect (pd, "realize", G_CALLBACK (prefs_dialog_realize_cb), NULL);

	screen = gdk_screen_get_default ();

	gtk_window_set_default_size (GTK_WINDOW (pd), 
	                             gdk_screen_get_width (screen)/2,
	                             gdk_screen_get_height (screen)/2);

	g_signal_connect (pd, "delete-event", 
	                  G_CALLBACK (gtk_widget_hide_on_delete), 
	                  NULL);

	/* hide dialog when close button is pressed */
	g_signal_connect (pd, "response", 
	                  G_CALLBACK (gtk_widget_hide_on_delete), 
	                  NULL);
	
	pd->priv->ui_loaded = FALSE;
}

/***************************************************************************
 *   
 *   prefs_dialog_finalize
 *   
 ***************************************************************************/

static void
prefs_dialog_finalize (GObject *obj)
{
	ThPreferencesDialog *pd = TH_PREFERENCES_DIALOG (obj);

	/* free and poison memory */
	memset (pd->priv, 0xab, sizeof (ThPreferencesDialogPrivate));
	g_free (pd->priv);
	pd->priv = NULL;

	G_OBJECT_CLASS (pd_parent_class)->finalize (obj); /* chain up */
}

/***************************************************************************
 *   
 *   prefs_dialog_class_init
 *   
 ***************************************************************************/

static void
prefs_dialog_class_init (ThPreferencesDialogClass *klass)
{
	GObjectClass *object_class;
	
	pd_parent_class = g_type_class_peek_parent (klass);
	
	object_class = (GObjectClass*) klass;

	object_class->finalize = prefs_dialog_finalize;
}

/***************************************************************************
 *   
 *   th_preferences_dialog_new
 *   
 ***************************************************************************/

GtkWidget *
th_preferences_dialog_new (ThPreferences *prefs)
{
	ThPreferencesDialog *pd;

	g_return_val_if_fail (TH_IS_PREFERENCES (prefs), NULL);
	
	pd = (ThPreferencesDialog*) g_object_new (TH_TYPE_PREFERENCES_DIALOG, NULL);
	
	pd->priv->prefs = prefs;

	return (GtkWidget*) pd;
}


/***************************************************************************
 *   
 *   prefs_dialog_init_treeview
 *   
 ***************************************************************************/

static void
prefs_dialog_init_treeview (ThPreferencesDialog *pd)
{
	GtkTreeViewColumn *col;
	GtkCellRenderer   *renderer;
	GtkTreeIter        iter;

	pd->priv->store = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);

	gtk_tree_view_set_model (GTK_TREE_VIEW (pd->priv->treeview), GTK_TREE_MODEL (pd->priv->store));

	col = gtk_tree_view_column_new ();

	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "ypad", 4, "stock-size", GTK_ICON_SIZE_LARGE_TOOLBAR, NULL);
	gtk_tree_view_column_pack_start (col, renderer, FALSE);
	gtk_tree_view_column_add_attribute (col, renderer, "stock-id", COL_STOCK_ID);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "ypad", 4, "xpad", 4, "weight", PANGO_WEIGHT_BOLD, "scale", PANGO_SCALE_LARGE, NULL);
	gtk_tree_view_column_pack_start (col, renderer, TRUE);
	gtk_tree_view_column_add_attribute (col, renderer, "text", COL_LABEL);

	gtk_tree_view_append_column (GTK_TREE_VIEW (pd->priv->treeview), col);

	pd->priv->sel = gtk_tree_view_get_selection (GTK_TREE_VIEW (pd->priv->treeview));

	g_signal_connect_swapped (pd->priv->sel, "changed", 
	                          G_CALLBACK (prefs_dialog_selection_changed_cb), 
	                          pd);
	
	gtk_list_store_append (pd->priv->store, &iter);
	gtk_list_store_set (pd->priv->store, &iter, 
	                    COL_STOCK_ID, GTK_STOCK_PREFERENCES, 
	                    COL_LABEL, _("General"), 
	                    COL_PAGENUM, PAGE_GENERAL, 
	                    -1);
}


/***************************************************************************
 *   
 *   prefs_dialog_selection_changed_cb
 *   
 ***************************************************************************/

static void
prefs_dialog_selection_changed_cb (ThPreferencesDialog *pd, GtkTreeSelection *sel)
{
	GtkTreeModel *model;
	GtkTreeIter   iter;
	guint         pagenum;

	if (!gtk_tree_selection_get_selected (sel, &model, &iter))
		return;

	gtk_tree_model_get (model, &iter, COL_PAGENUM, &pagenum, -1);
	
	g_object_set (pd->priv->notebook, "page", pagenum, NULL);
}

/***************************************************************************
 *   
 *   prefs_dialog_notebook_page_notify_cb
 *   
 ***************************************************************************/

static void
prefs_dialog_notebook_page_notify_cb (ThPreferencesDialog *pd, 
                                      GParamSpec    *pspec, 
                                      gpointer       nb)
{
	guint pagenum;
	
	g_object_get (nb, "page", &pagenum, NULL);

	switch (pagenum)
	{
		case PAGE_GENERAL:
			break;
#if 0
		case PAGE_COLOURS:
			prefs_dialog_fill_colors_combobox (pd);
			break;
		
		case PAGE_PLAYER_LOOK:
			prefs_dialog_fill_pui_combobox (pd);
			break;
#endif
		
		default:
			g_return_if_reached ();
	}
}

/***************************************************************************
 *   
 *   prefs_dialog_realize_cb
 *   
 *   load the UI only when we're shown for the first time
 *
 ***************************************************************************/

static void
prefs_dialog_realize_cb (ThPreferencesDialog *pd, gpointer data)
{
	GtkWidget   *dialog, *vbox;
	
	if (pd->priv->ui_loaded)
		return;

	gtk_window_set_title (GTK_WINDOW (pd), _("Preferences"));
	gtk_dialog_add_button (GTK_DIALOG (pd), GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE);
	
	if (!th_utils_ui_load_interface ("th-preferences-dialog.glade", FALSE,
	                                 "th-preferences-dialog", &dialog,
	                                 "prefs-vbox", &vbox,
	                                 "treeview", &pd->priv->treeview,
	                                 "notebook", &pd->priv->notebook,
	                                 "delete-partial-cb", &pd->priv->delete_partial_cb,
//	                                 "colors-combobox", &pd->priv->cols_combobox,
//	                                 "pui-combobox", &pd->priv->pui_combobox,
	                                 NULL))
	{
		if (pd->priv->errlabel == NULL)
		{
			pd->priv->errlabel = gtk_label_new (_("Failed to load interface 'th-preferences-dialog.glade'"
			                                      " - Check your installation!\n"));
			gtk_container_add (GTK_CONTAINER (pd), pd->priv->errlabel);
		}
		
		gtk_widget_show (pd->priv->errlabel);
		return;
	}

	prefs_dialog_init_treeview (pd);

	prefs_dialog_init_general (pd);

	pd->priv->ui_loaded = TRUE;
	
	if (pd->priv->errlabel)
		gtk_widget_hide (pd->priv->errlabel);

	gtk_notebook_set_show_tabs (GTK_NOTEBOOK (pd->priv->notebook), FALSE);

	g_signal_connect_swapped (pd->priv->notebook, "notify::page",
	                          G_CALLBACK (prefs_dialog_notebook_page_notify_cb), pd);
	
	/* reparent */
	g_object_ref (vbox);
	gtk_container_remove (GTK_CONTAINER (vbox->parent), vbox);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(pd)->vbox), vbox);
	g_object_unref (vbox);
	gtk_widget_destroy (dialog);

	/* select first */
	gtk_tree_selection_set_mode (pd->priv->sel, GTK_SELECTION_NONE);
	gtk_tree_selection_set_mode (pd->priv->sel, GTK_SELECTION_BROWSE);
	
	gtk_widget_show_all (GTK_WIDGET (pd));
}

/***************************************************************************
 *   
 *   prefs_dialog_general_delpartial_toggled_cb
 *
 ***************************************************************************/

static void
prefs_dialog_delete_partial_toggled_cb (ThPreferencesDialog *pd, GtkCheckButton *del_partial)
{
	GValue val = { 0, };

	g_value_init (&val, G_TYPE_BOOLEAN);

	g_object_get_property (G_OBJECT (del_partial), "active", &val);

	th_preferences_set_value (pd->priv->prefs,
	                          "delete-partial-file-on-cancel", 
	                          NULL, 
	                          &val);
}

/***************************************************************************
 *   
 *   prefs_dialog_init_general
 *
 ***************************************************************************/

static void
prefs_dialog_init_general (ThPreferencesDialog *pd)
{
	GValue val = { 0, };

	if (th_preferences_get_value (pd->priv->prefs, "delete-partial-file-on-cancel", NULL, &val))
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pd->priv->delete_partial_cb),
		                              g_value_get_boolean (&val));
		g_value_unset (&val);
	}
	else g_warning ("th_preferences_get_value() failed at %s\n", G_STRLOC);

	g_signal_connect_swapped (pd->priv->delete_partial_cb, "toggled",
	                          G_CALLBACK (prefs_dialog_delete_partial_toggled_cb),
	                          pd);
}
