/***************************************************************************
                             th-preferences.h
                             ----------------
    begin                : Thu Apr 29 2004
    copyright            : (C) 2004 by Tim-Philipp Mller
    email                : tim centricular net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _th_preferences_h_included_
#define _th_preferences_h_included_

#include <glib-object.h>

#define TH_TYPE_PREFERENCES            (th_preferences_get_type())
#define TH_PREFERENCES(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj,  TH_TYPE_PREFERENCES, ThPreferences))
#define TH_PREFERENCES_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass,   TH_TYPE_PREFERENCES, ThPreferencesClass))
#define TH_IS_PREFERENCES(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj,  TH_TYPE_PREFERENCES))
#define TH_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TH_TYPE_PREFERENCES))


typedef struct _ThPreferences        ThPreferences;
typedef struct _ThPreferencesClass   ThPreferencesClass;
typedef struct _ThPreferencesPrivate ThPreferencesPrivate;

struct _ThPreferences
{
  GObject                object;
  
  ThPreferencesPrivate  *priv;
};

struct _ThPreferencesClass
{
  GObjectClass  object_class;

  void        (*deep_notify) (ThPreferences *prefs, GObject *object, GParamSpec *pspec);
};


GType            th_preferences_get_type      (void) G_GNUC_CONST;

ThPreferences   *th_preferences_new           (const gchar *filename);

void             th_preferences_load          (ThPreferences *prefs);

void             th_preferences_save          (ThPreferences *prefs);

void             th_preferences_register_proxy (ThPreferences *prefs,
                                                GObject       *obj,
                                                const gchar   *obj_prop_name,
                                                const gchar   *prefs_name,
                                                const gchar   *group_name);

gboolean         th_preferences_get_value (ThPreferences *prefs,
                                           const gchar   *prefs_name,
                                           const gchar   *group_name,
                                           GValue        *p_value);

void             th_preferences_set_value (ThPreferences *prefs,
                                           const gchar   *prefs_name,
                                           const gchar   *group_name,
                                           const GValue  *value);

#endif /* _th_preferences_h_included_ */



