/*
 *	TICKR - GTK-based Feed Reader - Copyright (C) Emmanuel Thomas-Maurin 2009-2012
 *	<manutm007@gmail.com>
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "tickr.h"

/* These variables and widgets are all set as static global for convenience. */
static TickerEnv	*env;
static gchar		current_url[FILE_NAME_MAXLEN + 1];

static GtkWidget	*dialog, *sc_win, *entry_homefeed;
static GtkWidget	*table, *label[128];	/* This should be enough but check anyways */
static GtkWidget	*hbox1, *hbox2, *hbox3, *hbox4, *hbox5, *hbox6, *hbox7;
static GtkWidget	*cancel_but, *reset_but, *apply_but, *ok_but;
static GtkWidget	*sysfg_but, *sysbg_but, *sysfgclock_but, *sysbgclock_but;
static GtkWidget	*top_but, *bottom_but, *fullwidth_but, *curfeed_but;
static GtkWidget	*spinbut_delay, *spinbut_shiftsize;
static GtkWidget	*spinbut_winx, *spinbut_winy, *spinbut_winw, *spinbut_winh;
static GtkWidget	*checkbut_windec, *checkbut_iconintaskbar, *checkbut_winsticky;
static GtkWidget	*spinbut_shadowoffsetx, *spinbut_shadowoffsety;
static GtkWidget	*spinbut_shadowfx, *spinbut_rssrefresh;
static GtkWidget	*spinbut_wintransparency, *spinbut_nitemsperfeed;
static GtkWidget	*checkbut_shadow, *checkbut_alwaysontop, *checkbut_windec;
static GtkWidget	*checkbut_spchars;
static GtkWidget	*checkbut_feedtitle, *checkbut_itemtitle, *checkbut_itemdes;
static GtkWidget	*checkbut_striptags, *checkbut_uppercase, *checkbut_nopopups;
static GtkWidget	*checkbut_mouseover, *checkbut_noleftclick, *checkbut_feedordering;
static GtkWidget	*font_but, *clock_font_but;
static GtkWidget	*fg_color_but, *bg_color_but, *clock_fg_color_but, *clock_bg_color_but;
static GtkWidget	*rbut_box1, *radio_but1_1, *radio_but1_2, *radio_but1_3;
static GtkWidget	*rbut_box2, *radio_but2_1, *radio_but2_2, *radio_but2_3;
static GtkWidget	*entry_feedtitledel, *entry_itemtitledel, *entry_itemdesdel;
static GtkWidget	*entry_linedel, *entry_cutlinedel, *entry_newpagech, *entry_tabch;
static GtkWidget	*entry_openlinkcmd, *entry_openlinkargs;
static GtkObject	*adj_delay, *adj_shiftsize, *adj_winx, *adj_winy;
static GtkObject	*adj_winw, *adj_winh, *adj_shadowoffsetx, *adj_shadowfx;
static GtkObject	*adj_shadowoffsety, *adj_rssrefresh;
static GtkObject	*adj_wintransparency, *adj_nitemsperfeed;

/* TODO: we want widgets system colors, not these ones */
static gint use_system_fg_color_ticker(GtkWidget *widget)
{
	GdkColor color;

	widget = widget;
	color = gtk_widget_get_default_style()->fg[0];
	/*color = gtk_widget_get_style(env->win)->fg[0];*/
	gtk_color_button_set_color(GTK_COLOR_BUTTON(fg_color_but), &color);
	/*gtk_color_button_set_use_alpha(GTK_COLOR_BUTTON(fg_color_but), TRUE);
	gtk_color_button_set_alpha(GTK_COLOR_BUTTON(fg_color_but), );*/
	return TRUE;
}

static gint use_system_bg_color_ticker(GtkWidget *widget)
{
	GdkColor color;

	widget = widget;
	color = gtk_widget_get_default_style()->bg[0];
	/*color = gtk_widget_get_style(env->win)->bg[0];*/
	gtk_color_button_set_color(GTK_COLOR_BUTTON(bg_color_but), &color);
	/*gtk_color_button_set_use_alpha(GTK_COLOR_BUTTON(bg_color_but), TRUE);
	gtk_color_button_set_alpha(GTK_COLOR_BUTTON(bg_color_but), );*/
	return TRUE;
}

static gint use_system_fg_color_clock(GtkWidget *widget)
{
	GdkColor color;

	widget = widget;
	color = gtk_widget_get_default_style()->fg[0];
	/*color = gtk_widget_get_style(env->win)->fg[0];*/
	gtk_color_button_set_color(GTK_COLOR_BUTTON(clock_fg_color_but), &color);
	/*gtk_color_button_set_use_alpha(GTK_COLOR_BUTTON(clock_fg_color_but), TRUE);
	gtk_color_button_set_alpha(GTK_COLOR_BUTTON(clock_fg_color_but), );*/
	return TRUE;
}

static gint use_system_bg_color_clock(GtkWidget *widget)
{
	GdkColor color;

	widget = widget;
	color = gtk_widget_get_default_style()->bg[0];
	/*color = gtk_widget_get_style(env->win)->bg[0];*/
	gtk_color_button_set_color(GTK_COLOR_BUTTON(clock_bg_color_but), &color);
	/*gtk_color_button_set_use_alpha(GTK_COLOR_BUTTON(clock_fbg_color_but), TRUE);
	gtk_color_button_set_alpha(GTK_COLOR_BUTTON(clock_fg_color_but), );*/
	return TRUE;
}

static gint move_to_top(GtkWidget *widget)
{
	widget = widget;
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbut_winy), 0);
	return TRUE;
}

static gint move_to_bottom(GtkWidget *widget)
{
	char	font_n_s[FONT_MAXLEN + 1];
	char	fname[FONT_NAME_MAXLEN + 1], fsize[FONT_SIZE_MAXLEN + 1];
	gint	requested_font_size, requested_h, y_bottom;
	/* We backup this param first because... */
	char	disable_popups_bak = get_params()->disable_popups;

	/* ...we want this window to always popup */
	get_params()->disable_popups = 'n';

	widget = widget;
	/* We need to know requested ticker height */
	requested_h = (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_winh));
	if (requested_h > 0 && requested_h < DRWA_HEIGHT_MIN)
		requested_h = DRWA_HEIGHT_MIN;
	else if (requested_h == 0) {
		/* Compute ticker height from requested font size */
		str_n_cpy(font_n_s, (char *)gtk_font_button_get_font_name(GTK_FONT_BUTTON(font_but)), FONT_MAXLEN);
		split_font(font_n_s, fname, fsize);
		/* In all cases, font size can't be > FONT_MAXSIZE */
		requested_font_size =  MIN(atoi(fsize), FONT_MAXSIZE);
		snprintf(fsize, FONT_SIZE_MAXLEN + 1, "%3d", requested_font_size);
		compact_font(font_n_s, fname, fsize);
		requested_h = get_layout_height_from_fnamesize(font_n_s);
	}

	y_bottom = env->screen_h - requested_h;
#ifndef G_OS_WIN32
	/* How to get taskbar height on Linux ? */
	warning(FALSE, 3, "Taskbar height: Will use ", itoa2(ARBITRARY_TASKBAR_HEIGHT),
		" pixels arbitrary value - Please adjust as necessary afterwards");
	y_bottom -= ARBITRARY_TASKBAR_HEIGHT;
#else
	if (get_win32_taskbar_height() != -1)
		y_bottom -= get_win32_taskbar_height();
	else {
		warning(FALSE, 3, "Couldn't compute Taskbar height: Will use ", itoa2(ARBITRARY_TASKBAR_HEIGHT),
			" pixels arbitrary value - Please adjust as necessary afterwards");
		y_bottom -= ARBITRARY_TASKBAR_HEIGHT;
	}
#endif
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbut_winy), y_bottom);

	get_params()->disable_popups = disable_popups_bak;
	return TRUE;
}

static gint set_full_width(GtkWidget *widget)
{
	widget = widget;
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbut_winw), env->screen_w);
	/* Will also push ticker in left corner */
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbut_winx), 0);
	return TRUE;
}

static gint get_current_url(GtkWidget *widget)
{
	widget = widget;
	gtk_entry_set_text(GTK_ENTRY(entry_homefeed), current_url);
	return TRUE;
}

/*
 * Open a dialog to edit all params.
 * Return 0 or 1 if we want to immediately reopen the dialog.
 */
int modify_params(Params *prm)
{
	char		c[2]= "c";
	gint		response;
	int		changes_have_been_applied, exit_status = 0, i;
	Params		*prm_bak;

	env = get_ticker_env();
	str_n_cpy(current_url, get_resource()->id, FILE_NAME_MAXLEN);

	gtk_window_set_keep_above(GTK_WINDOW(env->win), FALSE);

	dialog = gtk_dialog_new_with_buttons(
			"Preferences", GTK_WINDOW(env->win),
		 	GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
		 	NULL);

	set_tickr_icon_to_dialog(GTK_WINDOW(dialog));
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);

	g_signal_connect(G_OBJECT(dialog), "key-press-event", G_CALLBACK(esc_key_pressed), NULL);
	g_signal_connect(G_OBJECT(dialog), "delete_event", G_CALLBACK(force_quit_dialog), NULL);

	/* We add a scrolling feature as more parameters are getting implemented */
	sc_win = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sc_win), GTK_POLICY_AUTOMATIC,
		GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), sc_win);

	cancel_but = gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL_CLOSE);
	reset_but = gtk_dialog_add_button(GTK_DIALOG(dialog), "Reset", GTK_RESPONSE_NO);	/* Strange... */
	/* Having both 'OK' and 'Save' buttons is misleading so we only keep 'OK', which also save settings. */
	ok_but = gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_OK, GTK_RESPONSE_OK);
	apply_but = gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_APPLY, GTK_RESPONSE_APPLY);

	table = gtk_table_new(17, 5, FALSE);
	gtk_table_set_row_spacings(GTK_TABLE(table), 0);
	gtk_table_set_col_spacings(GTK_TABLE(table), 5);
	gtk_container_set_border_width(GTK_CONTAINER(table), 5);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sc_win), table);
	/* Whole window must be visible on netbooks as well */
	gtk_widget_set_size_request(sc_win, 1000, 450);

	i = 0;
#define COLUMN1		0, 1
#define COLUMN2		1, 2
#define COLUMN3		2, 3
	/*
	 * Delay
	 */
	label[i] = gtk_label_new("Delay <small>(Milliseconds)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	adj_delay = gtk_adjustment_new(prm->delay, 1, 50, 1, 5, 0);
	spinbut_delay = gtk_spin_button_new(GTK_ADJUSTMENT(adj_delay), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_delay, COLUMN2, i, i + 1);
	i++;
	/*
	 * Shift size
	 */
	label[i] = gtk_label_new("Shift size <small>(Pixels)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	adj_shiftsize = gtk_adjustment_new(prm->shift_size, 1, 200, 1, 5, 0);
	spinbut_shiftsize = gtk_spin_button_new(GTK_ADJUSTMENT(adj_shiftsize), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_shiftsize, COLUMN2, i, i + 1);
	i++;
	/*
	 * Font
	 */
	label[i] = gtk_label_new("Font <small>(Size can't be > 200)</small>:  ");/* check this is up to date */
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	font_but = gtk_font_button_new_with_font(prm->font_n_s);
	gtk_table_attach_defaults(GTK_TABLE(table), font_but, COLUMN2, i, i + 1);
	i++;
	/*
	 * fg color
	 */
	hbox1 = gtk_hbox_new(FALSE, 0);
	label[i] = gtk_label_new("Foreground color:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox1), label[i], FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox1), gtk_label_new(NULL), TRUE, FALSE, 0);
	sysfg_but = gtk_button_new_with_label("System");
	gtk_box_pack_start(GTK_BOX(hbox1), sysfg_but, FALSE, FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox1, COLUMN1, i, i + 1);
	fg_color_but = gtk_color_button_new_with_color(&prm->fg_color);
	gtk_color_button_set_use_alpha(GTK_COLOR_BUTTON(fg_color_but), TRUE);
	gtk_color_button_set_alpha(GTK_COLOR_BUTTON(fg_color_but), prm->fg_color_alpha);
	gtk_table_attach_defaults(GTK_TABLE(table), fg_color_but, COLUMN2, i, i + 1);;
	i++;
	/*
	 * bg color
	 */
	hbox2 = gtk_hbox_new(FALSE, 0);
	label[i] = gtk_label_new("Background color:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox2), label[i], FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox2), gtk_label_new(NULL), TRUE, FALSE, 0);
	sysbg_but = gtk_button_new_with_label("System");
	gtk_box_pack_start(GTK_BOX(hbox2), sysbg_but, FALSE, FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox2, COLUMN1, i, i + 1);
	bg_color_but = gtk_color_button_new_with_color(&prm->bg_color);
	gtk_color_button_set_use_alpha(GTK_COLOR_BUTTON(bg_color_but), TRUE);
	gtk_color_button_set_alpha(GTK_COLOR_BUTTON(bg_color_but), prm->bg_color_alpha);
	gtk_table_attach_defaults(GTK_TABLE(table), bg_color_but, COLUMN2, i, i + 1);
	i++;
	/*
	 * win_x
	 */
	label[i] = gtk_label_new("X position <small>(Pixels)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	adj_winx = gtk_adjustment_new(prm->win_x, 0, env->screen_w - 20, 1, 5, 0);
	spinbut_winx = gtk_spin_button_new(GTK_ADJUSTMENT(adj_winx), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_winx, COLUMN2, i, i + 1);
	i++;
	/*
	 * win_y
	 */
	hbox3 = gtk_hbox_new(FALSE, 0);
	label[i] = gtk_label_new("Y position <small>(Pixels)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox3), label[i], FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox3), gtk_label_new(NULL), TRUE, FALSE, 0);
	top_but = gtk_button_new_with_label("Top");
	gtk_box_pack_start(GTK_BOX(hbox3), top_but, FALSE, FALSE, 0);
	bottom_but = gtk_button_new_with_label("Bottom");
	gtk_box_pack_start(GTK_BOX(hbox3), bottom_but, FALSE, FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox3, COLUMN1, i, i + 1);
	adj_winy = gtk_adjustment_new(prm->win_y, 0, env->screen_h, 1, 5, 0);
	spinbut_winy = gtk_spin_button_new(GTK_ADJUSTMENT(adj_winy), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_winy, COLUMN2, i, i + 1);
	i++;
	/*
	 * win_w
	 */
	hbox4 = gtk_hbox_new(FALSE, 0);
	label[i] = gtk_label_new("Width <small>(Pixels)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox4), label[i], FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox4), gtk_label_new(NULL), TRUE, FALSE, 0);
	fullwidth_but = gtk_button_new_with_label("Full width");
	gtk_box_pack_start(GTK_BOX(hbox4), fullwidth_but, FALSE, FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox4, COLUMN1, i, i + 1);
	adj_winw = gtk_adjustment_new(prm->win_w, DRWA_WIDTH_MIN, env->screen_w, 1, 5, 0);
	spinbut_winw = gtk_spin_button_new(GTK_ADJUSTMENT(adj_winw), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_winw, COLUMN2, i, i + 1);
	i++;
	/*
	 * win_h
	 */
	label[i] = gtk_label_new("Height <small>(Pixels - Override font size if > 0</small>):  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	adj_winh = gtk_adjustment_new(prm->win_h, 0, env->screen_h, 1, 5, 0);
	spinbut_winh = gtk_spin_button_new(GTK_ADJUSTMENT(adj_winh), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_winh, COLUMN2, i, i + 1);
	i++;
	/*
	 * windec
	 */
	label[i] = gtk_label_new("Window decoration:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_windec = gtk_check_button_new();
	if (prm->windec == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_windec), TRUE);
	else if (prm->windec == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_windec), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_windec, COLUMN2, i, i + 1);
	i++;
	/*
	 * Window always-on-top
	 */
	label[i] = gtk_label_new("Window Always-On-Top:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_alwaysontop = gtk_check_button_new();
	if (prm->always_on_top == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_alwaysontop), TRUE);
	else if (prm->always_on_top == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_alwaysontop), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_alwaysontop, COLUMN2, i, i + 1);
	i++;
	/*
	 * Window transparency
	 */
	label[i] = gtk_label_new("Window opacity <small>(x 10)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	/* transparency set from gui ranges from 1 (0.1) to 10 (1.0) / 0.0 (invisible!) is kind of "useless" */
	adj_wintransparency = gtk_adjustment_new(prm->win_transparency * 10, 1, 10, 1, 2, 0);
	spinbut_wintransparency = gtk_spin_button_new(GTK_ADJUSTMENT(adj_wintransparency), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_wintransparency, COLUMN2, i, i + 1);
	i++;
	/*
	 * Icon in taskbar
	 */
	label[i] = gtk_label_new("Icon in Taskbar:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_iconintaskbar = gtk_check_button_new();
	if (prm->icon_in_taskbar == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_iconintaskbar), TRUE);
	else if (prm->icon_in_taskbar == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_iconintaskbar), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_iconintaskbar, COLUMN2, i, i + 1);
	i++;
	/*
	 * Window sticky
	 */
	label[i] = gtk_label_new("Visible on all User Desktops:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_winsticky = gtk_check_button_new();
	if (prm->win_sticky == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_winsticky), TRUE);
	else if (prm->win_sticky == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_winsticky), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_winsticky, COLUMN2, i, i + 1);
	i++;
	/*
	 * Shadow
	 */
	label[i] = gtk_label_new("Shadow:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_shadow = gtk_check_button_new();
	if (prm->shadow == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_shadow), TRUE);
	else if (prm->shadow == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_shadow), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_shadow, COLUMN2,  i, i + 1);
	i++;
	/*
	 * shadow_offset_x
	 */
	label[i] = gtk_label_new("Shadow x offset <small>(Pixels)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	adj_shadowoffsetx = gtk_adjustment_new(prm->shadow_offset_x, -20, 20, 1, 5, 0);
	spinbut_shadowoffsetx = gtk_spin_button_new(GTK_ADJUSTMENT(adj_shadowoffsetx), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_shadowoffsetx, COLUMN2, i, i + 1);
	i++;
	/*
	 * shadow_offset_y
	 */
	label[i] = gtk_label_new("Shadow y offset <small>(Pixels)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);;
	adj_shadowoffsety = gtk_adjustment_new(prm->shadow_offset_y, -20, 20, 1, 5, 0);
	spinbut_shadowoffsety = gtk_spin_button_new(GTK_ADJUSTMENT(adj_shadowoffsety), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_shadowoffsety, COLUMN2, i, i + 1);
	i++;
	/*
	 * shadow_fx
	 */
	label[i] = gtk_label_new("Shadow fx <small>(0 = none -> 10 = full)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	adj_shadowfx = gtk_adjustment_new(prm->shadow_fx, 0, 10, 1, 5, 0);
	spinbut_shadowfx = gtk_spin_button_new(GTK_ADJUSTMENT(adj_shadowfx), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_shadowfx, COLUMN2, i, i + 1);
	i++;
	/*
	 * Line delimiter
	 */
	label[i] = gtk_label_new("Line delimiter:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	entry_linedel = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(entry_linedel), DELIMITER_MAXLEN);
	gtk_entry_set_text(GTK_ENTRY(entry_linedel), prm->line_delimiter);
	gtk_table_attach_defaults(GTK_TABLE(table), entry_linedel, COLUMN2, i, i + 1);
	i++;
	/*
	 * Cut line delimiter
	 */
	label[i] = gtk_label_new("Cut line delimiter:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	entry_cutlinedel = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(entry_cutlinedel), DELIMITER_MAXLEN);
	gtk_entry_set_text(GTK_ENTRY(entry_cutlinedel), prm->cutline_delimiter);
	gtk_table_attach_defaults(GTK_TABLE(table), entry_cutlinedel, COLUMN2, i, i + 1);
	i++;
	/*
	 * Enable special chars
	 */
	label[i] = gtk_label_new("Special characters enabled <small>(Text files only)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_spchars = gtk_check_button_new();
	if (prm->special_chars == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_spchars), TRUE);
	else if (prm->special_chars == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_spchars), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_spchars, COLUMN2, i, i + 1);
	i++;
	/*
	 * 'new page' special char
	 */
	label[i] = gtk_label_new("'New page' special character:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	entry_newpagech = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(entry_newpagech), 1);
	/* This does nothing - gtk_entry_set_width_chars(GTK_ENTRY(entry_newpagech), 1);*/
	c[0] = prm->new_page_char;
	gtk_entry_set_text(GTK_ENTRY(entry_newpagech), c);
	gtk_table_attach_defaults(GTK_TABLE(table), entry_newpagech, COLUMN2,  i, i + 1);
	i++;
	/*
	 * 'tab' special char
	 */
	label[i] = gtk_label_new("'Tab' (8 spaces) special character:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	entry_tabch = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(entry_tabch), 1);
	/* This does nothing - gtk_entry_set_width_chars(GTK_ENTRY(entry_tabch), 1);*/
	c[0] = prm->tab_char;
	gtk_entry_set_text(GTK_ENTRY(entry_tabch), c);
	gtk_table_attach_defaults(GTK_TABLE(table), entry_tabch, COLUMN2, i, i + 1);
	i++;

/* Commenting this block would change from 2 columns to 1 single column window */
	label[i] = gtk_label_new("        ");
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN3, 0, 1);

	i = 0;
#undef COLUMN1
#define COLUMN1		3, 4
#undef COLUMN2
#define COLUMN2		4, 5
/* (commenting until here) */
	/*
	 * rss refresh
	 */
	label[i] = gtk_label_new("Reload delay <small>(Minutes - If no TTL or if text file)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	adj_rssrefresh = gtk_adjustment_new(prm->rss_refresh, 1, 60, 1, 5, 0);
	spinbut_rssrefresh= gtk_spin_button_new(GTK_ADJUSTMENT(adj_rssrefresh), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_rssrefresh, COLUMN2, i, i + 1);
	i++;
	/*
	 * Feed title
	 */
	label[i] = gtk_label_new("Feed title:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);;
	checkbut_feedtitle = gtk_check_button_new();
	if (prm->feed_title == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_feedtitle), TRUE);
	else if (prm->feed_title == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_feedtitle), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_feedtitle, COLUMN2, i, i + 1);
	i++;
	/*
	 * Feed title delimiter
	 */
	label[i] = gtk_label_new("Feed title delimiter:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	entry_feedtitledel = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(entry_feedtitledel), DELIMITER_MAXLEN);
	gtk_entry_set_text(GTK_ENTRY(entry_feedtitledel), prm->feed_title_delimiter);
	gtk_table_attach_defaults(GTK_TABLE(table), entry_feedtitledel, COLUMN2, i, i + 1);
	i++;
	/*
	 * Item title
	 */
	label[i] = gtk_label_new("Item title:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);;
	checkbut_itemtitle = gtk_check_button_new();
	if (prm->item_title == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_itemtitle), TRUE);
	else if (prm->item_title == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_itemtitle), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_itemtitle, COLUMN2, i, i + 1);
	i++;
	/*
	 * Item title delimiter
	 */
	label[i] = gtk_label_new("Item title delimiter:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	entry_itemtitledel = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(entry_itemtitledel), DELIMITER_MAXLEN);
	gtk_entry_set_text(GTK_ENTRY(entry_itemtitledel), prm->item_title_delimiter);
	gtk_table_attach_defaults(GTK_TABLE(table), entry_itemtitledel, COLUMN2, i, i + 1);
	i++;
	/*
	 * Item description
	 */
	label[i] = gtk_label_new("Item description:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_itemdes = gtk_check_button_new();
	if (prm->item_description == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_itemdes), TRUE);
	else if (prm->item_description == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_itemdes), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_itemdes, COLUMN2, i, i + 1);
	i++;
	/*
	 * Item description delimiter
	 */
	label[i] = gtk_label_new("Item description delimiter:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	entry_itemdesdel = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(entry_itemdesdel), DELIMITER_MAXLEN);
	gtk_entry_set_text(GTK_ENTRY(entry_itemdesdel), prm->item_description_delimiter);
	gtk_table_attach_defaults(GTK_TABLE(table), entry_itemdesdel, COLUMN2, i, i + 1);
	i++;
	/*
	 * Read n items max per feed
	 */
	label[i] = gtk_label_new("Read N items max per feed <small>(0 = no limit)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	adj_nitemsperfeed = gtk_adjustment_new(prm->n_items_per_feed, 0, 500, 1, 5, 0);
	spinbut_nitemsperfeed = gtk_spin_button_new(GTK_ADJUSTMENT(adj_nitemsperfeed), 0.0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), spinbut_nitemsperfeed, COLUMN2, i, i + 1);
	i++;
	/*
	 * Remove html tags
	 */
	label[i] = gtk_label_new("Strip html tags:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_striptags = gtk_check_button_new();
	if (prm->strip_html_tags == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_striptags), TRUE);
	else if (prm->strip_html_tags == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_striptags), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_striptags, COLUMN2, i, i + 1);
	i++;
	/*
	 * Upper case text
	 */
	label[i] = gtk_label_new("Set all text to upper case:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);;
	checkbut_uppercase = gtk_check_button_new();
	if (prm->upper_case_text == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_uppercase), TRUE);
	else if (prm->upper_case_text == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_uppercase), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_uppercase, COLUMN2, i, i + 1);
	i++;
	/*
	 * Homefeed / set current feed as homefeed
	 */
	hbox5 = gtk_hbox_new(FALSE, 0);
	label[i] = gtk_label_new("Default feed <small>('Homefeed')</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox5), label[i], FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox5), gtk_label_new(NULL), TRUE, FALSE, 0);
	curfeed_but = gtk_button_new_with_label("Get current feed");
	gtk_box_pack_start(GTK_BOX(hbox5), curfeed_but, FALSE, FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox5, COLUMN1, i, i + 1);
	entry_homefeed = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(entry_homefeed), FILE_NAME_MAXLEN);
	gtk_entry_set_text(GTK_ENTRY(entry_homefeed), prm->homefeed);
	gtk_table_attach_defaults(GTK_TABLE(table), entry_homefeed, COLUMN2, i, i + 1);
	i++;
	/*
	 * "Open in browser" command line
	 */
	label[i] = gtk_label_new("'Open in Browser' command line:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	entry_openlinkcmd = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(entry_openlinkcmd), FILE_NAME_MAXLEN);
	gtk_entry_set_text(GTK_ENTRY(entry_openlinkcmd), prm->open_link_cmd);
	gtk_table_attach_defaults(GTK_TABLE(table), entry_openlinkcmd, COLUMN2, i, i + 1);
	i++;
	/*
	 * "Open in browser" args
	 */
	label[i] = gtk_label_new("'Open in Browser' optional arguments:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	entry_openlinkargs = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(entry_openlinkargs), FILE_NAME_MAXLEN);
	gtk_entry_set_text(GTK_ENTRY(entry_openlinkargs), prm->open_link_args);
	gtk_table_attach_defaults(GTK_TABLE(table), entry_openlinkargs, COLUMN2, i, i + 1);
	i++;
	/*
	 * Clock
	 */
	label[i] = gtk_label_new("Clock:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	radio_but1_1 = gtk_radio_button_new_with_label(NULL, "Left");
	radio_but1_2 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio_but1_1), "Right");
	radio_but1_3 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio_but1_1), "None");
	rbut_box1 = gtk_hbox_new(TRUE, 2);
	gtk_box_pack_start(GTK_BOX(rbut_box1), radio_but1_1, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(rbut_box1), radio_but1_2, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(rbut_box1), radio_but1_3, TRUE, TRUE, 0);
	if (prm->clock == 'l')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_but1_1), TRUE);
	else if (prm->clock == 'r')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_but1_2), TRUE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_but1_3), TRUE);
	gtk_table_attach_defaults(GTK_TABLE(table), rbut_box1, COLUMN2, i, i + 1);
	i++;
	/*
	 * Clock font
	 */
	label[i] = gtk_label_new("Clock font <small>(Size can't be > ticker height)</small>:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	clock_font_but = gtk_font_button_new_with_font(prm->clock_font_n_s);
	gtk_table_attach_defaults(GTK_TABLE(table), clock_font_but, COLUMN2, i, i + 1);
	i++;
	/*
	 * Clock fg color
	 */
	hbox6 = gtk_hbox_new(FALSE, 0);
	label[i] = gtk_label_new("Clock foreground color:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox6), label[i], FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox6), gtk_label_new(NULL), TRUE, FALSE, 0);
	sysfgclock_but = gtk_button_new_with_label("System");
	gtk_box_pack_start(GTK_BOX(hbox6), sysfgclock_but, FALSE, FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox6, COLUMN1, i, i + 1);
	clock_fg_color_but = gtk_color_button_new_with_color(&prm->clock_fg_color);
	gtk_color_button_set_use_alpha(GTK_COLOR_BUTTON(clock_fg_color_but), TRUE);
	gtk_color_button_set_alpha(GTK_COLOR_BUTTON(clock_fg_color_but), prm->clock_fg_color_alpha);
	gtk_table_attach_defaults(GTK_TABLE(table), clock_fg_color_but, COLUMN2, i, i + 1);
	i++;
	/*
	 * Clock bg color
	 */
	hbox7 = gtk_hbox_new(FALSE, 0);
	label[i] = gtk_label_new("Clock background color:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox7), label[i], FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox7), gtk_label_new(NULL), TRUE, FALSE, 0);
	sysbgclock_but = gtk_button_new_with_label("System");
	gtk_box_pack_start(GTK_BOX(hbox7), sysbgclock_but, FALSE, FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox7, COLUMN1, i, i + 1);
	clock_bg_color_but = gtk_color_button_new_with_color(&prm->clock_bg_color);
	gtk_color_button_set_use_alpha(GTK_COLOR_BUTTON(clock_bg_color_but), TRUE);
	gtk_color_button_set_alpha(GTK_COLOR_BUTTON(clock_bg_color_but), prm->clock_bg_color_alpha);
	gtk_table_attach_defaults(GTK_TABLE(table), clock_bg_color_but, COLUMN2, i, i + 1);
	i++;
	/*
	 * Disable popups
	 */
	label[i] = gtk_label_new("Disable error/warning popup windows:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_nopopups = gtk_check_button_new();
	if (prm->disable_popups == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_nopopups), TRUE);
	else if (prm->disable_popups == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_nopopups), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_nopopups, COLUMN2, i, i + 1);
	i++;
	/*
	 * Pause on mouse-over
	 */
	label[i] = gtk_label_new("Pause ticker on mouse-over:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_mouseover = gtk_check_button_new();
	if (prm->pause_on_mouseover == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_mouseover), TRUE);
	else if (prm->pause_on_mouseover == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_mouseover), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_mouseover, COLUMN2, i, i + 1);
	i++;
	/*
	 * Disable left-ckick
	 */
	label[i] = gtk_label_new("Disable left-click:  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_noleftclick = gtk_check_button_new();
	if (prm->disable_leftclick == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_noleftclick), TRUE);
	else if (prm->disable_leftclick == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_noleftclick), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_noleftclick, COLUMN2, i, i + 1);
	i++;
	/*
	 * Mouse wheel scrolling behaviour
	 */
	label[i] = gtk_label_new("Mouse wheel scrolling applies to:  \n"
		"<small>(Ctrl + mouse wheel scrolling applies to other value)</small>");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	radio_but2_1 = gtk_radio_button_new_with_label(NULL, "Speed");
	radio_but2_2 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio_but2_1), "Feed");
	radio_but2_3 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio_but2_1), "None");
	rbut_box2 = gtk_hbox_new(TRUE, 2);
	gtk_box_pack_start(GTK_BOX(rbut_box2), radio_but2_1, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(rbut_box2), radio_but2_2, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(rbut_box2), radio_but2_3, TRUE, TRUE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_but2_1), TRUE);
	if (prm->mouse_wheel_scroll == 's')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_but2_1), TRUE);
	else if (prm->mouse_wheel_scroll == 'f')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_but2_2), TRUE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_but2_3), TRUE);
	gtk_table_attach_defaults(GTK_TABLE(table), rbut_box2, COLUMN2, i, i + 1);
	i++;
	/*
	 * Enable feed re-ordering (by user)
	 */
	label[i] = gtk_label_new("Enable feed re-ordering (by user):  ");
	gtk_label_set_use_markup(GTK_LABEL(label[i]), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label[i]), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label[i], COLUMN1, i, i + 1);
	checkbut_feedordering = gtk_check_button_new();
	if (prm->enable_feed_ordering == 'y')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_feedordering), TRUE);
	else if (prm->enable_feed_ordering == 'n')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbut_feedordering), FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), checkbut_feedordering, COLUMN2, i, i + 1);

	/* Connect buttons / widgets to callbacks */
	g_signal_connect(G_OBJECT(sysfg_but), "clicked", G_CALLBACK(use_system_fg_color_ticker), NULL);
	g_signal_connect(G_OBJECT(sysbg_but), "clicked", G_CALLBACK(use_system_bg_color_ticker), NULL);
	g_signal_connect(G_OBJECT(top_but), "clicked", G_CALLBACK(move_to_top), NULL);
	g_signal_connect(G_OBJECT(bottom_but), "clicked", G_CALLBACK(move_to_bottom), NULL);
	g_signal_connect(G_OBJECT(fullwidth_but), "clicked", G_CALLBACK(set_full_width), NULL);
	g_signal_connect(G_OBJECT(curfeed_but), "clicked", G_CALLBACK(get_current_url), NULL);
	g_signal_connect(G_OBJECT(sysfgclock_but), "clicked", G_CALLBACK(use_system_fg_color_clock), NULL);
	g_signal_connect(G_OBJECT(sysbgclock_but), "clicked", G_CALLBACK(use_system_bg_color_clock), NULL);

	/* This  will let us know if changes have been made / applied / must be applied */
	prm_bak = malloc2(sizeof(Params));
	memcpy((void *)prm_bak, (const void *)prm, sizeof(Params));
	changes_have_been_applied = FALSE;

	gtk_widget_show_all(dialog);

	while (TRUE) {
		response = gtk_dialog_run(GTK_DIALOG(dialog));
		env->suspend_rq = TRUE;
		if (response == GTK_RESPONSE_NO) {	/* Reset */
			if (question_win("Reset all settings to default values ?\n"
					"(Your current settings will be lost)") == YES) {
				/* OK like that ? */
				set_default_options(prm);
				current_feed();
				env->reload_rq = TRUE;
				exit_status = 1;
				break;
			} else
				continue;
		} else if (response == GTK_RESPONSE_APPLY || response == GTK_RESPONSE_OK) {
			/* Delay */
			prm->delay = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_delay));

			/* Shift size */
			prm->shift_size = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_shiftsize));

			/* Colors - fg and bg */
			gtk_color_button_get_color(GTK_COLOR_BUTTON(fg_color_but), &prm->fg_color);
			prm->fg_color_alpha = gtk_color_button_get_alpha(GTK_COLOR_BUTTON(fg_color_but));
			gtk_color_button_get_color(GTK_COLOR_BUTTON(bg_color_but), &prm->bg_color);
			prm->bg_color_alpha = gtk_color_button_get_alpha(GTK_COLOR_BUTTON(bg_color_but));

			/* Font */
			str_n_cpy(prm->font_n_s, (char *)gtk_font_button_get_font_name(
						GTK_FONT_BUTTON(font_but)), FONT_MAXLEN);

			/* Window x, y, w, h */
			prm->win_x = (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_winx));
			prm->win_y = (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_winy));
			prm->win_w = (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_winw));

			/* If win_h is != 0, it will override requested font size with computed one. */
			prm->win_h = (gint)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_winh));
			if (prm->win_h > 0 && prm->win_h < DRWA_HEIGHT_MIN)
				prm->win_h = DRWA_HEIGHT_MIN;

			/* Window decoration */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_windec)))
				prm->windec = 'y';
			else
				prm->windec = 'n';

			/* Window always-on-top */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_alwaysontop)))
				prm->always_on_top = 'y';
			else
				prm->always_on_top = 'n';

			/* Window transparency */
			prm->win_transparency = gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_wintransparency)) / 10;

			/* Icon in taskbar */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_iconintaskbar)))
				prm->icon_in_taskbar = 'y';
			else
				prm->icon_in_taskbar = 'n';

			/* Window sticky */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_winsticky)))
				prm->win_sticky = 'y';
			else
				prm->win_sticky = 'n';

			/* Shadow */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_shadow)))
				prm->shadow = 'y';
			else
				prm->shadow = 'n';
			prm->shadow_offset_x = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_shadowoffsetx));
			prm->shadow_offset_y = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_shadowoffsety));
			prm->shadow_fx = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_shadowfx));

			/* Line and cut line delimiters */
			str_n_cpy(prm->line_delimiter,
				(char *)gtk_entry_get_text(GTK_ENTRY(entry_linedel)), DELIMITER_MAXLEN);
			str_n_cpy(prm->cutline_delimiter,
				(char *)gtk_entry_get_text(GTK_ENTRY(entry_cutlinedel)), DELIMITER_MAXLEN);

			/* Enable special chars */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_spchars)))
				prm->special_chars = 'y';
			else
				prm->special_chars = 'n';
			prm->new_page_char = gtk_entry_get_text(GTK_ENTRY(entry_newpagech))[0];
			prm->tab_char = gtk_entry_get_text(GTK_ENTRY(entry_tabch))[0];

			/* rss refresh */
			prm->rss_refresh = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_rssrefresh));

			/* Feed title */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_feedtitle)))
				prm->feed_title = 'y';
			else
				prm->feed_title = 'n';
			str_n_cpy(prm->feed_title_delimiter,
				(char *)gtk_entry_get_text(GTK_ENTRY(entry_feedtitledel)), DELIMITER_MAXLEN);

			/* Item title */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_itemtitle)))
				prm->item_title = 'y';
			else
				prm->item_title = 'n';
			str_n_cpy(prm->item_title_delimiter,
				(char *)gtk_entry_get_text(GTK_ENTRY(entry_itemtitledel)), DELIMITER_MAXLEN);

			/* Item decription */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_itemdes)))
				prm->item_description = 'y';
			else
				prm->item_description = 'n';
			str_n_cpy(prm->item_description_delimiter,
				(char *)gtk_entry_get_text(GTK_ENTRY(entry_itemdesdel)), DELIMITER_MAXLEN);

			/* Read n items max per feed */
			prm->n_items_per_feed = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbut_nitemsperfeed));

			/* Strip html tags */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_striptags)))
				prm->strip_html_tags = 'y';
			else
				prm->strip_html_tags = 'n';

			/* Upper case text */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_uppercase)))
				prm->upper_case_text = 'y';
			else
				prm->upper_case_text = 'n';

			/* Homefeed */
			str_n_cpy(prm->homefeed,
				(char *)gtk_entry_get_text(GTK_ENTRY(entry_homefeed)), FILE_NAME_MAXLEN);

			/* Open link cmd */
			str_n_cpy(prm->open_link_cmd,
				(char *)gtk_entry_get_text(GTK_ENTRY(entry_openlinkcmd)), FILE_NAME_MAXLEN);

			/* Open link args */
			str_n_cpy(prm->open_link_args,
				(char *)gtk_entry_get_text(GTK_ENTRY(entry_openlinkargs)), FILE_NAME_MAXLEN);

			/* Clock */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_but1_1)))
				prm->clock = 'l';
			else if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_but1_2)))
				prm->clock = 'r';
			else
				prm->clock = 'n';

			str_n_cpy(prm->clock_font_n_s, (char *)gtk_font_button_get_font_name(
					GTK_FONT_BUTTON(clock_font_but)), FONT_MAXLEN);

			gtk_color_button_get_color(GTK_COLOR_BUTTON(clock_fg_color_but),
								&prm->clock_fg_color);
			prm->clock_fg_color_alpha = gtk_color_button_get_alpha(
						GTK_COLOR_BUTTON(clock_fg_color_but));
			gtk_color_button_get_color(GTK_COLOR_BUTTON(clock_bg_color_but),
								&prm->clock_bg_color);
			prm->clock_bg_color_alpha = gtk_color_button_get_alpha(
						GTK_COLOR_BUTTON(clock_bg_color_but));

			/* Disable popups */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_nopopups)))
				prm->disable_popups = 'y';
			else
				prm->disable_popups = 'n';

			/* Pause on mouse-over */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_mouseover)))
				prm->pause_on_mouseover = 'y';
			else
				prm->pause_on_mouseover = 'n';

			/* Disable left-click */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_noleftclick)))
				prm->disable_leftclick = 'y';
			else
				prm->disable_leftclick = 'n';

			/* Mouse wheel scrolling behaviour */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_but2_1)))
				prm->mouse_wheel_scroll = 's';
			else if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_but2_2)))
				prm->mouse_wheel_scroll = 'f';
			else
				prm->mouse_wheel_scroll = 'n';

			/* Enable feed re-ordering (by user) */
			if ((gboolean)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbut_feedordering)))
				prm->enable_feed_ordering = 'y';
			else
				prm->enable_feed_ordering = 'n';
		}
		/* We want a new pixmap so that changes will be effective... now! */
		if (response == GTK_RESPONSE_APPLY) {	/* Force apply */
			current_feed();
			env->reload_rq = TRUE;	/* 'compute_rq' would skip to next pixmap if any */
			g_timeout_add_full(G_PRIORITY_DEFAULT, 100, update_everything, NULL, NULL);
			changes_have_been_applied = TRUE;
			env->suspend_rq = FALSE;
		} else if (response == GTK_RESPONSE_OK) {
			if (prm->item_title == 'n' && prm->item_description == 'n')
				if (question_win("You have unchecked both 'Item title' and 'Item description'.\n"
						"No much useful information will be displayed. Continue ?") == NO)
					continue;
			/* Apply and save when necessary -> OK like that ? */
			if (memcmp((const void *)prm, (const void *)prm_bak, sizeof(Params)) != 0 || \
					changes_have_been_applied) {
				current_feed();
				env->reload_rq = TRUE;
				g_timeout_add_full(G_PRIORITY_DEFAULT, 100, update_everything, NULL, NULL);
				save_to_config_file(prm);
			}
			break;
		} else {
			/* Restore and apply when necessary -> OK like that ? */
			if (memcmp((const void *)prm, (const void *)prm_bak, sizeof(Params)) != 0 || \
					changes_have_been_applied) {
				memcpy((void *)prm, (const void *)prm_bak, sizeof(Params));
				current_feed();
				env->reload_rq = TRUE;
				g_timeout_add_full(G_PRIORITY_DEFAULT, 100, update_everything, NULL, NULL);
			}
			break;
		}
	}
	free2(prm_bak);
	gtk_widget_destroy(dialog);
	check_main_win_always_on_top();
	env->suspend_rq = FALSE;
	return exit_status;
}
