# -*- mode: rpm-spec-mode; encoding: utf-8; -*-
# Pass '--without docs' to rpmbuild if you don't want the documentation

Summary: 	Tig: text-mode interface for git
Name: 		tig
Version: 	0.7
Release: 	1%{?dist}
License: 	GPL
Group: 		Development/Tools
Vendor: 	Jonas Fonseca <fonseca@diku.dk>
URL: 		http://jonas.nitro.dk/tig/
Source: 	http://jonas.nitro.dk/tig/releases/%{name}-%{version}.tar.gz
BuildRequires: 	ncurses-devel%{!?_without_docs:, xmlto, asciidoc > 6.0.3, /usr/bin/docbook2pdf}
BuildRoot: 	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires: 	git-core, ncurses

%description
Tig is a git repository browser that additionally can act as a pager
for output from various git commands.

When browsing repositories, it uses the underlying git commands to
present the user with various views, such as summarized revision log
and showing the commit with the log message, diffstat, and the diff.

Using it as a pager, it will display input from stdin and colorize it.

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS -DVERSION=tig-%{version}-%{release}"
%{__make} %{_smp_mflags} \
	prefix=%{_prefix} \
	all %{!?_without_docs: doc}

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
CFLAGS="$RPM_OPT_FLAGS -DVERSION=tig-%{version}-%{release}"
%{__make} %{_smp_mflags} DESTDIR=$RPM_BUILD_ROOT \
	prefix=%{_prefix} bindir=%{_bindir} mandir=%{_mandir} \
	install %{!?_without_docs: install-doc-man}

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/*
%doc README COPYING INSTALL SITES BUGS TODO tigrc
%{!?_without_docs: %{_mandir}/man1/*.1*}
%{!?_without_docs: %{_mandir}/man5/*.5*}
%{!?_without_docs: %doc *.html *.pdf}

%changelog
* Mon May 28 2007 Jakub Narebski <jnareb@gmail.com>
- Initial tig spec file
