/*  gfv - a Group File View plug-in for TiLP
 *  Copyright (C) 2003  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include "interface.h"
#include "callbacks.h"
#include "support.h"

#include "tilp_plugin.h"
#include <tilp/tifiles.h>

#define GETTEXT_PACKAGE PLUGIN
#define FONT_NAME ""	//"courier"

TilpPluginInfo infos = 
{
  "Group File Viewer",
  "1.0.0",
  "Romain Lievin <roms@tilp.info>",
  "73g,82g,83g,8xg,85g,86g,89g,92g,9xg,v2g"
};


/* 
   Returns plug-ins properties/capabilites 
   - name [out]    : the plug-in name
   - version [out] : the plug-in version
   - fext [out]    : an array of file extensions
*/
TilpPluginInfo* plugin_query(void)
{
  return &infos;
}


static GtkWidget *window1;
static GtkTreeView *view;
static GtkTreeStore *tree;


/* Run plug-in */
int plugin_run(void)
{  
  GtkWidget *treeview1;

  GtkTreeModel *model;
  GtkCellRenderer *renderer;
  GtkTreeSelection *selection;
  GtkTreeViewColumn *column;
  gint i;

#ifdef ENABLE_NLS
  bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain(GETTEXT_PACKAGE);
#endif

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");

  /* Create main window */
  window1 = create_window1 ();
  gtk_window_resize(GTK_WINDOW(window1), 320, 240);
  gtk_widget_show (window1);
  
  treeview1 = gtk_object_get_data(GTK_OBJECT(window1), "treeview1");
  view = GTK_TREE_VIEW(treeview1);

  /* Create CTree (borrowed from ctree.c) */
#ifdef __WIN32__   // use UTF-8 for varnames
  tifiles_translate_set_encoding(ENCODING_LATIN1);
#else
  tifiles_translate_set_encoding(ENCODING_UNICODE);
#endif
  
  tree = gtk_tree_store_new(CTREE_NUMBER, G_TYPE_STRING,
			    GDK_TYPE_PIXBUF, G_TYPE_STRING,
			    G_TYPE_STRING, G_TYPE_POINTER,
			    G_TYPE_STRING, GDK_TYPE_PIXBUF);

  model = GTK_TREE_MODEL(tree);
  gtk_tree_view_set_model(view, model);
  gtk_tree_view_set_headers_visible(view, TRUE);
  gtk_tree_view_set_headers_clickable(view, TRUE);
  gtk_tree_view_set_rules_hint(view, FALSE);

  column = gtk_tree_view_column_new();
  gtk_tree_view_append_column(view, column);
  gtk_tree_view_column_set_title(column, _("Name"));
  renderer = gtk_cell_renderer_pixbuf_new();
  gtk_tree_view_column_pack_start(GTK_TREE_VIEW_COLUMN(column),
				  renderer, FALSE);
  gtk_tree_view_column_set_attributes(GTK_TREE_VIEW_COLUMN(column),
				      renderer, "pixbuf",
				      CTREE_ICON, NULL);
  renderer = gtk_cell_renderer_text_new();
  gtk_tree_view_column_pack_start(GTK_TREE_VIEW_COLUMN(column),
				  renderer, FALSE);
  gtk_tree_view_column_set_attributes(GTK_TREE_VIEW_COLUMN(column),
				      renderer, "text", CTREE_NAME,
				      "font", CTREE_FONT,
				      NULL);
  renderer = gtk_cell_renderer_pixbuf_new();
  gtk_tree_view_insert_column_with_attributes(view, -1, _("Attr"),
					      renderer, "pixbuf",
					      CTREE_ATTR, NULL);
  renderer = gtk_cell_renderer_text_new();
  gtk_tree_view_insert_column_with_attributes(view, -1, _("Type"),
					      renderer, "text",
					      CTREE_TYPE, NULL);
  renderer = gtk_cell_renderer_text_new();
  gtk_tree_view_insert_column_with_attributes(view, -1, _("Size"),
						    renderer, "text",
					      CTREE_SIZE, NULL);
	
  for (i = 0; i < CTREE_NCOLS; i++) {
    GtkTreeViewColumn *col;
    col = gtk_tree_view_get_column(view, i);
    gtk_tree_view_column_set_resizable(col, TRUE);
  }
  
  selection = gtk_tree_view_get_selection(view);
  gtk_tree_selection_set_mode(selection, GTK_SELECTION_NONE);
  
  return 0;
}


/* Load file */
int plugin_load(const char *filename)
{
  GtkTreeIter root_node;
  GdkPixbuf *pix1, *pix2, *pix3, *pix4, *pix5, *pix6;
  GdkPixbuf *pix9 = NULL;
  GtkTreeIter parent_node;
  GtkTreeIter child_node; 

  gchar *title;
  TicalcType calc_type;
  TiRegular  content;
  int **table;
  int num_folders;
  int i;
  int err;

  // set window title
  title = g_strconcat(_("Group File Viewer"), " (", filename, ")", NULL);
  gtk_window_set_title(GTK_WINDOW(window1), title);
  g_free(title);

  // set root node
  calc_type = tifiles_which_calc_type(filename);
  gtk_tree_store_append(tree, &root_node, NULL);
  gtk_tree_store_set(tree, &root_node, 
		     CTREE_NAME, tifiles_calctype_to_string(calc_type), 
		     CTREE_DATA, (gpointer)NULL, -1);

  // load file
  if((err = tifiles_read_regular_file(filename, &content)))
    {
      GtkWidget *dialog;
      char s[1024];

      tifiles_get_error(err, s);
      dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, 
				      GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, s);
      while (gtk_events_pending())
	gtk_main_iteration();
      gtk_dialog_run(GTK_DIALOG(dialog));
      return -1;
    }
  
  // and build the table of folder & variable entries (tree view)
  tifiles_create_table_of_entries(&content, &table, &num_folders);

  // load pixmaps
  pix1 = create_pixbuf("ctree_close_dir.xpm");
  pix2 = create_pixbuf("TIicon2.ico");
  pix3 = create_pixbuf("ctree_open_dir.xpm");
  pix4 = create_pixbuf("attr_locked.xpm");
  pix5 = create_pixbuf("attr_archived.xpm");
  pix6 = create_pixbuf("TIicon4.ico");

  // populate tree
  for(i=0; table[i] != NULL; i++)
    {
      TiVarEntry *fentry;
      int j;
      int index = table[i][0];
      gchar **row_text = g_malloc0((CTREE_NCOLS + 1) * sizeof(gchar *));
      
      fentry = &(content.entries[index]);

      row_text[0] = g_strdup(fentry->folder);
      row_text[2] = NULL;
      for(j=0; table[i][j] != -1; j++);
      row_text[3] = g_strdup_printf("%i", j);

      gtk_tree_store_append(tree, &parent_node, &root_node);
      gtk_tree_store_set(tree, &parent_node, 
			 CTREE_NAME, row_text[0],
			 CTREE_SIZE, row_text[3],
			 CTREE_DATA, (gpointer) fentry,
			 CTREE_ICON, pix1, -1);

      g_strfreev(row_text);
      
      for(j=0; table[i][j] != -1; j++)
	{
	  int index = table[i][j];
	  TiVarEntry *entry = &(content.entries[index]);
	  gchar **row_text = g_malloc0((CTREE_NCOLS + 1) * sizeof(gchar *));
	  char icon_name[256];

	  row_text[0] = g_strdup(entry->trans);
	  //printf("<<%s>>\n", row_text[0]);
	  //hexdump(row_text[0], 9);
	  row_text[2] = g_strdup_printf("%s", 
					tifiles_vartype2string(entry->type));
	  row_text[3] = g_strdup_printf("%u", entry->size);
	
	  strcpy(icon_name, tifiles_vartype2icon(entry->type));
	  strcat(icon_name, ".ico");
	  tilp_file_underscorize(icon_name);
	  pix9 = create_pixbuf(icon_name);
	  
	  gtk_tree_store_append(tree, &child_node, &parent_node);
	  gtk_tree_store_set(tree, &child_node, 
			     CTREE_NAME, row_text[0],
			     CTREE_TYPE, row_text[2], 
			     CTREE_SIZE, row_text[3], 
			     CTREE_DATA, (gpointer) entry, 
			     CTREE_ICON, pix9,
			     CTREE_FONT, FONT_NAME,
			     -1);
	  
	  switch (entry->attr) {
	  case ATTRB_LOCKED:
	    gtk_tree_store_set(tree, &child_node, CTREE_ATTR, pix4, -1);
	    break;
	  case ATTRB_ARCHIVED:
	    gtk_tree_store_set(tree, &child_node, CTREE_ATTR, pix5, -1);
	    break;
	  default:
	    break;
	  }
	  g_object_unref(pix9);
	  g_strfreev(row_text);
	}
    }

  gtk_tree_view_expand_all(view);
  
  // release file
  tifiles_free_regular_content(&content);

  // and icons
  g_object_unref(pix1);
  g_object_unref(pix2);
  g_object_unref(pix3);
  g_object_unref(pix4);
  g_object_unref(pix5);
  g_object_unref(pix6);
  
  return 0;
}

/* Save file */
int plugin_save(const char *filename)
{
// no saving
  return 0;
}


#ifdef MAIN
int
main (int argc, char *argv[])
{
  GtkWidget *window1;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  window1 = create_window1 ();
  gtk_widget_show (window1);

  gtk_main ();
  return 0;
}
#endif
