/*
 * Copyright (C) 2004 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "prefs-dialog.h"
#include "timer-applet.h"
#include <panel-applet-gconf.h>

static void
on_show_time_changed (GtkWidget *check_button, PanelApplet *applet)
{
	gboolean value;

	g_assert (applet);
	
	g_object_get (GTK_CHECK_BUTTON (check_button), "active", &value, NULL);
	
	panel_applet_gconf_set_bool (applet, SHOW_REMAINING_TIME_KEY, value, NULL);
}

static void
on_play_sound_changed (GtkWidget *check_button, PanelApplet *applet)
{
	gboolean value;

	g_assert (applet);
	
	g_object_get (GTK_CHECK_BUTTON (check_button), "active", &value, NULL);
	
	panel_applet_gconf_set_bool (applet, PLAY_NOTIFICATION_SOUND_KEY, value, NULL);
}

static void
on_always_on_top_changed (GtkWidget *check_button, PanelApplet *applet)
{
	gboolean value;

	g_assert (applet);
	
	g_object_get (GTK_CHECK_BUTTON (check_button), "active", &value, NULL);
	
	panel_applet_gconf_set_bool (applet, NOTIFICATION_DIALOG_ALWAYS_ON_TOP_KEY, value, NULL);
}

static void
on_sticky_dialog_changed (GtkWidget *check_button, PanelApplet *applet)
{
	gboolean value;

	g_assert (applet);
	
	g_object_get (GTK_CHECK_BUTTON (check_button), "active", &value, NULL);
	
	panel_applet_gconf_set_bool (applet, NOTIFICATION_DIALOG_STICKY_KEY, value, NULL);
}

static void
on_prefs_dialog_response (GtkDialog *dialog, gint response, gpointer user_data)
{
	switch (response) {
		case GTK_RESPONSE_CLOSE:
			gtk_widget_hide (GTK_WIDGET (dialog));
			break;
			
		case GTK_RESPONSE_DELETE_EVENT:
			g_print ("delete event");
			break;
			
		default:
			g_assert_not_reached ();
	}
}


GtkWidget *
prefs_dialog_new (PanelApplet *applet)
{
	GtkWidget *prefs_dialog;
	GtkWidget *main_vbox;
	GtkWidget *check_show_time;
	GtkWidget *check_play_sound;
	GtkWidget *check_always_on_top;
	GtkWidget *check_sticky_dialog;
	
	prefs_dialog = gtk_dialog_new_with_buttons (_("Timer Preferences"), NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL);
	
	g_object_set (G_OBJECT (prefs_dialog),
			"has-separator", FALSE,
			"border-width", 0,
			NULL);
	
	g_assert (applet);
	g_object_set_data (G_OBJECT (prefs_dialog), "panel-applet", applet);
	
	main_vbox = gtk_vbox_new (FALSE, 18);
	g_object_set (G_OBJECT (main_vbox), "border-width", 12, NULL);
	
	gtk_widget_ensure_style (prefs_dialog);
	g_object_set (G_OBJECT (GTK_DIALOG (prefs_dialog)->vbox), "border-width", 0, NULL);
	g_object_set (G_OBJECT (GTK_DIALOG (prefs_dialog)->action_area), "border-width", 12, NULL);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (prefs_dialog)->vbox), main_vbox, TRUE, TRUE, 0);
	gtk_widget_show (main_vbox);
	
	
	check_show_time = gtk_check_button_new_with_mnemonic (_("_Show remaining time in panel"));
	gtk_box_pack_start (GTK_BOX (main_vbox), check_show_time, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (check_show_time), "toggled", G_CALLBACK (on_show_time_changed), applet);
	g_object_set_data (G_OBJECT (prefs_dialog), "prefs-show-remaining-time", check_show_time);
	
	
	check_play_sound = gtk_check_button_new_with_mnemonic (_("_Play notification sound"));
	gtk_box_pack_start (GTK_BOX (main_vbox), check_play_sound, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (check_play_sound), "toggled", G_CALLBACK (on_play_sound_changed), applet);
	g_object_set_data (G_OBJECT (prefs_dialog), "prefs-play-notification-sound", check_play_sound);
	
	check_always_on_top = gtk_check_button_new_with_mnemonic (_("_Keep notification dialog on top of all other windows"));
	gtk_box_pack_start (GTK_BOX (main_vbox), check_always_on_top, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (check_always_on_top), "toggled", G_CALLBACK (on_always_on_top_changed), applet);
	g_object_set_data (G_OBJECT (prefs_dialog), "prefs-notification-dialog-always-on-top", check_always_on_top);
	
	check_sticky_dialog = gtk_check_button_new_with_mnemonic (_("_Display notification dialog on all workspaces"));
	gtk_box_pack_start (GTK_BOX (main_vbox), check_sticky_dialog, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (check_sticky_dialog), "toggled", G_CALLBACK (on_sticky_dialog_changed), applet);
	g_object_set_data (G_OBJECT (prefs_dialog), "prefs-notification-dialog-sticky", check_sticky_dialog);
	
	prefs_dialog_update (GTK_DIALOG (prefs_dialog));
	
	
	g_signal_connect (G_OBJECT (prefs_dialog), "response", G_CALLBACK (on_prefs_dialog_response), NULL);
	g_signal_connect (G_OBJECT (prefs_dialog), "delete-event", G_CALLBACK (gtk_widget_hide_on_delete), NULL);
	
	
	gtk_widget_show (check_show_time);
	gtk_widget_show (check_play_sound);
	gtk_widget_show (check_always_on_top);
	gtk_widget_show (check_sticky_dialog);

	return prefs_dialog;
}

void
prefs_dialog_open (GtkDialog *prefs_dialog)
{
	g_assert (prefs_dialog);

	gtk_window_present (GTK_WINDOW (prefs_dialog));
}

void
prefs_dialog_update (GtkDialog *prefs_dialog)
{
	gboolean show_time;
	gboolean play_sound;
	gboolean always_on_top;
	gboolean sticky_dialog;
	PanelApplet *applet;
	
	applet = g_object_get_data (G_OBJECT (prefs_dialog), "panel-applet");
	g_assert (applet);
	
	show_time = panel_applet_gconf_get_bool (applet, SHOW_REMAINING_TIME_KEY, NULL);
	play_sound = panel_applet_gconf_get_bool (applet, PLAY_NOTIFICATION_SOUND_KEY, NULL);
	always_on_top = panel_applet_gconf_get_bool (applet, NOTIFICATION_DIALOG_ALWAYS_ON_TOP_KEY, NULL);
	sticky_dialog = panel_applet_gconf_get_bool (applet, NOTIFICATION_DIALOG_STICKY_KEY, NULL);

	{
		GtkWidget *prefs_show_remaining_time;
		GtkWidget *prefs_play_notification_sound;
		GtkWidget *prefs_notification_dialog_always_on_top;
		GtkWidget *prefs_notification_dialog_sticky;

		prefs_show_remaining_time = g_object_get_data (G_OBJECT (prefs_dialog), "prefs-show-remaining-time");
		prefs_play_notification_sound = g_object_get_data (G_OBJECT (prefs_dialog), "prefs-play-notification-sound");
		prefs_notification_dialog_always_on_top = g_object_get_data (G_OBJECT (prefs_dialog), "prefs-notification-dialog-always-on-top");
		prefs_notification_dialog_sticky = g_object_get_data (G_OBJECT (prefs_dialog), "prefs-notification-dialog-sticky");
		g_assert (prefs_show_remaining_time);
		g_assert (prefs_play_notification_sound);
		g_assert (prefs_notification_dialog_always_on_top);
		g_assert (prefs_notification_dialog_sticky);

		g_object_set (G_OBJECT (prefs_show_remaining_time), "active", show_time, NULL);
		g_object_set (G_OBJECT (prefs_play_notification_sound), "active", play_sound, NULL);
		g_object_set (G_OBJECT (prefs_notification_dialog_always_on_top), "active", always_on_top, NULL);
		g_object_set (G_OBJECT (prefs_notification_dialog_sticky), "active", sticky_dialog, NULL);
	}
}
