/*
 * Copyright (C) 2004 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef PROFILE_MANAGER_H
#define PROFILE_MANAGER_H

#include <gtk/gtk.h>

#define MAX_PROFILE_NAME_LENGTH		255



/**
 * NOTE: If this is going to be made into a real GtkWidget, might want to make it emit
 * the "empty" and "not empty" signals so we know when to enable certain buttons.
 */

/* Profile manager provides a GtkModel format for users to construct a GtkModel that
 * can be used with this profile manager. The profile manager will then automatically
 * add, remove, or edit profiles based on actions in the manager area. The user can
 * connect to provided signals to add additional actions in reacting to certain button click events.
 */
enum
{
	PROFILE_DISPLAY_NAME_COL,
	PROFILE_NAME_COL,
	PROFILE_DURATION_COL,
	NUM_PROFILE_COLS
};

typedef void (*ViewEmptyCallback) (GtkWidget *profile_manager);
typedef void (*ViewNotEmptyCallback) (GtkWidget *profile_manager);
typedef void (*SelectionEmptyCallback) (GtkWidget *profile_manager);
typedef void (*SelectionNotEmptyCallback) (GtkWidget *profile_manager);
typedef void (*RowSelectedCallback) (GtkWidget *profile_manager, gpointer data);

typedef void (*ProfileManagerAddedCallback) (GtkWidget *add_profile_dialog, gchar *profile_name, gdouble profile_duration, gpointer user_data);
typedef void (*ProfileManagerEditedCallback) (GtkWidget *add_profile_dialog, GtkTreeRowReference *row_ref, gchar *profile_name, gdouble profile_duration, gpointer user_data);
typedef void (*ProfileManagerDeletedCallback) (GtkWidget *add_profile_dialog, GtkTreeRowReference *row_ref, gpointer user_data);

GtkWidget *
profile_manager_new (GtkTreeModel *tree_model);
GtkTreeRowReference *
profile_manager_get_selected_profile (GtkWidget *profile_manager);
GtkTreeRowReference *
profile_manager_delete_selection (GtkWidget *profile_manager, GtkWidget *parent_window);
void
profile_manager_select_row (GtkWidget *profile_manager, GtkTreeRowReference *row_ref);
void
profile_manager_select_first_row (GtkWidget *profile_manager);
void
profile_manager_connect_row_selected (GtkWidget *profile_manager, RowSelectedCallback row_activated_cb, gpointer user_data);
void
profile_manager_set_view_change_handlers (GtkWidget *profile_manager, ViewEmptyCallback empty_cb, ViewNotEmptyCallback not_empty_cb);
void
profile_manager_set_selection_change_handlers (GtkWidget *profile_manager, SelectionEmptyCallback empty_cb,
													SelectionNotEmptyCallback not_empty_cb);
void
profile_manager_set_profile_handlers (GtkWidget *profile_manager, ProfileManagerAddedCallback added_cb, gpointer user_data1,
				ProfileManagerEditedCallback edited_cb, gpointer user_data2, ProfileManagerDeletedCallback deleted_cb, gpointer user_data3);
GtkWidget *
profile_manager_get_tree_view (GtkWidget *profile_manager);
#endif /* PROFILE_MANAGER_H */
