/*
 * Copyright (C) 2004 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef TIMER_APPLET_H
#define TIMER_APPLET_H
#include <gtk/gtk.h>
#include <panel-applet.h>

#define SHOW_REMAINING_TIME_KEY			"show_remaining_time"
#define PLAY_NOTIFICATION_SOUND_KEY		"play_notification_sound"
#define USE_CUST_NOTIFICATION_SOUND_KEY		"use_custom_notification_sound"
#define CUST_NOTIFICATION_SOUND_PATH_KEY	"custom_notification_sound_path"
#define NOTIFICATION_DIALOG_STICKY_KEY		"notification_dialog_sticky"
#define NOTIFICATION_DIALOG_ALWAYS_ON_TOP_KEY	"notification_dialog_always_on_top"
#define MAX_NUM_HOURS				48

/**
 * Timer Applet States:
 * timer == NULL && !timer_running means timer applet has not started or is done
 * timer != NULL && !timer_running means timer applet is paused
 * timer != NULL && timer_running means timer applet is running
 * timer == NULL && timer_running is impossible
 */

typedef struct _TimerApplet
{
	PanelApplet *applet;
	
	
	/* Whether the timer is currently running or paused. */
	gboolean timer_running;
	/* timer is NULL if the timer has not started or has finished */
	GTimer *timer;
	
	
	/* Current profile */
	gchar *cur_profile_name;
	gdouble cur_profile_duration;
	
	
	/* Main applet interface */
	/* This allows us to destroy and re-construct the button with or without the label */
	GtkWidget *main_button;
	/* Keep a pointer to the image around just in case we
	 * need to dim it when the timer is inactive.
	 */
	GtkWidget *main_button_layout_box;
	GtkWidget *main_image;
	GtkWidget *main_remaining_time_label;
	/* Keep a pointer to the tooltips so we can update
	 * its display of the remaining time.
	 */
	GtkTooltips *main_tooltips;
	
	
	/* Start timer dialog */
	GtkWidget *start_timer_dialog;
	GtkWidget *start_timer_profile_manager_widget;
	
	
	/* Preferences dialog */
	GtkWidget *prefs_dialog;
	

	guint gconf_notification_id;
	gulong presets_changed_handler_id;
} TimerApplet;

void
timer_applet_init (TimerApplet *timer_applet, PanelApplet *panel_applet);
GtkTreeRowReference *
timer_applet_add_preset (const gchar *name, gdouble duration);
void
timer_applet_remove_preset (GtkTreeRowReference *row_ref);
void
timer_applet_update_preset (GtkTreeRowReference *row_ref, gchar *name, gdouble duration);
void
timer_applet_get_profile_name_and_duration (TimerApplet *timer_applet, GtkTreeRowReference *row_ref, gchar **name, gdouble *duration);
gboolean
timer_applet_profile_name_exists (TimerApplet *timer_applet, gchar *input_name);
void
timer_applet_start_timer (TimerApplet *timer_applet, const gchar *preset_name, gdouble timer_duration);
GtkListStore *
timer_applet_get_presets_list (void);
gdouble
timer_applet_get_remaining_time (TimerApplet *timer_applet);

#endif /* TIMER_APPLET_H */
