/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 363 $
 * $Date: 2012-01-22 18:45:43 +0800 (Sun, 22 Jan 2012) $
 */
#ifndef INDII_IMAGE_MASKCACHE_HPP
#define INDII_IMAGE_MASKCACHE_HPP

#include "wx/image.h"
#include "wx/bitmap.h"

#include <map>

namespace indii {
/**
 * Cache of various masks of an image.
 */
class MaskCache {
public:
  /**
   * Constructor.
   *
   * @param image Original image representing mask. wxBLACK represents
   * background, wxWHITE foreground.
   */
  MaskCache(wxImage* image);
      
  /**
   * Destructor.
   */
  virtual ~MaskCache();
  
  /**
   * Get resized mask.
   *
   * @param width Width of the image.
   * @param height Height of the image.
   *
   * @return The resized mask. Caller has ownership.
   *
   * If either @p width or @p height is <= 0, a mask of the original size is
   * returned.
   */
  wxMask* get(const int width = 0, const int height = 0);

private:
  /**
   * Image dimension.
   */
  typedef std::pair<const int, const int> dim_t;
  
  /**
   * Image cache.
   */
  typedef std::map<dim_t,wxBitmap*> cache_t;
  
  /**
   * Image cache pair.
   */
  typedef std::pair<dim_t,wxBitmap*> cache_pair_t;
  
  /**
   * Original mask image.
   */
  wxImage* original;

  /**
   * Original mask.
   */
  wxBitmap* originalMask;
  
  /**
   * Cache.
   */
  cache_t cache;
  
};
}

#endif
