##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# $Id: main.py 1833 2005-12-14 16:43:42Z nicoe $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import webbrowser

import gtk
from gtk import glade
import gettext
import time

import string
import rpc

import service
import options
import common

from window import win_preference
import webbrowser

def _login_ask():
	uid = 0
	win_gl = glade.XML(common.terp_path("terp.glade"),"win_login",gettext.textdomain())
	win = win_gl.get_widget('win_login')
	login=win_gl.get_widget('ent_login')
	passwd=win_gl.get_widget('ent_passwd')
	host=win_gl.get_widget('ent_host')
	port=win_gl.get_widget('ent_port')

	passwd.set_activates_default(True)
	login.set_activates_default(True)
	host.set_activates_default(True)
	port.set_activates_default(True)

	port.set_text(options.options['login.port'])
	host.set_text(options.options['login.server'])
	login.set_text(options.options['login.login'])

	res = win.run()
	if res == gtk.RESPONSE_CANCEL:
		win.destroy()
		raise 'QueryCanceled'
	result = (login.get_text(), passwd.get_text(), host.get_text(), port.get_text())
	win.destroy()
	return result

class terp_main(service.Service):
	def __init__(self, name='gui.main', audience='gui.*'):
		service.Service.__init__(self, name, audience)
		self.exportMethod(self.win_add)

		self.glade = glade.XML(common.terp_path("terp.glade"),"win_main",gettext.textdomain())
		self.status_bar = self.glade.get_widget('sb_main')
		self.toolbar = self.glade.get_widget('main_toolbar')
		self.sb_requests = self.glade.get_widget('sb_requests')
		self.sb_username = self.glade.get_widget('sb_user_name')
		self.sb_servername = self.glade.get_widget('sb_user_server')

		window = self.glade.get_widget('win_main')
		window.connect("destroy", self.sig_quit)
		window.connect("delete_event", self.sig_delete)
		self.window = window

		self.notebook = gtk.Notebook()
		self.notebook.popup_enable()
		self.sig_id = self.notebook.connect_after('switch-page', self._sig_page_changt)
		vbox = self.glade.get_widget('vbox_main')
		vbox.pack_start(self.notebook, expand=True, fill=True)
		
		self.notebook.show()
		self.pages = []
		self.current_page = 0
		self.last_page = 0

		dict = {
			'on_hello_world_activate': (lambda x: self.message(_('Hello World!'))),
			'on_login_activate': self.sig_login,
			'on_logout_activate': self.sig_logout,
			'on_win_next_activate': self.sig_win_next,
			'on_win_prev_activate': self.sig_win_prev,
			'on_plugin_execute_activate': self.sig_plugin_execute,
			'on_quit_activate': self.sig_close,
			'on_help_tips_activate': self.sig_tips,
			'on_win_new_activate': self.sig_win_new,
			'on_win_close_activate': self.sig_win_close,
			'on_preference_activate': self.sig_context,
			'on_read_requests_activate': self.sig_request_open,
			'on_send_request_activate': self.sig_request_new,
			'on_request_wait_activate': self.sig_request_wait,
			'on_opt_save_activate': lambda x: options.options.save() and self.message(_('Options saved!')),
			'on_about_activate': self.sig_about,
			'on_help_licence_activate': self.sig_licence,
		    'on_website_help_index_activate': self.sig_webhelp,
		    'on_website_contextual_help_activate': self.sig_webcontext,
			'on_menubar_icons_activate': lambda x: self.sig_menubar('icons'),
			'on_menubar_text_activate': lambda x: self.sig_menubar('text'),
			'on_help_index_activate': self.sig_help_index,
			'on_help_contextual_activate': self.sig_help_context,
			'on_help_cprocessus_activate': self.sig_help_processus,
			'on_menubar_both_activate': lambda x: self.sig_menubar('both')
		}
		for signal in dict:
			self.glade.signal_connect(signal, dict[signal])

		self.buttons = {}
		for button in ('but_new', 'but_save', 'but_remove', 'but_search', 'but_previous', 'but_next', 'but_action', 'but_open', 'but_print', 'but_close', 'but_reload', 'but_switch','but_attach', 'but_preference'):
			self.glade.signal_connect('on_'+button+'_clicked', self._sig_child_call, button)
			self.buttons[button]=self.glade.get_widget(button)

		menus = {
			'form_del': 'but_remove',
			'form_preference': 'but_preference',
			'form_new': 'but_new',
			'form_copy': 'but_copy',
			'form_reload': 'but_reload',
			'form_log': 'but_log',
			'form_open': 'but_open',
			'form_search': 'but_search',
			'form_previous': 'but_previous',
			'form_next': 'but_next',
			'form_save': 'but_save',
			'goto_id': 'but_goto_id',
			'form_print': 'but_print',
			'form_print_html': 'but_print_html',
			'form_save_as': 'but_save_as',
			'form_import': 'but_import',
			'form_filter': 'but_filter',
			'form_repeat': 'but_print_repeat'
		}
		for menu in menus:
			self.glade.signal_connect('on_'+menu+'_activate', self._sig_child_call, menus[menu])

#		scheduler.handler_register('window', None, self._view_handler)
#		scheduler.handler_register('window_form', None, self._view_handler_form)
#		scheduler.handler_register('window_action', None, self._view_handler_action)

		spool = service.LocalService('spool')
		spool.subscribe('gui.window', self.win_add)

		self.message(_('Welcome to Tiny Enterprise Resource Planing !'))
		self.sb_set()

		def fnc_menuitem(menuitem, opt_name):
			options.options[opt_name] = menuitem.get_active()
		dict = {
			'on_opt_print_preview_activate': (fnc_menuitem, 'printer.preview', 'opt_print_preview'),
		}
		for signal in dict:
			self.glade.signal_connect(signal, dict[signal][0], dict[signal][1])
			self.glade.get_widget(dict[signal][2]).set_active(int(bool(options.options[dict[signal][1]])))

	def sig_help_index(self, widget):
		webbrowser.open('http://tinyerp.org/docs/index.php/UserManual/HomePage.html')

	def sig_help_processus(self, widget):
		model = self._wid_get().model
		webbrowser.open('http://tinyerp.org/docs/context_index.php?model=%s' % model)

	def sig_help_context(self, widget):
		model = self._wid_get().model
		webbrowser.open('http://tinyerp.org/docs/context_index.php?model=%s' % model)

	def sig_tips(self, *args):
		common.tipoftheday()

	def sig_menubar(self, option):
		if option=='both':
			self.toolbar.set_style(gtk.TOOLBAR_BOTH)
		elif option=='text':
			self.toolbar.set_style(gtk.TOOLBAR_TEXT)
		elif option=='icons':
			self.toolbar.set_style(gtk.TOOLBAR_ICONS)

	def sig_win_next(self, args):
		pn = self.notebook.get_current_page()
		if pn == len(self.pages)-1:
			pn = -1
		self.notebook.set_current_page(pn+1)

	def sig_win_prev(self, args):
		pn = self.notebook.get_current_page()
		self.notebook.set_current_page(pn-1)

	def sig_context(self, *args):
		actions = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.values', 'get', 'meta', False, [('res.users',False)], True, rpc.session.context, True)

		win = win_preference.win_preference('res.users', rpc.session.uid, actions)
		if win.run():
			rpc.session.context_reload()
		return True

	def sig_win_close(self, *args):
		self._sig_child_call(args[0], 'but_close')

	def sig_request_new(self, args=None):
		obj = service.LocalService('gui.window')
		obj.create(None, 'res.request', False, [('act_from','=',rpc.session.uid)], 'form')

	def sig_request_open(self, args=None):
		ids,ids2 = self.request_set()
		obj = service.LocalService('gui.window')
		view_id = rpc.session.rpc_exec_auth('/object','execute','ir.ui.view','search',[('name','=','res.request.form')])
		obj.create((view_id and view_id[0]) or None, 'res.request', ids, [('act_to','=',rpc.session.uid)], 'tree')

	def sig_request_wait(self, args=None):
		ids,ids2 = self.request_set()
		obj = service.LocalService('gui.window')
		view_id = rpc.session.rpc_exec_auth('/object','execute','ir.ui.view','search',[('name','=','res.request.form')])
		obj.create((view_id and view_id[0]) or None, 'res.request', ids, [('act_from','=',rpc.session.uid), ('state','=','waiting')], 'tree')

	def request_set(self):
		uid = rpc.session.uid
		ids,ids2 = rpc.session.rpc_exec_auth('/object', 'execute', 'res.request', 'request_get')
		if len(ids):
			message = str(len(ids))+_(' request(s)')
		else:
			message = _('No request')
		if len(ids2):
			message += ' - '+str(len(ids2))+_(' pending request(s)')
		id = self.sb_requests.get_context_id('message')
		self.sb_requests.push(id, message)
		return (ids,ids2)


	def sig_login(self, widget=None):
		if rpc.session.logged():
			self.message(_('You are already logged!'))
		else:
			try:
				try:
					res = _login_ask()
				except 'QueryCanceled':
					return False
				log_response = rpc.session.login(res[0], res[1], res[2], res[3])
				if log_response==1:
					options.options['login.server'] = res[2]
					options.options['login.login'] = res[0]
					options.options['login.port'] = res[3]
					options.options.save()
					self.sig_win_new()
					self.request_set()
				elif log_response==-1:
					common.message(_('Connection error !\nUnable to connect to the server !'))
				elif log_response==-2:
					common.message(_('Connection error !\nBad username or password !'))
			except rpc.rpc_exception, e:
				(e1,e2) = e
				rpc.session.logout()
				common.error(_('Connection Error !'),e1,e2)
		return True

	def sig_licence(self, widget):
		about=glade.XML(common.terp_path("terp.glade"), "win_licence", gettext.textdomain())
		about.signal_connect("on_but_ok_pressed", lambda obj: about.get_widget('win_licence').destroy() )

	def sig_webhelp(self, widget):
		webbrowser.open('http://tinyerp.org/docs/index.php/HomePage.html')

	def sig_webcontext(self, widget):
		model = self._wid_get().model
		webbrowser.open('http://tinyerp.org/docs/context_index.php?model=%s' % model)

	def sig_about(self, widget):
		about=glade.XML(common.terp_path("terp.glade"), "win_about", gettext.textdomain())
		buffer = about.get_widget('textview2').get_buffer()
		about_txt = buffer.get_text(buffer.get_start_iter(), buffer.get_end_iter())
		buffer.set_text(about_txt % options.options['version'])
		about.signal_connect("on_but_ok_pressed", lambda obj: about.get_widget('win_about').destroy() )

	def sig_win_new(self, widget=None):
		act_id = rpc.session.rpc_exec_auth('/object', 'execute', 'res.users', 'read', [rpc.session.uid], ['action_id','name'], rpc.session.context)
		id = self.sb_username.get_context_id('message')
		self.sb_username.push(id, act_id[0]['name'] or '')
		id = self.sb_servername.get_context_id('message')
		self.sb_servername.push(id, rpc.session._url)
		act_id = act_id[0]['action_id'][0]
		obj = service.LocalService('action.main')
		win = obj.execute(act_id, {'window':self.window}, 'ir.actions.act_window')

	def sig_plugin_execute(self, widget):
		import plugins
		pn = self.notebook.get_current_page()
		datas = {'model': self.pages[pn].model, 'ids':self.pages[pn].ids_get(), 'id' : self.pages[pn].id_get()}
		plugins.execute(datas)

	def sig_req_read(self, widget):
		while self._win_del():
			pass
		rpc.session.logout()
		self.message(_('You are logged out. Press Ctrl+O to login'))

	def sig_logout(self, widget):
		while self._win_del():
			pass
		id = self.sb_requests.get_context_id('message')
		self.sb_requests.push(id, '')
		id = self.sb_username.get_context_id('message')
		self.sb_username.push(id, _('Not logged !'))
		rpc.session.logout()

	def sig_quit(self, widget):
		gtk.main_quit()

	def sig_close(self, widget):
		if common.sur(_("Do you really want to quit ?")):
			gtk.main_quit()

	def sig_delete(self, widget, event, data=None):
		return not common.sur(_("Do you really want to quit ?"))

	def win_add(self, win, datas):
		self.pages.append(win)
		self.notebook.append_page(win.widget, gtk.Label(win.name))
		self.notebook.set_current_page(-1)

	def message(self, message):
		id = self.status_bar.get_context_id('message')
		self.status_bar.push(id, message)

	def sb_set(self, view=None):
		if view==None:
			view = self._wid_get()
		if view:
			self.message(_('^N New   ^S Save   ^D Delete   ^F Search   ^X Next   ^Z Previous   ^R Repeat'))
		else:
			self.message(_('Press Ctrl+O to login'))
		for x in self.buttons:
			if self.buttons[x]:
				self.buttons[x].set_sensitive(view and (x in view.handlers))


	def _win_del(self):
		pn = self.notebook.get_current_page()
		if pn != -1:
			self.notebook.disconnect(self.sig_id)
			self.pages.pop(pn)
			self.notebook.remove_page(pn)
#			if self.last_page > self.current_page :
#				self.notebook.set_current_page(self.last_page-1)
#			else:
#				self.notebook.set_current_page(self.last_page)
			self.sig_id = self.notebook.connect_after('switch-page', self._sig_page_changt)
			self.sb_set()
		return self.notebook.get_current_page() != -1

	def _wid_get(self):
		pn = self.notebook.get_current_page()
		if pn == -1:
			return False
		return self.pages[pn]

	def _sig_child_call(self, widget, button_name, *args):
		wid = self._wid_get()
		if wid:
			res = True
			if button_name in wid.handlers:
				res = wid.handlers[button_name][1]()
			if button_name=='but_close' and res:
				self._win_del()

	def _sig_page_changt(self, widget=None, *args): 
		self.last_page = self.current_page
		self.current_page = self.notebook.get_current_page()
		self.sb_set()

