##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gtk
from gtk import glade
import gobject
import gettext
import xmlrpclib

from view_tree import parse
import rpc
import common
import service

fields_list_type = {
	'checkbox': gobject.TYPE_BOOLEAN
}

class win_filter(object):
	def __init__(self, model, ids, sel_multi=True):
		self.sel_multi = sel_multi
		self.glade = glade.XML(common.terp_path("terp.glade"),'win_filter',gettext.textdomain())
		self.win = self.glade.get_widget('win_filter')

		vbox = self.glade.get_widget('filter_action_vbox')
		for action in rpc.session.rpc_exec_auth('/object', 'execute', 'ir.values', 'get', 'action', 'client_action_multi', [(model,False)], False, rpc.session.context):
			bt = gtk.Button(action[2]['name'])
			bt.show()
			vbox.pack_start(bt, expand=False, fill=False)
			bt.connect('clicked', self.sig_action, action[2])

		dict = {
			'on_but_select_clicked': self.sig_select,
			'on_but_unselect_clicked': self.sig_unselect,
			'on_but_sel_all_clicked': self.sig_sel_all,
			'on_but_sel_none_clicked': self.sig_sel_none
		}
		for signal in dict:
			self.glade.signal_connect(signal, dict[signal])

		vp = self.glade.get_widget('filter_vp_tree')
		self.view = gtk.TreeView()
		vp.add(self.view)
		if not sel_multi:
			self.view.get_selection().set_mode('single')
		else:
			self.view.get_selection().set_mode(gtk.SELECTION_MULTIPLE)

		view = rpc.session.rpc_exec_auth('/object', 'execute', model, 'fields_view_get', False, 'tree')

		p = parse.parse(view['fields'])
		p.parse(view['arch'], self.view)
		self.view.set_expander_column(self.view.get_column(1))
		self.view.set_headers_visible(True)
		self.fields_order = p.fields_order
		self.fields_order_name = map(lambda x: view['fields'][x]['string'], self.fields_order)

		combo_field = self.glade.get_widget('combo_field')
		modell = gtk.ListStore(gobject.TYPE_STRING)
		for l in self.fields_order_name:
			i = modell.append()
			modell.set(i, 0, l)
		combo_field.set_model(modell)
		self.combo_field = combo_field

		self.fields = view['fields']

		types=[ gobject.TYPE_STRING ]
		for x in self.fields_order:
			types.append( fields_list_type.get(view['fields'][x]['type'], gobject.TYPE_STRING))
		self.view_name = view['name']
		self.model_name = model
		self.model = gtk.ListStore(*types)
		self.ids = ids

		self.view.set_model(self.model)
		self.view.show_all()
		self.reload()

		dict = { }
		for signal in dict:
			self.glade.signal_connect(signal, dict[signal])

		self.sig_sel_all()
	
	def sig_action(self, button, action):
		ids = self.sel_ids_get()
		if ids:
			action['ids'] = ids
			obj = service.LocalService('action.main')
			obj._exec_action(action, {'ids':ids, 'model':self.model_name})
			for id in ids:
				self.ids.remove(id)
			self.reload()
		else:
			common.message(_('No resource selected !'))

	def reload(self):
		self.model.clear()
		if self.view_name=='default':
			res_ids = rpc.session.rpc_exec_auth('/object', 'execute', self.model_name, 'name_get', self.ids)
			for res in res_ids:
				num = self.model.append()
				self.model.set(num, 0, res[0], 1, res[1])
		else:
			print  ('/object', 'execute', self.model_name, 'read', self.ids, self.fields_order)

			res_ids = rpc.session.rpc_exec_auth('/object', 'execute', self.model_name, 'read', self.ids, self.fields_order)
			for field in self.fields_order:
				if self.fields[field]['type'] in ('one2one','many2one'):
					for x in res_ids:
						if x[field]:
							x[field] = x[field][1]
			for res in res_ids:
				num = self.model.append()
				args = []
				for x in range(len(self.fields_order)):
					args.append(x+1)
					args.append(res[self.fields_order[x]])
				self.model.set(num, 0, res['id'], *args)

	def sig_select(self, action=None):
		comp = lambda x,y: x==y
		model = self.combo_field.get_model()
		field = model.get_value(self.combo_field.get_active_iter(), 0)
		
		field_nbr = self.fields_order_name.index(field) + 1
		sel = self.view.get_selection()
		self.model.foreach(self._func_sel, (self.glade.get_widget('ent_search').get_text(),comp, field_nbr, sel))

	def sig_unselect(self, action=None):
		comp = lambda x,y: x==y
		model = self.combo_field.get_model()
		field = model.get_value(self.combo_field.get_active_iter(), 0)
		field_nbr = self.fields_order_name.index(field) + 1
		sel = self.view.get_selection()
		sel.selected_foreach(self._func_unsel, (self.glade.get_widget('ent_search').get_text(),comp, field_nbr, sel))

	def sig_sel_all(self, action=None):
		self.view.get_selection().select_all()
	def sig_sel_none(self, action=None):
		self.view.get_selection().unselect_all()

	def sel_ids_get(self):
		sel = self.view.get_selection()
		ids = []
		sel.selected_foreach(self._func_sel_get, ids)
		return ids

	def _func_sel(self, *args):
		if args[3][1]( args[0].get_value(args[2], args[3][2]), args[3][0]):
			args[3][3].select_iter(args[2])

	def _func_unsel(self, *args):
		if args[3][1]( args[0].get_value(args[2], args[3][2]), args[3][0]):
			args[3][3].unselect_iter(args[2])

	def _func_sel_get(self, *args):
		args[3].append(int(args[0].get_value(args[2], 0)))

	def go(self):
		end = False
		while not end:
			button = self.win.run()
			if button==gtk.RESPONSE_OK:
				res = self.sel_ids_get()
				end = True
			else:
				res = None
				end = True
		self.win.destroy()
		return res

