##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#		    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gobject
import gtk
from gtk import glade
import copy

import gettext

import wid_int
import wid_common
import form
import common
import service
import rpc
import gettext

class dialog(object):
	def __init__(self, model, fields, arch, parent, state='Edition', value=None, win=None):
		self.win_gl = glade.XML(common.terp_path("terp.glade"),"dia_form_win_many2one",gettext.textdomain())
		self.dia = self.win_gl.get_widget('dia_form_win_many2one')

		self.form = form.form(arch, fields, model, parent=parent, window=self.dia)
		if value:
			self.form.value = value
		self.form.state_set('valid')


		self.sw = self.win_gl.get_widget('many2one_vp')
		self.sw.add(self.form.widget)

		self.dia.set_title('Ressource '+state+': '+self.form.name)
		self.dia.set_transient_for(win)
		self.dia.show_all()

	def run(self, datas={}):
		end = False
		while not end:
			res = self.dia.run()
			end = (res != gtk.RESPONSE_OK) or self.form.validate()
		if res==gtk.RESPONSE_OK:
			datas = self.form.value
			return (res==gtk.RESPONSE_OK, datas)
		return (False, False)

	def destroy(self):
		self.dia.destroy()

class many2one(wid_int.wid_int):
	def __init__(self, parent, attrs={}):
		wid_int.wid_int.__init__(self, parent, attrs)
		self.win_gl = glade.XML(common.terp_path("terp.glade"),"widget_reference")
		self.win_gl.signal_connect('on_reference_new_button_press', self.sig_new )
		self.win_gl.signal_connect('on_reference_edit_button_press', self.sig_edit )
		self.widget = self.win_gl.get_widget('widget_reference')
		self.model_type = attrs['relation']
		
		self._menu_loaded = False
		self._menu_entries.append((None, None, None))
		self._menu_entries.append((_('Action'), lambda x: self.click_and_action('client_action_multi'),0))
		self._menu_entries.append((_('Report'), lambda x: self.click_and_action('client_print_multi'),0))


		#self.widget.set_property('can-focus', True)
		#self.widget.set_property('can-default', True)

		self.widget.set_property('sensitive', False)
		self.widget.set_property('sensitive', True)

		self.win_gl.get_widget('but_many2one_new').set_property('can-focus',False)
		self.win_gl.get_widget('but_many2one_open').set_property('can-focus',False)

		self.wid_text = self.win_gl.get_widget('ent_reference')
		self.ok=True
		self.wid_text.connect_after('changed', self.sig_changed)
		self.wid_text.connect_after('activate', self.sig_activate)
		self.wid_text.connect('button_press_event', self._menu_open)
		self._value=None

	def _readonly_set(self, value):
		wid_int.wid_int._readonly_set(self, value)
		self.wid_text.set_editable(not value)
		self.wid_text.set_sensitive(not value)

	def _color_widget(self):
		return self.wid_text

	def _value_get(self):
		if self._value and self._value[0]:
			return (int(self._value[0]), self._value[1])
		else:
			return False

	def _menu_sig_pref(self, obj):
		self._menu_sig_default_set()

	def _menu_sig_default(self, obj):
		res = rpc.session.rpc_exec_auth('/object', 'execute', self.attrs['model'], 'default_get', [self.attrs['name']])
		self.value = res.get(self.attrs['name'], False)

	def sig_activate(self, *args):
		self.ok = False
		arg = self._domain_get(self.parent)
		context = self._context_get(self.parent)
		res = self.trigger('many2one_sel', (self.model, self.name, self.wid_text.get_text(), self.model_type, arg, context))
		if res:
			self.wid_text.set_text(str(res[1]))
			self.state_set('valid')
		self._value = res
		if self.attrs.get('on_change',False):
			self.on_change(self.attrs['on_change'])
		self.ok=True
		wid_int.wid_int.sig_changed(self)
		return self._value

	def sig_new(self, *args):
		(fields, model, arch) = self.trigger('template_get', (self.model_type, 'form', self.attrs.get('view',False)) )
		val = self.trigger('default_get', (model,fields) )
		dia = dialog(model, fields, arch, self, state='Creation', value=val, win=self._window_get())
		end = res = False
		while not end:
			res = dia.run()
			if not res[0]:
				end = True
			else:
				try:
					val = copy.copy(res[1])
					for key, value in val.items():
						if value and  fields.get(key, False) and fields[key]['type'] in ('many2one',):
							val[key] = val[key][0]
					res = rpc.session.rpc_exec_auth('/object', 'execute', model, 'create', val)
					if res:
						self.value = res
						if self.attrs.get('on_change',False):
							self.on_change(self.attrs['on_change'])
						end = True
				except rpc.rpc_exception, e:
					dia.form.state_propagate(e.data.split(','))
					common.error(_('Error: ')+str(e.type), e.message, e.data)
		dia.destroy()

	def sig_edit(self, *args):
		if self.value:
			id = self.value[0]
		else:
			id = False
		if id:
			(fields, model, arch) = self.trigger('template_get', (self.model_type, 'form', self.attrs.get('view',False)) )
			try:
				val = rpc.session.rpc_exec_auth('/object', 'execute', model, 'read', [id])
			except rpc.rpc_exception, e:
				logging.getLogger('view.form').warning(_('Unable to read resource')+' %s, %d!' % (model,id))
			if val:
				dia = dialog(model, fields, arch, self, state='Edition', value=val[0])
				end = res = False
				while not end:
					res = dia.run()
					if not res[0]:
						end = True
					else:
						try:
							val = copy.copy(res[1])
							for key, value in val.items():
								if value and  fields.get(key, False) and fields[key]['type'] in ('many2one',):
									val[key] = val[key][0]
							rpc.session.rpc_exec_auth('/object', 'execute', model, 'write', [id], val)
							end = True
							self.value = id
						except rpc.rpc_exception, e:
							dia.form.state_propagate(e.data.split(','))
							common.error(_('Error: ')+str(e.type), e.message, e.data)
				dia.destroy()
			else:
				common.message(_('This record did not exist !'), gtk.MESSAGE_WARNING)
		else:
			self.sig_activate()
			#common.message(_('Error !\nYou can not edit an unexisting resource !'), gtk.MESSAGE_WARNING)

	def sig_changed(self, *args):
		if self.attrs.get('on_change',False) and self._value and self.ok:
			self._value = False
			self.on_change(self.attrs['on_change'])
		if self.ok:
			self._value = False
		return False

	def _value_set(self, value):
		self.ok = False
		name = ''
		if value:
			self.sig_changed()
			context = self._context_get(self.parent)
			if isinstance(value, (int, str, unicode, long)):
				name = self.trigger('name_id_get', (value, self.model_type, context))
			elif isinstance(value, (tuple, list)) and context:
				name = self.trigger('name_id_get', (value[0], self.model_type, context))
			else:
				name = value
		if name:
			self._value = name
			self.wid_text.set_text(name[1] or '')
		else:
			self._value = False, ''
			self.wid_text.set_text('')
		self.state_set('valid')
		self.ok = True

	def clear(self):
		self.value = False
		return False

	def _value_get2(self):
		if self._value:
			return int(self._value[0])
		else:
			return False

	value2 = property(_value_get2, _value_set, None,
	  'The content of the widget or ValueError if not valid')
	value = property(_value_get, _value_set, None,
	  'The content of the widget or ValueError if not valid')

	def _menu_open(self, obj, event):
		obj = service.LocalService('gui.window')
		if event.button == 3:
			if not self._menu_loaded:
				fields_id = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.model.fields', 'search',[('relation','=',self.model_type),('ttype','=','many2one'),('relate','=',True)])
				fields = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.model.fields', 'read', fields_id, ['name','model_id'], rpc.session.context)
				models_id = [x['model_id'][0] for x in fields if x['model_id']]
				fields = dict(map(lambda x: (x['model_id'][0], x['name']), fields))
				models = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.model', 'read', models_id, ['name','model'], rpc.session.context)
				self._menu_entries.append((None, None, None))
				for model in models:
					field = fields[model['id']]
					model_name = model['model']
					f = lambda model_name,field: lambda x: self.click_and_relate(model_name,field)
					self._menu_entries.append(('... '+model['name'], f(model_name,field), 0))
			self._menu_loaded = True

			menu = gtk.Menu()
			for stock_id,callback,sensitivity in self._menu_entries:
				if stock_id:
					item = gtk.ImageMenuItem(stock_id)
					if callback:
						item.connect("activate",callback)
					item.set_sensitive(bool(sensitivity or self._value))
				else:
					item=gtk.SeparatorMenuItem()
				item.show()
				menu.append(item)
			menu.popup(None,None,None,event.button,event.time)
			return True
		return False

	#
	# Open a view with ids: [(field,'=',value)]
	#
	def click_and_relate(self, model, field):
		ids = rpc.session.rpc_exec_auth('/object', 'execute', model, 'search',[(field,'=',self.value2)])
		obj = service.LocalService('gui.window')
		view_ids = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.ui.view', 'search', [('model','=',model),('type','=','form')])
		obj.create(view_ids and view_ids[0], model, ids, [(field,'=',self.value2)], 'tree', None)
		return True

	def click_and_action(self, type):
		id = self.value2
		obj = service.LocalService('action.main')
		res = obj.exec_keyword(type, {'model':self.model_type, 'id': id or False, 'ids':[id], 'report_type': 'pdf'})
		return True


