##############################################################################
#
# Copyright (c) 2004-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

from osv import fields,osv

class res_company(osv.osv):
	_name = "res.company"

	_columns = {
		'name': fields.char('Company Name', size=64, required=True),
		'parent_id': fields.many2one('res.company', 'Parent Company'),
		'child_ids': fields.one2many('res.company', 'parent_id', 'Childs Company'),
		'partner_id': fields.many2one('res.partner', 'Partner', required=True),
		'rml_header1': fields.char('Report Header', size=64),
		'rml_footer1': fields.char('Report Footer 1', size=84),
		'rml_footer2': fields.char('Report Footer 2', size=84),
		'currency_id': fields.many2one('res.currency', 'Currency', required=True),
	}
	
	def _get_child_ids(self, cr, uid, uid2, context={}):
		company = self.pool.get('res.users').browse(cr, uid, uid2).company_id.id
		if not company:
			search = []
		else:
			search = [company]
		ids =  self.search(cr, uid, [('parent_id','child_of',search)])
		return ids

	def _get_euro (self, cr, uid, context={}):
		try:
			return self.pool.get('res.currency').search(cr, uid, [('rate', '=', 1.0),])[0]
		except:
			return 1
	
	_defaults = {
		'currency_id': _get_euro,
	}

res_company()

