# -*-encoding: iso8859-1 -*-
##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import sql_db
import ir
from osv.osv import osv_pools
from report.interface import report_rml
from report.int_to_text import int_to_text


def toxml(val):
	return val.replace('&', '&amp;').replace('<','&lt;').replace('>','&gt;').decode('utf-8').encode('latin1')

class report_custom(report_rml):
	def __init__(self, name, table, tmpl, xsl):
		report_rml.__init__(self, name, table, tmpl, xsl)

	def create_xml(self, uid, ids, datas, context={}):
		cr = sql_db.db.cursor()
		number = (datas.get('form', False) and datas['form']['number']) or 1
		
		def process_bom(bom):
			xml = '<row>'
			sum = 0
			sum_strd = 0
			prod = osv_pools.get('product.product').browse(cr, uid, bom['product_id'])

			prod_name = bom['name']
			prod_qtty = bom['product_qty']
			prod_uom = prod.uom_id.name 
			level = 1
			main_sp_price = ''
			main_sp_name = ''
			main_strd_price = ''
			main_strd_price = ''
			if prod.seller_ids and prod.seller_ids[0] :
				main_sp_name = '<b>' + prod.seller_ids[0].name.name + '</b>\r\n'
				pricelist_id = ir.ir_get(cr,uid,'meta','product.pricelist.purchase',[('res.partner',prod.seller_ids[0].name.id)])[0][2]
				price = osv_pools.get('product.pricelist').price_get(cr,uid,[pricelist_id], prod.id, number*prod_qtty or 1.0)[pricelist_id]
				main_sp_price = str(price) + '\r\n'
				sum += prod_qtty*price

			main_strd_price = str(prod.standard_price) + '\r\n'
			sum_strd = prod_qtty*prod.standard_price

			sellers = ''
			sellers_price = ''
			for seller_id in prod.seller_ids:
				sellers +=  '- <i>'+ seller_id.name.name +'</i>\r\n'
				pricelist_id = ir.ir_get(cr,uid,'meta','product.pricelist.purchase',[('res.partner',seller_id.name.id)])[0][2]
				price = osv_pools.get('product.pricelist').price_get(cr,uid,[pricelist_id], prod.id, number*prod_qtty or 1.0)[pricelist_id]
				sellers_price += '-' + str(price) + '\r\n'

			xml += "<col para='yes'>" + prod_name + '</col>'
			xml += "<col para='no'>" + main_sp_name +  sellers + '</col>'
			xml += "<col para='yes'>" + str(prod_qtty) + '</col>'
			xml += "<col para='yes'>" + prod_uom + '</col>'
			xml += "<col para='yes'>" + main_strd_price + '</col>'
			xml += "<col para='no'>" + main_sp_price +  sellers_price + '</col>'


			xml += '</row>'
			return xml, sum, sum_strd

		def process_workcenter(wrk):
			xml = '<row>'

			workcenter = osv_pools.get('mrp.workcenter').browse(cr, uid, wrk['workcenter_id'])

			xml += "<col para='yes'>" + wrk['name'] + '</col>'
			xml += "<col para='yes'>" +  '</col>'
			xml += "<col para='no'>" + '</col>'
			xml += "<col/>"
			xml += "<col para='no'>" + str(wrk['cycle']*workcenter.costs_cycle) + '</col>'
			xml += "<col para='yes'>" + str(wrk['hour']*workcenter.costs_hour) + '</col>'


			xml += '</row>'
			return xml, wrk['cycle']*workcenter.costs_cycle+wrk['hour']*workcenter.costs_hour


		xml = ''
		config_start = """
		<config>
			<date>09/09/2005</date>
			<PageSize>210.00mm,297.00mm</PageSize>
			<PageWidth>595.27</PageWidth>
			<PageHeight>841.88</PageHeight>
			<tableSize>60.00mm,60.00mm, 20.00mm, 20.00mm, 20.00mm, 20.00mm</tableSize>
			"""
		config_stop = """
			<report-footer>Generated by Tiny ERP</report-footer>
		</config>
		"""
		header = """
			<header>
			<field>Product name</field>
			<field>Product supplier</field>
			<field>Product quantity</field>
			<field>Product uom</field>
			<field>Product Standard Price</field>
			<field>Unit Product Price</field>
			</header>
			"""
		workcenter_header = """
			<lines style='header'>
				<row>
					<col>Workcenter name</col>
					<col/>
					<col/>
					<col/>
					<col>Cycles Cost</col>
					<col>Hours Cost</col>
				</row>
			</lines>
		"""
		prod_header = """
			<lines style='header'>
				<row>
					<col para='yes'>Product name</col>
					<col para='yes'>Product supplier</col>
					<col para='yes'>Product Quantity</col>
					<col para='yes'>Product uom</col>
					<col para='yes'>Product Standard Price</col>
					<col para='yes'>Unit Product Price</col>
				</row>
			</lines>
		"""

		first = True
		for prod_id in ids:
			bom_ids = osv_pools.get('mrp.bom').search(cr, uid, [('product_id','=',prod_id)])
			prod = osv_pools.get('product.product').browse(cr, uid, prod_id)

			for bom_id in bom_ids:
				bom = osv_pools.get('mrp.bom').browse(cr, uid, bom_id)

				sub_boms = osv_pools.get('mrp.bom')._bom_explode(cr, uid, bom, number, [])
				total = 0
				total_strd = 0
				parent_bom = {'product_qty': bom.product_qty, 'name': bom.product_id.name, 'product_uom': bom.product_id.uom_id.factor, 'product_id': bom.product_id.id}
				xml_tmp = ''
				for sub_bom in (sub_boms and sub_boms[0]) or [parent_bom]:
					txt, sum, sum_strd = process_bom(sub_bom)
					xml_tmp +=  txt
					total += sum
					total_strd += sum_strd
				if not first:
					xml += prod_header
				xml += "<lines style='lines'>" + xml_tmp + '</lines>'
				xml += "<lines style='sub_total'><row><col>SUBTOTAL : </col><col>(for " + str(number) + " products)</col><col/><col/><col>" + str(total_strd) + '</col><col>' + str(total)  + '</col></row></lines>'

				total2 = 0
				xml_tmp = ''
				for wrk in (sub_boms and sub_boms[1]):
					txt, sum = process_workcenter(wrk)
					xml_tmp += txt
					total2 += sum
				if xml_tmp:
					xml += workcenter_header
					xml += "<lines style='lines'>" + xml_tmp + '</lines>'
					xml += "<lines style='sub_total'><row><col>SUBTOTAL : </col><col>(for " + str(number) + " products)</col><col/><col/><col/><col>" + str(total2) + '</col></row></lines>'
				xml += "<lines style='total'><row><col>TOTAL : </col><col>(for " + str(number) + " products)</col><col/><col/><col>" + str(total_strd+total2) + "</col><col>" + str(total+total2) + '</col></row></lines>'
				first = False

		xml = '<?xml version="1.0" ?><report>' + config_start + '<report-header>Product Cost Structure\n\r' + prod.name  + '</report-header>'+ config_stop +  header + xml + '</report>'
		return xml

report_custom('report.product.price', 'product.product', '', 'addons/mrp/report/price.xsl')
