import ir
import time
import os
import netsvc
import xmlrpclib

import wizard
from osv import osv

_import_form = '''<?xml version="1.0"?>
<form title="Categories import" />
'''

_import_fields = {}

_import_done_form = '''<?xml version="1.0"?>
<form title="Initial import">
<separator string="Categories succesfully imported" colspan="4" />
</form>'''

_import_done_fields = {}

def _do_import(self, cr, uid, data, context):
	website = osv.osv_pools.get('oscommerce.web').browse(cr, uid, data['id'])

	server = xmlrpclib.ServerProxy("%s/tinyerp-syncro.php" % website.url)

	categories = server.get_categories()
	category_pool = osv.osv_pools.get('oscommerce.category')
	for category in categories:
		value={	'web_id'		: website.id,
				'oscommerce_id'	: category[0],
				'name'			: category[1]
			}
		existing = category_pool.search(cr, uid, [('web_id','=',website.id), ('oscommerce_id', '=', category[0])])
		if len(existing)>0:
			category_pool.write(cr, uid, existing, value)
		else:
			category_pool.create(cr, uid, value)

	cr.commit()
	return {}

class wiz_oscommerce_import_categories(wizard.interface):

	states = {	'init'	: {	'actions'	: [_do_import],
							'result'	: {	'type'	: 'form',
											'arch'	: _import_done_form,
											'fields': _import_done_fields,
											'state'	: [('end', 'End')]
											}
							}
				}


wiz_oscommerce_import_categories('oscommerce.categories');
