##############################################################################
#
# Copyright (c) 2005-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: wizard_partial_picking.py 2871 2006-04-25 14:08:22Z ged $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time
import netsvc
from tools.misc import UpdateableStr

import wizard
from osv import osv

#FIXME: this is not concurrency-safe !!!!!!!!!!
_moves_arch = UpdateableStr()
_moves_fields = {}

def make_default(val):
	def fct(uid, data, state):
		return val
	return fct

def _get_moves(self, cr, uid, data, context):
	pick_obj = osv.osv_pools.get('stock.picking')
	pick = pick_obj.browse(cr, uid, [data['id']])[0]
	res = {}
	_moves_fields.clear()
	_moves_arch_lst = ['<?xml version="1.0"?>', '<form string="Make picking">']
	for m in pick.move_lines:
		quantity = m.product_qty
		if m.state<>'assigned':
			quantity = 0
		_moves_arch_lst.append('<field name="move%s" />\n<newline />' % (m.id,))
		_moves_fields['move%s' % m.id] = {'string' : m.product_id.name, 'type' : 'float', 'required' : True, 'default' : make_default(quantity)}
		res.setdefault('moves', []).append(m.id)
	_moves_arch_lst.append('</form>')
	_moves_arch.string = '\n'.join(_moves_arch_lst)
	return res

def _do_split(self, cr, uid, data, context):
	move_obj = osv.osv_pools.get('stock.move')
	pick_obj = osv.osv_pools.get('stock.picking')
	pick = pick_obj.browse(cr, uid, [data['id']])[0]
	new_picking = None
	new_moves = []
	# Iterate on the moves, copying them if necessary and setting them to the
	# right quantity
	for move in move_obj.browse(cr, uid, data['form']['moves']):
		# Check the number of product received/sent
		if move.product_qty != data['form']['move%s' % move.id]:
			if not new_picking:
				new_picking = pick_obj.copy(cr, uid, pick.id, {'name' : '%s (splitted)' % pick.name, 'move_lines' : [], 'state':'draft'})
			new_obj = move_obj.copy(cr, uid, move.id, {'product_qty' : move.product_qty - data['form']['move%s' % move.id], 'picking_id' : new_picking, 'state': move.state})
			new_moves.append(new_obj)
			move_obj.write(cr, uid, [move.id], {'product_qty' : data['form']['move%s' % move.id]})
	# We process the picking list
	pick_obj.action_move(cr, uid, [pick.id])
	wf_service = netsvc.LocalService("workflow")
	wf_service.trg_validate(uid, 'stock.picking', pick.id, 'button_done', cr)

	if new_picking:
		wf_service.trg_validate(uid, 'stock.picking', new_picking, 'button_confirm', cr)
	return {}

class partial_picking(wizard.interface):
	
	states = {
		'init' : {
			'actions' : [ _get_moves ],
			'result' : { 'type' : 'form', 'arch' : _moves_arch, 'fields' : _moves_fields, 'state' : (('end', 'Cancel'),('split', 'Make Picking') )},
		},
		'split' : {
			'actions' : [ _do_split ],
			'result' : { 'type' : 'state', 'state' : 'end' },
		},
	}

partial_picking('stock.partial_picking')

# vim:noexpandtab:
