#!/usr/bin/python

##############################################################################
#
# Copyright (c) 2004-2006 TINY SPRL. (http://tiny.be)
#
# $Id: tinyerp-server.py 1308 2005-09-08 18:02:01Z pinky $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contact a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

"""
Tiny ERP - Server
Tiny ERP is an ERP+CRM program for small and medium businesses.

The whole source code is distributed under the terms of the
GNU Public Licence.

(c) 2003-TODAY, Fabien Pinckaers - Tiny sprl
"""

__author__ = 'Fabien Pinckaers, <fp@tiny.be>'
__version__ = '3.3.0'

import __builtin__
__builtin__.__dict__['tinyerp_version'] = __version__
__builtin__.__dict__['tinyerp_version_string'] = "Tiny ERP Server " + __version__



#----------------------------------------------------------
# python imports
#----------------------------------------------------------
import os, signal, sys

#----------------------------------------------------------
# get logger
#----------------------------------------------------------
import netsvc

logger = netsvc.Logger()

#-----------------------------------------------------------------------
# import the tools module so that the commandline parameters are parsed
#-----------------------------------------------------------------------
import tools

if not tools.config['root_path'] or tools.config['root_path']=='None':
	tools.config['root_path'] = os.path.abspath(os.path.dirname(sys.argv[0]))
if not tools.config['addons_path'] or tools.config['addons_path']=='None':
	tools.config['addons_path'] = os.path.join(tools.config['root_path'], 'addons')

if sys.platform=='win32':
	import mx.DateTime
	import time
	mx.DateTime.strptime = lambda x,y: mx.DateTime.mktime(time.strptime(x, y))

#os.chdir(tools.file_path_root)

#----------------------------------------------------------
# init net service
#----------------------------------------------------------
logger.notifyChannel("objects", netsvc.LOG_INFO, 'initialising distributed objects services')

dispatcher = netsvc.Dispatcher()
dispatcher.monitor(signal.SIGINT)

#---------------------------------------------------------------
# connect to the database and initialize it with base if needed
#---------------------------------------------------------------
logger.notifyChannel("init", netsvc.LOG_INFO, 'connecting to database')

import psycopg
import sql_db

# try to connect to the database
try:
	sql_db.init()
except psycopg.OperationalError, err:
	logger.notifyChannel("init", netsvc.LOG_ERROR, "could not connect to database '%s'!" % (tools.config["db_name"],))

	msg = str(err).replace("FATAL:","").strip()
	db_msg = "database \"%s\" does not exist" % (tools.config["db_name"],)
	
	# Note: this is ugly but since psycopg only uses one exception for all errors
	# I don't think it's possible to do differently
	if msg == db_msg:
		print """
    this database does not exist

You need to create it using the command:

    createdb --encoding=UNICODE '%s'

When you run tinyerp-server for the first time it will initialise the
database. You may force this behaviour at a later time by using the command:

    ./tinyerp-server --init=all

Two accounts will be created by default:
    1. login: admin      password : admin
    2. login: demo       password : demo

""" % (tools.config["db_name"])
	else:
		print "\n    "+msg+"\n"
	sys.exit(1)

# initialize the database with base/base.sql if needed (the db is empty)
cr=sql_db.db.cursor()
cr.execute("SELECT relname FROM pg_class WHERE relkind='r' AND relname='perm'")
if len(cr.fetchall())==0:
	f=os.path.join(tools.config['addons_path'], 'base/base.sql')
	for line in file(f).read().split(';'):
		if (len(line)>0) and (not line.isspace()):
			cr.execute(line)
	cr.commit()

	# in that case, force --init=all
	tools.config["init"]["all"] = 1
	tools.config['update']['all'] = 1
	if not tools.config['without_demo']:
		tools.config["demo"]['all'] = 1
cr.close()

#----------------------------------------------------------
# launch modules install/upgrade/removes if needed
#----------------------------------------------------------
if tools.config['upgrade']:
	print 'Upgrading new modules...'
	import tools.upgrade
	(toinit, toupdate) = tools.upgrade.upgrade()
	for m in toinit:
		tools.config['init'][m] = 1
	for m in toupdate:
		tools.config['update'][m] = 1

#----------------------------------------------------------
# import basic modules 
#----------------------------------------------------------
import osv, workflow, report, service

#----------------------------------------------------------
# import addons
#----------------------------------------------------------
import addons

#----------------------------------------------------------
# register reports
#----------------------------------------------------------
logger.notifyChannel("init", netsvc.LOG_INFO, 'registering reports')

report.interface.register_all()

#----------------------------------------------------------
# translation stuff
#----------------------------------------------------------
if tools.config["translate_out"]:
	logger.notifyChannel("init", netsvc.LOG_INFO, 'writing translation file for language %s to %s' % (tools.config["language"], tools.config["translate_out"]))
	tools.trans_generate(tools.config["translate_out"], tools.config["language"], tools.config["translate_modules"])
	logger.notifyChannel("init", netsvc.LOG_INFO, 'translation file written succesfully')
	sys.exit(0)

if tools.config["translate_in"]:
	tools.trans_load(tools.config["translate_in"], tools.config["language"])
	sys.exit(0)

#----------------------------------------------------------
# Launch Server
#----------------------------------------------------------
try:
	port = int(tools.config["port"])
except Exception:
	logger.notifyChannel("init", netsvc.LOG_ERROR, "invalid port '%s'!" % (tools.config["port"],))
	sys.exit(1)
interface = tools.config["interface"]

httpd = netsvc.HttpDaemon(interface,port)

if tools.config["xmlrpc"]:
	xml_gw = netsvc.xmlrpc.RpcGateway('web-services')
	httpd.attach("/xmlrpc", xml_gw )
	logger.notifyChannel("web-services", netsvc.LOG_INFO, "starting XML-RPC services, port "+str(port))

#
#if tools.config["soap"]:
#	soap_gw = netsvc.xmlrpc.RpcGateway('web-services')
#	httpd.attach("/soap", soap_gw )
#	logger.notifyChannel("web-services", netsvc.LOG_INFO, 'starting SOAP services, port '+str(port))
#

logger.notifyChannel("web-services", netsvc.LOG_INFO, 'the server is running, waiting for connections...')
osv.osv.osv_pools.get('ir.cron')._poolJobs()

httpd.start()
dispatcher.run()
