
/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <abz/typedefs.h>
#include <abz/error.h>

#include <tinysnmp/tinysnmp.h>
#include <tinysnmp/agent/odb.h>

#include <ber/ber.h>

int update (struct odb **odb,const uint32_t *oid,uint8_t type,void *data)
{
   snmp_value_t value;

   value.type = type;

   switch (type)
	 {
	  case BER_INTEGER:
		value.data.INTEGER = *(int32_t *) data;
		break;
	  case BER_Counter32:
		value.data.Counter32 = *(uint32_t *) data;
		break;
	  case BER_Gauge32:
		value.data.Gauge32 = *(uint32_t *) data;
		break;
	  case BER_TimeTicks:
		value.data.TimeTicks = *(uint32_t *) data;
		break;
	  case BER_Counter64:
		value.data.Counter64 = *(uint64_t *) data;
		break;
	  case BER_OID:
		value.data.OID = (uint32_t *) data;
		break;
	  case BER_OCTET_STRING:
		value.data.OCTET_STRING = *(octet_string_t *) data;
		break;
	  default:
		abz_set_error ("invalid type (0x%02x) specified",type);
		return (-1);
	 }

   odb_remove (odb,oid);

   return (odb_add (odb,oid,&value));
}

