
/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <tinysnmp/tinysnmp.h>
#include <tinysnmp/agent/module.h>
#include <tinysnmp/agent/odb.h>

#include <ber/ber.h>

#include <abz/typedefs.h>
#include <abz/error.h>

#include "meminfo.h"

static int memory_update (struct odb **odb)
{
   uint32_t oid[13] = { 12, 43, 6, 1, 4, 1, 10002, 1, 1, 1, 1, 0, 0 };
   snmp_value_t value;
   struct meminfo info;

   if (getmeminfo (&info))
	 return (-1);

   value.type = BER_Gauge32;

   oid[11] = 1;
   value.data.Gauge32 = info.mem_total / 1024;

   odb_remove (odb,oid);
   if (odb_add (odb,oid,&value))
	 return (-1);

   oid[11] = 2;
   value.data.Gauge32 = info.mem_free / 1024;

   odb_remove (odb,oid);
   if (odb_add (odb,oid,&value))
	 return (-1);

   oid[11] = 3;
   value.data.Gauge32 = info.mem_buffer / 1024;

   odb_remove (odb,oid);
   if (odb_add (odb,oid,&value))
	 return (-1);

   oid[11] = 4;
   value.data.Gauge32 = info.mem_cache / 1024;

   odb_remove (odb,oid);
   if (odb_add (odb,oid,&value))
	 return (-1);

   return (0);
}

static int swap_update (struct odb **odb)
{
   uint32_t oid[13] = { 12, 43, 6, 1, 4, 1, 10002, 1, 1, 1, 2, 0, 0 };
   snmp_value_t value;
   struct swapinfo info;

   if (getswapinfo (&info))
	 return (-1);

   value.type = BER_Gauge32;

   oid[11] = 1;
   value.data.Gauge32 = info.swap_total / 1024;

   odb_remove (odb,oid);
   if (odb_add (odb,oid,&value))
	 return (-1);

   oid[11] = 2;
   value.data.Gauge32 = info.swap_free / 1024;

   odb_remove (odb,oid);
   if (odb_add (odb,oid,&value))
	 return (-1);

   return (0);
}

void _init (void)
{
   static const uint32_t memory_oid[11] = { 10, 43, 6, 1, 4, 1, 10002, 1, 1, 1, 1 };
   static const uint32_t swap_oid[11] = { 10, 43, 6, 1, 4, 1, 10002, 1, 1, 1, 2 };

   /* iso.org.dod.internet.private.enterprises.frogfoot.servers.system.resources.memory */
   module_register ("resources/memory",
					memory_oid,
					NULL,
					NULL,
					memory_update,
					NULL);

   /* iso.org.dod.internet.private.enterprises.frogfoot.servers.system.resources.swap */
   module_register ("resources/swap",
					swap_oid,
					NULL,
					NULL,
					swap_update,
					NULL);
}

