/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "Contest.H"
#include "main.h"
#include "lektionsauswertung.h"
#include "ContestWizard.H"
#include "ContestRankingDlg.H"

BEGIN_EVENT_TABLE(Contest,LessonController)
  LESSON_START(wxID_ANY, Contest::onLessonStart)
  LESSON_ABORT(wxID_ANY, Contest::onLessonAbort)
  LESSON_FINISH(wxID_ANY, Contest::onLessonFinish)
END_EVENT_TABLE()

Contest::Contest (wxWindow* parent, ContestDesc& cdata)
  : parent(parent),
    data(cdata)
{
  if (!Hauptfenster::getPtr()->setLessonController(this)) {
    throw Abbruch();
  }
  controllerName=_("contest");
  wxTextFile file(data.descrFile.GetFullPath());
  if (!file.Open()) {
    ::wxLogError(_T("Cannot open file %s"),data.descrFile.GetFullName().c_str());
    throw Abbruch();
  } else {
    wxString description;
    description << file.GetFirstLine();
    while (!file.Eof()) {
      description << _T("\n") << file.GetNextLine();
    }
    ContestWizard* wizard = new ContestWizard(parent,data.title,
					      data.pictureFile, description);
    if (wizard->runWizard()) {
      this->username=wizard->getName();
    } else {
      throw Abbruch();
    }
    wizard->Destroy();
    lesson = new Lektion(data.lessonFile.GetFullPath(), this);
  }
}

Contest::~Contest () {
  if (runningLesson()) {
    lesson->LektionAbbrechen();
    delete lesson;
  }
}

void Contest::onLessonStart (wxCommandEvent& WXUNUSED(e)) {
  /* you can put things here that get run before the lesson starts */
}
void Contest::onLessonAbort (wxCommandEvent& WXUNUSED(e)) {
  /* you can put things here that get run when the lesson was aborted */
  if (this->username != _T("")) {
    wxMessageDialog dlg(this->parent,
			_("Your data was not stored in the contest list\nbecause you aborted the contest."),
			_("Aborted lesson notification"),
			wxICON_INFORMATION|wxOK);
    dlg.ShowModal();
  }
  delete lesson;
  lesson = 0;
}

void Contest::onLessonFinish (wxCommandEvent& WXUNUSED(e)) {
  /* you can put things here that get run when the lesson was finished */
  //save the results
  if (this->username != _T("")) {
    wxTextFile file(this->data.dataFile.GetFullPath());
    if ((file.Exists() == false &&
	 file.Create() == false) ||
	file.Open() == false){
      ::wxLogFatalError(_("Cannot open or create contest data file."));
    }
    wxString s;
    LEntry e = lesson->GetLessonData();
    s << _T("\"") << this->username << _T("\",")
      << e.getRichtig() << _T(",")
      << e.getFehler() << _T(",")
      << e.getZeitString();
    file.AddLine(s, wxTextFileType_Unix);
    file.Write();
    file.Close();
  }
  
  lauswertung laus(Hauptfenster::getPtr(), _("Your contest statistics"), lesson);
  laus.ShowModal();
  ContestRankingDlg ranking(Hauptfenster::getPtr(),this->data.title,
			    this->data.dataFile,this->data.weight);
  ranking.ShowModal();
  delete lesson;
  lesson = 0;
  Hauptfenster::getPtr()->setLessonController(0);
}
