/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ContestPropDlg.H"
#include <wx/statline.h>

enum {
  BTN_PICT_SEL = 1,
  BTN_DESCR_SEL,
  BTN_LESSON_SEL,
  BTN_DATA_SEL,
  BTN_SAVE
};

BEGIN_EVENT_TABLE(ContestPropDlg,wxDialog)
  EVT_BUTTON(BTN_PICT_SEL, ContestPropDlg::onSelectButton)
  EVT_BUTTON(BTN_DESCR_SEL, ContestPropDlg::onSelectButton)
  EVT_BUTTON(BTN_LESSON_SEL, ContestPropDlg::onSelectButton)
  EVT_BUTTON(BTN_DATA_SEL, ContestPropDlg::onSelectButton)
  EVT_BUTTON(BTN_SAVE, ContestPropDlg::onSaveButton)
END_EVENT_TABLE()

ContestPropDlg::ContestPropDlg (wxWindow* parent, const ContestDesc& cdata)
  : wxDialog (parent,-1,_("Contest Properties")),
    settings(cdata)
{
  wxBoxSizer* dialogSizer = new wxBoxSizer(wxVERTICAL);
  dialogSizer->Add(wizardSettingsSizer(),0,
		   wxEXPAND|wxLEFT|wxTOP|wxRIGHT,10);
  dialogSizer->Add(lessonSettingsSizer(),0,
		   wxEXPAND|wxLEFT|wxTOP|wxRIGHT,10);
  dialogSizer->Add(new wxStaticLine(this,-1),0,
		   wxEXPAND|wxLEFT|wxTOP|wxRIGHT,10);
  dialogSizer->Add(buttonSizer(),0,wxALL|wxALIGN_CENTRE,10);

  SetSizer(dialogSizer);
  dialogSizer->SetSizeHints(this);
  Centre();
}

wxSizer* ContestPropDlg::buttonSizer () {
  wxBoxSizer* sizer = new wxBoxSizer(wxHORIZONTAL);
  sizer->Add(new wxButton(this,BTN_SAVE,_("Save")),
		   1,wxEXPAND|wxALIGN_CENTER|wxRIGHT,10);
  sizer->Add(new wxButton(this,wxID_CANCEL,_("Cancel"))
		   ,1,wxEXPAND|wxALIGN_CENTER);
  return sizer;
}

wxSizer* ContestPropDlg::wizardSettingsSizer () {
  wxFlexGridSizer* wSubSizer = new wxFlexGridSizer(3,5,5);
  //title line
  wSubSizer->Add(new wxStaticText(this,-1,_("Title:")),0,wxALIGN_CENTRE_VERTICAL);
  this->title = new wxTextCtrl(this,-1,this->settings.title);
  //GTK1 default size is too small
  int width = 0;
  int height = 0;
  this->title->GetSize(&width,&height);
  this->title->SetSize(3*width,height);
  wSubSizer->Add(this->title,1,wxEXPAND|wxALIGN_CENTRE_VERTICAL);
  wSubSizer->Add(0,0);
  //picture source selection line
  wSubSizer->Add(new wxStaticText(this,-1,_("Picture:")),0,wxALIGN_CENTRE_VERTICAL);
  this->picture = new wxTextCtrl(this,-1,this->settings.pictureFile.GetFullPath(),
				 wxDefaultPosition,wxDefaultSize,wxTE_READONLY);
  wSubSizer->Add(this->picture,1,wxEXPAND|wxALIGN_CENTRE_VERTICAL);
  wSubSizer->Add (new wxButton(this,BTN_PICT_SEL,_T("Select"),
			       wxDefaultPosition,wxDefaultSize,wxBU_EXACTFIT),
		  0,wxALIGN_CENTRE_VERTICAL);
  //description source selection line
  wSubSizer->Add(new wxStaticText(this,-1,_("Description:")),0,wxALIGN_CENTRE_VERTICAL);
  this->descr = new wxTextCtrl(this,-1,this->settings.descrFile.GetFullPath(),
			       wxDefaultPosition,wxDefaultSize,wxTE_READONLY);
  wSubSizer->Add(this->descr,1,wxEXPAND|wxALIGN_CENTRE_VERTICAL);
  wSubSizer->Add (new wxButton(this,BTN_DESCR_SEL,_T("Select"),
			       wxDefaultPosition,wxDefaultSize,wxBU_EXACTFIT),
		  0,wxALIGN_CENTRE_VERTICAL);

  
  wxStaticBoxSizer* wSizer = new wxStaticBoxSizer(new wxStaticBox(this, -1, _("Contest Wizard settings")),
						  wxVERTICAL);
  wSizer->Add(wSubSizer,1,wxEXPAND|wxALL,5);
  return wSizer;
}

wxSizer* ContestPropDlg::lessonSettingsSizer () {
  wxFlexGridSizer* lSubSizer = new wxFlexGridSizer(3,5,5);
  //picture source selection line
  lSubSizer->Add(new wxStaticText(this,-1,_("Lesson:")),0,wxALIGN_CENTRE_VERTICAL);
  this->lesson = new wxTextCtrl(this,-1,this->settings.lessonFile.GetFullPath(),
				wxDefaultPosition,wxDefaultSize,wxTE_READONLY);
  lSubSizer->Add(this->lesson,1,wxEXPAND|wxALIGN_CENTRE_VERTICAL);
  lSubSizer->Add (new wxButton(this,BTN_LESSON_SEL,_T("Select"),
			       wxDefaultPosition,wxDefaultSize,wxBU_EXACTFIT),
		  0,wxALIGN_CENTRE_VERTICAL);
  //description source selection line
  lSubSizer->Add(new wxStaticText(this,-1,_("Data:")),0,wxALIGN_CENTRE_VERTICAL);
  this->data = new wxTextCtrl(this,-1,this->settings.dataFile.GetFullPath(),
			      wxDefaultPosition,wxDefaultSize,wxTE_READONLY);
  lSubSizer->Add(this->data,1,wxEXPAND|wxALIGN_CENTRE_VERTICAL);
  lSubSizer->Add (new wxButton(this,BTN_DATA_SEL,_T("Select"),
			       wxDefaultPosition,wxDefaultSize,wxBU_EXACTFIT),
		  0,wxALIGN_CENTRE_VERTICAL);

  lSubSizer->AddGrowableCol(1);

  wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
  sizer->Add(lSubSizer,0,wxEXPAND);
  sizer->Add(sliderSizer(),0,wxEXPAND|wxTOP,5);

  wxStaticBoxSizer* lSizer = new wxStaticBoxSizer(new wxStaticBox(this, -1, _("Lesson settings")),
						  wxVERTICAL);
  lSizer->Add(sizer,1,wxEXPAND|wxALL,5);
  return lSizer;
}

wxSizer* ContestPropDlg::sliderSizer () {
  this->weight = new wxSlider(this,-1,this->settings.weight,0,100,wxDefaultPosition,
			      wxDefaultSize,wxSL_HORIZONTAL|wxSL_TOP|wxSL_LABELS);
  wxBoxSizer* sizer = new wxBoxSizer(wxHORIZONTAL);
  sizer->Add(new wxStaticText(this,-1,_("Speed")),0,wxALIGN_CENTRE_VERTICAL);
  sizer->Add(this->weight,1,wxEXPAND|wxALIGN_CENTRE_VERTICAL|wxLEFT|wxRIGHT,5);
  sizer->Add(new wxStaticText(this,-1,_("Correctness")),0,wxALIGN_CENTRE_VERTICAL);
  return sizer;
}

void ContestPropDlg::onSelectButton (wxCommandEvent& e) {
  wxFileDialog dialog(this);
  switch (e.GetId()) {
  case BTN_PICT_SEL:
    dialog.SetPath(this->picture->GetValue());
    dialog.SetStyle(wxOPEN|wxFILE_MUST_EXIST);
    break;
  case BTN_DESCR_SEL:
    dialog.SetPath(this->descr->GetValue());
    dialog.SetStyle(wxOPEN|wxFILE_MUST_EXIST);
    break;
  case BTN_LESSON_SEL:
    dialog.SetPath(this->lesson->GetValue());
    dialog.SetStyle(wxOPEN|wxFILE_MUST_EXIST);
    break;
  case BTN_DATA_SEL:
    dialog.SetPath(this->data->GetValue());
    dialog.SetStyle(wxSAVE);
    break;
  default:
    break;
  }
  int r;
  do { //loop to work-around wxWindows bug
    r = dialog.ShowModal();
  } while (r == wxID_OK && !wxFile::Exists(dialog.GetPath()));
  
  if (r == wxID_OK) {
    switch (e.GetId()) {
    case BTN_PICT_SEL:
      this->picture->SetValue(dialog.GetPath());
      break;
    case BTN_DESCR_SEL:
      this->descr->SetValue(dialog.GetPath());
      break;
    case BTN_LESSON_SEL:
      this->lesson->SetValue(dialog.GetPath());
      break;
    case BTN_DATA_SEL:
      this->data->SetValue(dialog.GetPath());
      break;
    default:
      break;
    }
  }
}

void ContestPropDlg::onSaveButton (wxCommandEvent& WXUNUSED(e)) {
  if (this->title->GetValue() == _T("") ||
      this->picture->GetValue() == _T("") ||
      this->descr->GetValue() == _T("") ||
      this->lesson->GetValue() == _T("") ||
      this->data->GetValue() == _T("")) {
    wxMessageBox(_("Your have to fill out all fields!"),
		 _("Important"), wxICON_WARNING | wxOK, this);
  } else {
    this->settings.title = this->title->GetValue();
    this->settings.pictureFile = this->picture->GetValue();
    this->settings.descrFile = this->descr->GetValue();
    this->settings.lessonFile = this->lesson->GetValue();
    this->settings.dataFile = this->data->GetValue();
    this->settings.weight = this->weight->GetValue();
    EndModal(wxID_OK);
  }
}

ContestDesc ContestPropDlg::getContestDesc () {
  return this->settings;
}
