/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTESTWIZARD_H
#define CONTESTWIZARD_H

#include <wx/wx.h>
#include <wx/wizard.h>
#include <wx/filename.h>

class FullNameEnterPage : public wxWizardPageSimple {
public:
  FullNameEnterPage(wxWizard *parent);
  wxString GetName ();

private:
  wxString firstname;
  wxTextCtrl* ftctrl;
  wxString lastname;
  wxTextCtrl* ltctrl;

  void OnPageChanging (wxWizardEvent& e);

  DECLARE_EVENT_TABLE()
};

class ContestWizard : public wxWizard {
public:
  ContestWizard(wxWindow* parent, const wxString& title,
		const wxFileName& picture, const wxString& text);
  ~ContestWizard();

  bool runWizard ();
  wxString getName ();

private:
  wxWizardPageSimple* p1;
  wxStaticText* p1text;
  FullNameEnterPage* p2;  
};

#endif
