/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <wx/datetime.h>
#include "LessonStatusSizer.H"

LessonStatusSizer::LessonStatusSizer (wxWindow* parent) 
  : wxFlexGridSizer(2,5,5) {

  wxString temp;
  temp << _("Touches") << _T(":");
  touchesText = new wxStaticText(parent,-1,temp);
  temp.Empty();
  temp << _("Touches per minute") << _T(":");
  tpmText = new wxStaticText(parent,-1,temp);
  temp.Empty();
  temp << _("Correct") << _T(":");
  correctText = new wxStaticText(parent,-1,temp);
  temp.Empty();
  temp << _("Mistakes") << _T(":");
  wrongText = new wxStaticText(parent,-1,temp);
  temp.Empty();
  temp << _("Mistakes\n(per mil)") << _T(":");
  rateText = new wxStaticText(parent,-1,temp);
  temp.Empty();
  temp << _("used time") << _T(":");
  timeText = new wxStaticText(parent,-1,temp);
  touchesField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
		       wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  tpmField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
		       wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  correctField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
		       wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  wrongField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
		       wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  rateField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
		       wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  timeField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
		       wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  Add(correctText,0,wxALIGN_CENTRE_VERTICAL);
  Add(correctField,0,wxALIGN_CENTRE_VERTICAL);
  Add(wrongText,0,wxALIGN_CENTRE_VERTICAL);
  Add(wrongField,0,wxALIGN_CENTRE_VERTICAL);
  Add(touchesText,0,wxALIGN_CENTRE_VERTICAL);
  Add(touchesField,0,wxALIGN_CENTRE_VERTICAL);
  Add(rateText,0,wxALIGN_CENTRE_VERTICAL);
  Add(rateField,0,wxALIGN_CENTRE_VERTICAL);
  Add(timeText,0,wxALIGN_CENTRE_VERTICAL);
  Add(timeField,0,wxALIGN_CENTRE_VERTICAL);
  Add(tpmText,0,wxALIGN_CENTRE_VERTICAL);
  Add(tpmField,0,wxALIGN_CENTRE_VERTICAL);
}

void LessonStatusSizer::setStatus (LEntry& status) {
  wxString temp;
  temp << status.getAnschlaege();
  this->touchesField->SetValue(temp);

  temp.Empty();
  temp.Printf(_T("%.0f"), status.getApM());
  this->tpmField->SetValue(temp);

  temp.Empty();
  temp << status.getRichtig();
  this->correctField->SetValue(temp);

  temp.Empty();
  temp << status.getFehler();
  this->wrongField->SetValue(temp);

  temp.Empty();
  temp.Printf(_T("%.0f"), status.getPromille());
  this->rateField->SetValue(temp);

  temp.Empty();
  if (status.getZeit() >= 0) {
    this->timeField->SetValue(status.getZeitString());
  } else {
    this->timeField->SetValue(_("unknown"));
  }
}
