/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "inputcontrol.h"
#include "ConfigFile.H"
#include "main.h"
#include <wx/config.h>
#include <wx/settings.h>

BEGIN_EVENT_TABLE(TtInputControl, wxTextCtrl)
  EVT_CHAR(TtInputControl::onChar)
//   EVT_MOUSE_EVENTS(TtInputControl::onMouse)
END_EVENT_TABLE()

TtInputControl::TtInputControl (wxWindow* parent)
  : wxTextCtrl(parent, 2, _T(""), wxDefaultPosition, wxDefaultSize,
	       wxNO_BORDER|wxTE_MULTILINE|wxTE_PROCESS_TAB/*|wxTE_RICH*/) {
  
  //Pointer auf Hauptfenster
  hauptfenster=(wxFrame*)GetParent()->GetParent();
  m_falsch=false;

  //black text color
  this->textcolor = wxBLACK;
  //white background color
  this->bgcolor = wxWHITE;
  this->localfont = NULL;
  wxFont* f = TtConfigFile::getPtr()->getMainWindowFont();
  setFont(*f);
}

TtInputControl::~TtInputControl () {
}

void  TtInputControl::onChar (wxKeyEvent& event) {
  if (event.m_altDown) {
    event.Skip();
    return;
  }
  Hauptfenster* haupt = (Hauptfenster*) hauptfenster;
  // Falls keine Lektion geladen, wird auch nicht die Richtigkeit der Eingabe getestet, es ist keine Eingabe mglich
  if (haupt->getLessonController() == 0 ||
      !haupt->getLessonController()->runningLesson()) {
    return;
  }

  // Abfangen unerwnschter Tasten, wie z.B. die Pfeiltasten
  switch (event.KeyCode()) {
  case WXK_BACK:
  case WXK_LEFT:
  case WXK_DOWN:
  case WXK_RIGHT:
  case WXK_UP:
  case WXK_END:
  case WXK_HOME:
  case WXK_CLEAR:
  case WXK_PRIOR:
  case WXK_NEXT:
    if (TtConfigFile::getPtr()->getBellStatus()) {
      wxBell();
    }
    break;
  default:
    if (haupt->getLessonController()->getLesson()->Eingabe(event.KeyCode())) {
      hauptfenster->SetStatusText(_("Correct"));
      // sonst kann man kein Enter drcken
      wxString s;
      if (event.KeyCode()==WXK_RETURN) {
	if (this->specialLineEndingChar) {
	  s << wxChar(182);
	}
	s << wxChar(_T('\n'));
      } else {
	s << wxChar(event.KeyCode());
      }
      // Durch diese if Anweisung werden Fehler markiert. Da der falsche Buchstabe aber nicht gezeichnet wird, 
      // brauchen wir die Hilfsvariable bool m_falsch
      if (m_falsch) {
	this->bgcolor=wxRED;
	updateLook();
	this->m_falsch=false;
      } else {
	this->bgcolor=wxWHITE;
	updateLook();
      }
      *this << s;
      if (haupt->GetOutput()->getHighlightPosition() >= haupt->GetOutput()->GetLastPosition()) {
	haupt->SetStatusText(_("Lesson finished"));
	haupt->getLessonController()->getLesson()->SetEnde();
	haupt->getLessonController()->getLesson()->LektionEnde();
      }
    } else {
      if (TtConfigFile::getPtr()->getBellStatus()) {
	wxBell();
      }
      hauptfenster->SetStatusText(_("Wrong"));
      m_falsch=true;
    }
    break;
  } 
}

/* On Mouse action, ignore all specialties but give focus
 *
 * I found an error (maybe on with KDE3) where MOUSE_DCLICK
 * is not catched.
 */
void TtInputControl::onMouse (wxMouseEvent& event) {
  SetFocus();
}

void TtInputControl::updateLook () {
  wxTextAttr attribs(*(this->textcolor),
		     *(this->bgcolor),
		     *(this->localfont));
  SetDefaultStyle(attribs);
  //this has problems because all marking of wrong inputs
  //would be deleted by this: not good
//   SetStyle(0,GetLastPosition(),attribs);
}

void TtInputControl::setFont (wxFont& newFont) {
  if (newFont.GetEncoding() == wxFONTENCODING_ISO8859_1 ||
      newFont.GetEncoding() == wxFONTENCODING_ISO8859_15) {
    this->specialLineEndingChar=true;
  } else {
    this->specialLineEndingChar=false;
  }
  if (this->localfont != NULL) {
    delete this->localfont;
  }
  this->localfont = new wxFont(newFont);
  updateLook();
  SetFocus();
}

void TtInputControl::Clear() {
  Freeze();
  wxTextCtrl::Clear();
  Thaw();
}
