/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "lektionsauswertung.h"
#include "LessonStatusSizer.H"
#include <wx/statline.h>

lauswertung::lauswertung(wxWindow *parent, const wxString& title, Lektion* lektion)
  : wxDialog(parent, -1, title)
{
  LessonDir f;
  f.SetFullName(_T("logo.png"));
  wxBitmap logo(f.GetFullPath(), wxBITMAP_TYPE_PNG);
  wxStaticBitmap *icon = new wxStaticBitmap(this, -1, logo);

  LessonStatusSizer* statusSizer = new LessonStatusSizer(this);
  LEntry entry = lektion->GetLessonData();
  statusSizer->setStatus(entry);

  wxBoxSizer* subSizer = new wxBoxSizer(wxHORIZONTAL);
  subSizer->Add(icon,0,wxLEFT|wxRIGHT|wxTOP,10);
  subSizer->Add(statusSizer,0,wxALIGN_CENTER|wxRIGHT|wxTOP,10);
  
  
  wxBoxSizer *topsizer = new wxBoxSizer(wxVERTICAL);
  topsizer->Add(subSizer);
  topsizer->Add(new wxStaticLine(this,-1),0,wxEXPAND|wxLEFT|wxRIGHT|wxTOP,10);
  topsizer->Add(CreateButtonSizer(wxOK),0,wxALIGN_CENTER|wxALL,10);
  topsizer->Fit(this);
  SetSizer(topsizer);
  Center();
}
