# $Id: bwidget_workarounds.tcl,v 1.10 2003/12/13 21:35:26 aleksey Exp $

Button .fake_button
destroy .fakebutton

rename Button::create Button::create_old

proc Button::create {path args} {

    set new_args {}
    foreach {attr val} $args {
        switch -- $attr {
            -background { }
            default { lappend new_args $attr $val }
        }
    }

    eval [list Button::create_old $path] $new_args
}

rename menu menu_old

proc menu {path args} {

    set new_args {}
    foreach {attr val} $args {
        switch -- $attr {
            -background { }
            default { lappend new_args $attr $val }
        }
    }

    eval [list menu_old $path] $new_args
}

if {[info tclversion] >= 8.4} {

    rename frame frame_old

    proc frame {path args} {

	set new_args {}
	foreach {attr val} $args {
	    switch -- $attr {
		-class { 
		    lappend new_args $attr $val 
		    if {$val == "Tree"} {
			lappend new_args -padx 0
		    }
		}
		default { lappend new_args $attr $val }
	    }
	}
    
	eval [list frame_old $path] $new_args
    }
}

proc ::TreeHandleSelection {win nodes} {
    if {![cequal [selection own] $win] && ![cequal $nodes {}]} {
	selection own -command [list $win selection clear] $win
    }
}

proc ::TreeSelection {win offset len} {
    global tcl_platform

    set selnodes [$win selection get]
    if {![cequal $selnodes {}]} {
	set ::xselection [$win itemcget [lindex $selnodes 0] -text]
	if {[cequal $tcl_platform(platform) unix]} {
	    encoding convertto \
		[crange $::xselection $offset [expr $offset + $len - 1]]
	} else {
	    return [crange $::xselection $offset [expr $offset + $len - 1]]
	}
    } else {
	set ::xselection ""
    }
}

proc ::TreeUTF8Selection {win offset len} {
    return -code error
}

Tree .fake_tree
destroy .fake_tree

rename Tree::create Tree::create:old

proc Tree::create {path args} {
    if {[catch { eval [list Tree::create:old $path] $args \
		     -selectcommand TreeHandleSelection }]} {
	eval [list Tree::create:old $path] $args
    } else {
	::selection handle $path "TreeSelection $path"
	::selection handle -type UTF8_STRING $path "TreeUTF8Selection $path"
    }
    Tree::bindText  $path <Control-Button-1> [list $path selection set]
    Tree::bindImage $path <Control-Button-1> [list $path selection set]

    return $path
}

proc Tree::_see {path idn {side "none"}} {
    set bbox [$path.c bbox $idn]
    set scrl [$path.c cget -scrollregion]

    set ymax [lindex $scrl 3]
    set dy   [$path.c cget -yscrollincrement]
    set yv   [$path yview]
    set yv0  [expr {round([lindex $yv 0]*$ymax/$dy)}]
    set yv1  [expr {int([lindex $yv 1]*$ymax/$dy + 0.1)}]
    set y    [expr {int([lindex [$path.c coords $idn] 1]/$dy)}]
    if { $y < $yv0 } {
        $path.c yview scroll [expr {$y-$yv0}] units
    } elseif { $y >= $yv1 } {
        $path.c yview scroll [expr {$y-$yv1+1}] units
    }

    set xmax [lindex $scrl 2]
    set dx   [$path.c cget -xscrollincrement]
    set xv   [$path xview]
    if { ![string compare $side "none"] } {
	set x0   [expr {int([lindex $bbox 0]/$dx)}]
	set xv0  [expr {round([lindex $xv 0]*$xmax/$dx)}]
	set xv1  [expr {round([lindex $xv 1]*$xmax/$dx)}]
	if { $x0 >= $xv1 || $x0 < $xv0 } {
	    $path.c xview scroll [expr {$x0-$xv0}] units
	}
    } elseif { ![string compare $side "right"] } {
        set xv1 [expr {round([lindex $xv 1]*$xmax/$dx)}]
        set x1  [expr {int([lindex $bbox 2]/$dx)}]
        if { $x1 >= $xv1 } {
            $path.c xview scroll [expr {$x1-$xv1+1}] units
        }
    } else {
        set xv0 [expr {round([lindex $xv 0]*$xmax/$dx)}]
        set x0  [expr {int([lindex $bbox 0]/$dx)}]
        if { $x0 < $xv0 } {
            $path.c xview scroll [expr {$x0-$xv0}] units
        }
    }
}

proc PanedWin {path args} {
   
    if {[catch { PanedWindow .fake_pw -activator button }]} {
	return [eval [list PanedWindow $path] $args]
    } else {
	destroy .fake_pw
	return [eval [list PanedWindow $path] $args -activator button]
    }
}

ComboBox .fake_combobox
destroy .fake_combobox

option add *ComboBox.listRelief ridge widgetDefault
option add *ComboBox.listBorder 2 widgetDefault

rename ComboBox::_create_popup ComboBox::_create_popup_old

proc ComboBox::_create_popup {path args} {

    eval [list ComboBox::_create_popup_old $path] $args
    $path.shell configure \
	    -relief [option get $path listRelief ComboBox] \
	    -border [option get $path listBorder ComboBox]
}

rename ComboBox::create ComboBox::create_old

proc ComboBox::create {path args} {

    set hlthick [cequal $::tcl_platform(platform) "unix"]
    foreach {opt arg} $args {
	if {[cequal $opt "-highlightthickness"]} {
	    set hlthick $arg
	}
    }
    eval [list ComboBox::create_old $path] $args -highlightthickness 0
    $path:cmd configure -highlightthickness $hlthick

    return $path
}

NoteBook .fake_nb
destroy .fake_nb

if {![catch { rename NoteBook::_get_page_name NoteBook::_get_page_name:old }]} {
    proc NoteBook::_get_page_name { path {item current} {tagindex end-1} } {
	set pagename [NoteBook::_get_page_name:old $path $item $tagindex]
	if {[catch { _test_page $path $pagename }]} {
	    return [string range [lindex [$path.c gettags $item] 1] 2 end]
	} else {
	    return $pagename
	}
    }
}

