# $Id: disco.tcl,v 1.24 2003/12/02 20:14:32 aleksey Exp $

set ::NS(disco_items) "http://jabber.org/protocol/disco#items"
set ::NS(disco_info)  "http://jabber.org/protocol/disco#info"

option add *JDisco.fill          Black		widgetDefault
option add *JDisco.featurecolor  MidnightBlue   widgetDefault
option add *JDisco.identitycolor DarkGreen      widgetDefault
option add *JDisco.optioncolor   DarkViolet     widgetDefault

namespace eval disco {}

proc disco::request_items {jid node args} {
    variable disco

    set handler {}
    set cache no

    foreach {attr val} $args {
	switch -- $attr {
	    -handler    {set handler $val}
	    -cache      {set cache $val}
	    -connection {set connid $val}
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route $jid]
    }

    switch -- $cache {
	first -
	only -
	yes {
	    if {[info exists disco(items,$jid,$node)]} {
		set items $disco(items,$jid,$node)
		if {$handler != ""} {
		    eval $handler [list OK $items]
		}
		if {$cache != "first"} {
		    return [list OK $items]
		}
	    } elseif {$cache == "only"} {
		return NO
	    }
	}
    }

    set vars [list xmlns $::NS(disco_items) xml:lang [get_lang]]
    if {$node != ""} {
	lappend vars node $node
    }

    jlib::send_iq get \
	    [jlib::wrapper:createtag query \
		 -vars $vars] \
	-to $jid \
	-connection $connid \
	-command [list [namespace current]::parse_items $jid $node $handler]
}

proc disco::parse_items {jid node handler res child} {
    variable disco

    if {![cequal $res OK]} {
	if {$handler != ""} {
	    eval $handler [list ERR $child]
	}
	hook::run disco_items_hook $jid $node ERR $child
	return
    }

    set items {}

    jlib::wrapper:splitxml $child tag vars isempty chdata childrens

    foreach ch $childrens {
	jlib::wrapper:splitxml $ch tag1 vars1 isempty1 chdata1 childrens1
	switch -- $tag1 {
	    item {
		set ijid  [jlib::wrapper:getattr $vars1 jid]
		set inode  [jlib::wrapper:getattr $vars1 node]
		set name  [jlib::wrapper:getattr $vars1 name]
		lappend items [list jid $ijid node $inode name $name]
		set disco(jidname,$ijid,$inode) $name
	    }
	}
    }

    set disco(items,$jid,$node) $items

    debugmsg disco "ITEMS: [list $items]"

    if {$handler != ""} {
	eval $handler [list OK $items]
    }

    hook::run disco_items_hook $jid $node OK $items
}



proc disco::request_info {jid node args} {
    variable disco

    set handler {}
    set cache no

    foreach {attr val} $args {
	switch -- $attr {
	    -handler    {set handler $val}
	    -cache      {set cache $val}
	    -connection {set connid $val}
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route $jid]
    }

    switch -- $cache {
	first -
	only -
	yes {
	    if {[info exists disco(info,identities,$jid,$node)] && \
		    [info exists disco(info,identities,$jid,$node)]} {
		set identities $disco(info,identities,$jid,$node)
		set features   $disco(info,features,$jid,$node)
		if {$handler != ""} {
		    eval $handler [list OK $identities $features]
		}
		if {$cache != "first"} {
		    return [list OK $identities $features]
		}
	    } elseif {$cache == "only"} {
		return NO
	    }
	}
    }

    set vars [list xmlns $::NS(disco_info) xml:lang [get_lang]]
    if {$node != ""} {
	lappend vars node $node
    }

    jlib::send_iq get \
	[jlib::wrapper:createtag query \
	     -vars $vars] \
	-to $jid \
	-connection $connid \
	-command [list [namespace current]::parse_info $jid $node $handler]
}

proc disco::parse_info {jid node handler res child} {
    variable disco

    if {![cequal $res OK]} {
	if {$handler != ""} {
	    eval $handler [list ERR $child {}]
	}
	hook::run disco_info_hook $jid $node ERR $child {}
	return
    }

    set identities {}
    set features {}

    jlib::wrapper:splitxml $child tag vars isempty chdata childrens

    foreach ch $childrens {
	jlib::wrapper:splitxml $ch tag1 vars1 isempty1 chdata1 childrens1
	switch -- $tag1 {
	    identity {
		lappend identities \
		    [list \
			 category [jlib::wrapper:getattr $vars1 category] \
			 name [jlib::wrapper:getattr $vars1 name] \
			 type [jlib::wrapper:getattr $vars1 type]]
	    }
	    feature {
		set var [jlib::wrapper:getattr $vars1 var]
		if {$var == ""} {
		    set var [jlib::wrapper:getattr $vars1 type]
		}
		lappend features [list var $var]
	    }
	}
    }

    set disco(info,identities,$jid,$node) $identities
    set disco(info,features,$jid,$node) $features

    debugmsg disco \
	"INFO: IDENTITIES [list $identities] FEATURES [list $features]"

    if {$handler != ""} {
	eval $handler [list OK $identities $features]
    }
    hook::run disco_info_hook $jid $node OK $identities $features
}

proc disco::get_jid_name {jid node} {
    variable disco
    if {[info exists disco(jidname,$jid,$node)]} {
	return $disco(jidname,$jid,$node)
    } else {
	return ""
    }
}

###############################################################################

proc disco::info_query_get_handler {connid from child} {
    set restags {}

    lappend restags [jlib::wrapper:createtag identity \
			 -vars [list \
				    category user \
				    type client \
				    name Tkabber]]

    foreach ns $::iq::supported_ns {
	lappend restags [jlib::wrapper:createtag feature \
			     -vars [list var $ns]]
    }
    
    set res [jlib::wrapper:createtag query \
		 -vars [list xmlns $::NS(disco_info)] \
		 -subtags $restags]

    return [list result $res]
}

iq::register_handler get query $::NS(disco_info) \
    [namespace current]::disco::info_query_get_handler

proc disco::items_query_get_handler {connid from child} {

    set res [jlib::wrapper:createtag query \
		 -vars [list xmlns $::NS(disco_items)]]

    return [list result $res]
}

iq::register_handler get query $::NS(disco_items) \
    [namespace current]::disco::items_query_get_handler

###############################################################################
# Disco Browser

namespace eval disco::browser {
    set winid 0

    set icon(group)   [Bitmap::get [pixmap browser group_on.gif]]
    set icon(user)    [Bitmap::get [pixmap browser user.gif]]
    set icon(jud)     [Bitmap::get [pixmap browser jud.gif]]
    set icon(aim)     [Bitmap::get [pixmap browser aim_online.gif]]
    set icon(icq)     [Bitmap::get [pixmap browser icq_online.gif]]
    set icon(msn)     [Bitmap::get [pixmap browser msn_online.gif]]
    set icon(gg)      [Bitmap::get [pixmap browser gg_online.gif]]
    set icon(weather) [Bitmap::get [pixmap browser weather_online.gif]]
    set icon(yahoo)   [Bitmap::get [pixmap browser yahoo_online.gif]]
    set icon(message) [Bitmap::get [pixmap browser glade-message.gif]]
    image create photo ""

    custom::defvar disco_list {} [::msgcat::mc "List of discovered JIDs."] \
	    -group Hidden
    custom::defvar node_list {} [::msgcat::mc "List of discovered JID nodes."] \
	    -group Hidden
}

proc disco::browser::open_win {{jid ""}} {
    variable winid
    variable disco
    variable config
    variable curjid
    variable disco_list
    variable node_list
    global loginconf

    if {$jid == ""} {
	set curjid($winid) $loginconf(server)
    } else {
	set curjid($winid) $jid
    }

    set w .disco_$winid
    set wid $winid
    incr winid

    add_win $w -title [::msgcat::mc "Jabber Discovery"] \
	-tabtitle [::msgcat::mc "Discovery"] \
	-raisecmd [list focus $w.tree] \
	-class JDisco

    set config(fill) 	      [option get $w fill          JDisco]
    set config(featurecolor)  [option get $w featurecolor  JDisco]
    set config(identitycolor) [option get $w identitycolor JDisco]
    set config(optioncolor)   [option get $w optioncolor   JDisco]

    frame $w.navigate
    button $w.navigate.back -text <- \
	-command [list [namespace current]::history_move $w 1]
    button $w.navigate.forward -text -> \
	-command [list [namespace current]::history_move $w -1]
    label $w.navigate.lentry -text [::msgcat::mc "JID:"]
    ComboBox $w.navigate.entry -textvariable [namespace current]::curjid($wid) \
	-dropenabled 1 -droptypes {JID {}} \
	-dropcmd [list [namespace current]::entrydropcmd $w] \
	-command [list [namespace current]::go $w] \
	-values $disco_list
    label $w.navigate.lnode -text [::msgcat::mc "Node:"]
    ComboBox $w.navigate.node -textvariable [namespace current]::curnode($wid) \
	-values $node_list -width 20
    button $w.navigate.browse -text [::msgcat::mc "Browse"] \
	-command [list [namespace current]::go $w]

    #bind $w.navigate.entry <Return> [list disco::go $w]

    pack $w.navigate.back $w.navigate.forward $w.navigate.lentry -side left
    pack $w.navigate.entry -side left -expand yes -fill x
    pack $w.navigate.lnode -side left
    pack $w.navigate.node -side left -expand no -fill x
    pack $w.navigate.browse -side left
    pack $w.navigate -fill x


    set sw [ScrolledWindow $w.sw]

    set tw [Tree $w.tree -deltax 16 -deltay 18 -dragenabled 1 \
		-draginitcmd [namespace current]::draginitcmd]
    $sw setwidget $tw

    pack $sw -side top -expand yes -fill both
    set disco(tree,$w) $tw
    $tw bindText <Double-ButtonPress-1> \
	[list [namespace current]::textaction $w]
    $tw bindText <Any-Enter>  \
	[list [namespace current]::textballoon $w enter  %X %Y]
    $tw bindText <Any-Motion> \
	[list [namespace current]::textballoon $w motion %X %Y]
    $tw bindText <Any-Leave>  \
	[list [namespace current]::textballoon $w leave  %X %Y]

    # HACK
    bind $tw.c <Return> \
	"[namespace current]::textaction $w \[$tw selection get\]"
    bind $tw.c <4> {%W yview scroll -1 units}
    bind $tw.c <5> {%W yview scroll 1 units}

    variable browser
    lappend browser(opened) $w
    set browser(opened) [lrmdups $browser(opened)]
    set browser(required,$w) {}
    set browser(tree,$w) $tw

    set browser(hist,$w) {}
    set browser(histpos,$w) 0

    go $w
}

proc disco::browser::go {bw} {
    variable browser
    variable disco_list
    variable node_list
    
    if {[winfo exists $bw]} {
	set jid [$bw.navigate.entry.e get]
	set node [$bw.navigate.node.e get]

	history_add $bw [list $jid $node]

        set disco_list [update_combo_list $disco_list $jid 20]
	$bw.navigate.entry configure -values $disco_list
	set custom::saved([namespace current]::disco_list) $disco_list
        set node_list [update_combo_list $node_list $node 20]
	$bw.navigate.node configure -values $node_list
	set custom::saved([namespace current]::node_list) $node_list
	custom::store

	lappend browser(required,$bw) $jid
	set browser(required,$bw) [lrmdups $browser(required,$bw)]

	disco::request_items $jid $node
	disco::request_info $jid $node
    }
}



proc disco::browser::info_receive {jid node res identities features} {
    variable browser

    if {![info exists browser(opened)]} return

    foreach w $browser(opened) {
	if {[winfo exists $w] && [lcontain $browser(required,$w) $jid]} {
	    draw_info $w $jid $node $res $identities $features
	}
    }
}

hook::add disco_info_hook \
    [namespace current]::disco::browser::info_receive


proc disco::browser::draw_info {w jid node res identities features} {
    variable browser
    variable config
    global font

    set tw $browser(tree,$w)

    set name [disco::get_jid_name $jid $node]
    set tnode [jid_to_tag [list $jid $node]]
    set parent_tag [jid_to_tag [list $jid $node]]
    set data [list item $jid $node]
    set desc [item_desc $jid $node $name]
    set icon ""

    add_line $tw $parent_tag $tnode $icon $desc $data -font $font \
	-fill $config(fill)

    if {$res != "OK"} {
	set tnode [jid_to_tag "error info $jid $node"]
	set data [list error_info $jid]
	#set name     [jlib::wrapper:getattr $identity name]
	set desc [format [::msgcat::mc "Error getting info: %s"] [error_to_string $identities]]
	set icon ""
	
	add_line $tw $parent_tag $tnode $icon $desc $data -font $font \
	    -fill $config(identitycolor)

	remove_old $tw $parent_tag identity [list $tnode]
	remove_old $tw $parent_tag feature [list $tnode]
	reorder_node $tw $parent_tag
	return
    }


    set identitynodes {}

    foreach identity $identities {
	set tnode [jid_to_tag "identity $identity $jid $node"]
	lappend identitynodes $tnode
	set data [list identity $jid $node]
	set name     [jlib::wrapper:getattr $identity name]
	set category [jlib::wrapper:getattr $identity category]
	set type     [jlib::wrapper:getattr $identity type]
	set desc "$name ($category/$type)"
	set icon [item_icon $category $type]
	
	add_line $tw $parent_tag $tnode $icon $desc $data -font $font \
	    -fill $config(identitycolor)
    }

    set featurenodes {}

    foreach feature $features {
	set var [jlib::wrapper:getattr $feature var]
	set tnode [jid_to_tag "feature $feature $jid $node"]
	lappend featurenodes $tnode
	set data [list feature $jid $node $feature]
	if {[info exists browser(feature_handler_desc,$var)] && \
		$browser(feature_handler_desc,$var) != ""} {
	    set desc "$browser(feature_handler_desc,$var) ($var)"
	} else {
	    set desc "$var"
	}
	# TODO
	set icon ""; #[item_icon $category $type]

	add_line $tw $parent_tag $tnode $icon $desc $data \
	    -fill $config(featurecolor)
    }

    remove_old $tw $parent_tag identity $identitynodes
    remove_old $tw $parent_tag feature  $featurenodes
    remove_old $tw $parent_tag error_info {}
    reorder_node $tw $parent_tag
}

proc disco::browser::items_receive {jid node res items} {
    variable browser

    if {![info exists browser(opened)]} return

    foreach w $browser(opened) {
	if {[winfo exists $w] && [lcontain $browser(required,$w) $jid]} {
	    draw_items $w $jid $node $res $items
	}
    }
}

hook::add disco_items_hook \
    [namespace current]::disco::browser::items_receive


proc disco::browser::draw_items {w jid node res items} {
    variable browser
    variable config
    global font

    set tw $browser(tree,$w)

    set tnode [jid_to_tag [list $jid $node]]
    set parent_tag [jid_to_tag [list $jid $node]]
    set data [list item $jid $node]
    set desc $jid
    set icon ""

    add_line $tw $parent_tag $tnode $icon $desc $data -font $font \
	-fill $config(fill)

    if {$res != "OK"} {
	set tnode [jid_to_tag "error items $jid $node"]
	set data [list error_items $jid]
	#set name     [jlib::wrapper:getattr $identity name]
	set desc [format [::msgcat::mc "Error getting items: %s"] [error_to_string $items]]
	set icon ""
	
	add_line $tw $parent_tag $tnode $icon $desc $data -font $font \
	    -fill $config(fill)

	remove_old $tw $parent_tag item [list $tnode]
	reorder_node $tw $parent_tag
	return
    }

    set itemnodes {}

    foreach item $items {
	set ijid [jlib::wrapper:getattr $item jid]
	set node [jlib::wrapper:getattr $item node]
	set name [jlib::wrapper:getattr $item name]
	set tnode [jid_to_tag [list $ijid $node]]
	lappend itemnodes $tnode
	set data [list item $ijid $node]
	set desc [item_desc $ijid $node $name]
	set icon ""

	add_line $tw $parent_tag $tnode $icon $desc $data -font $font \
	    -fill $config(fill)
    }
    remove_old $tw $parent_tag item $itemnodes
    remove_old $tw $parent_tag error_items {}
    reorder_node $tw $parent_tag
}

proc disco::browser::negotiate_feature {tw jid parent type} {
    variable config
    global font

    lassign [negotiate::send_request $jid $type] res opts

    if {![winfo exists $tw]} return

    if {$res != "OK"} {
	set node [jid_to_tag "error negotiate $parent"]
	set data [list error_negotiate $parent $jid]
	#set name     [jlib::wrapper:getattr $identity name]
	set desc [format [::msgcat::mc "Error negotiate: %s"] [error_to_string $opts]]
	set icon ""
	
	add_line $tw $parent $node $icon $desc $data -font $font \
	    -fill $config(optioncolor)

	remove_old $tw $parent option [list $node]
	return
    }

    set optnodes {}

    foreach opt $opts {
	set node [jid_to_tag "option $opt $parent"]
	lappend optnodes $node
	set data [list option $opt $node]
	set desc $opt
	set icon ""
	
	add_line $tw $parent $node $icon $desc $data -font $font \
	    -fill $config(optioncolor)
    }
    remove_old $tw $parent option $optnodes
    remove_old $tw $parent error_negotiate {}
}


proc disco::browser::add_line {tw parent node icon desc data args} {

    if {[$tw exists $node]} {
	if {[$tw parent $node] != $parent && [$tw exists $parent] && \
		$parent != $node} {
	    $tw move $parent $node end
	    debugmsg disco "MOVE: $parent $node"
	}
	if {[$tw itemcget $node -data] != $data || \
		[$tw itemcget $node -text] != $desc} {
	    debugmsg disco RECONF
	    $tw itemconfigure $node -text $desc -data $data
	}
    } elseif {[$tw exists $parent]} {
	eval {$tw insert end $parent $node -text $desc -open 1 -image $icon \
		  -data $data} $args
    } else {
	eval {$tw insert end root $node -text $desc -open 1 -image $icon \
		  -data $data} $args
    }

}


proc disco::browser::reorder_node {tw node} {
    set subnodes [$tw nodes $node]

    set identities {}
    set features {}
    set items {}
    foreach sn $subnodes {
	lassign [$tw itemcget $sn -data] kind
	switch -- $kind {
	    error_items -
	    item     {lappend items      $sn}
	    error_info -
	    identity {lappend identities $sn}
	    feature  {lappend features   $sn}
	}
    }
    $tw reorder $node [concat $identities $features $items]
}

proc disco::browser::remove_old {tw node kind newnodes} {
    set subnodes [$tw nodes $node]

    set items {}
    foreach sn $subnodes {
	lassign [$tw itemcget $sn -data] kind1
	if {$kind == $kind1 && ![lcontain $newnodes $sn]} {
	    $tw delete $sn
	}
    }
}



proc disco::browser::item_desc {jid node name} {
    if {$node != ""} {
	set snode " \[$node\]"
    } else {
	set snode ""
    }
    if {![cequal $name ""]} {
	return "$name$snode ($jid)"
    } else {
	return $jid$snode
    }
}

proc disco::browser::item_icon {category type} {
    variable icon
    switch -- $category {
	gateway {
	    switch -- $type {
		aim {return $icon(aim)}
		icq {return $icon(icq)}
		msn {return $icon(msn)}
		yahoo {return $icon(yahoo)}
		x-gadugadu {return $icon(gg)}
		default {return ""}
	    }
	}
	service {
	    switch -- $type {
		jud {return $icon(jud)}
		aim {return $icon(aim)}
		icq {return $icon(icq)}
		msn {return $icon(msn)}
		x-gadugadu {return $icon(gg)}
		x-weather {return $icon(weather)}
		yahoo {return $icon(yahoo)}
		default {return ""}
	    }
	}
	application {
	    switch -- $type {
		x-weather {return $icon(weather)}
		default {return ""}
	    }
	}
	conference {
	    return $icon(group)
	}
	user {
	    return $icon(user)
	}
	directory {
	    return $icon(jud)
	}
	headline {
	    return $icon(message)
	}
	default {return ""}
    }
}

proc disco::browser::textaction {bw tnode} {
    variable disco
    variable browser

    set tw $browser(tree,$bw)
    set data [$tw itemcget $tnode -data]
    set data2 [lassign $data type]
    switch -- $type {
	item {
	    lassign $data2 jid node
	    goto $bw $jid $node
	}
	feature {
	    lassign $data2 jid node feature
	    set type     [jlib::wrapper:getattr $feature var]
	    debugmsg disco $jid
	    if {$type != ""} {
		if {[info exists browser(feature_handler,$type)]} {
		    if {$browser(feature_handler_node,$type)} {
			eval $browser(feature_handler,$type) {$jid $node}
		    } else {
			eval $browser(feature_handler,$type) {$jid}
		    }
		} else {
		    negotiate_feature $tw $jid $tnode $type
		}
	    }
	}
    }
}

# TODO
proc disco::browser::textballoon {bw action X Y node} {
    variable disco
    variable browser

    set tw $browser(tree,$bw)
    set data [$tw itemcget $node -data]
    set data2 [lassign $data type]
    if {$type == "jid"} {
	    lassign $data2 jid category type name version
    } else {
	return
    }

    switch -- $action {
	enter {
	    balloon::set_text \
		[item_balloon_text $jid $category $type $name $version]
	}
	motion {
	    balloon::on_mouse_move \
		[disco::item_balloon_text $jid \
		     $category $type $name $version] \
		$X $Y
	}
	leave {balloon::destroy}
    }
}

proc disco::browser::goto {bw jid node} {
    $bw.navigate.entry.e delete 0 end
    $bw.navigate.entry.e insert 0 $jid
    $bw.navigate.node.e delete 0 end
    $bw.navigate.node.e insert 0 $node
    go $bw
}

proc disco::browser::draginitcmd {t tnode top} {
    set data [$t itemcget $tnode -data]
    set data2 [lassign $data type jid node]

    if {$type == "item"} {
	if {[set img [$t itemcget $tnode -image]] != ""} {
	    pack [label $top.l -image $img -padx 0 -pady 0]
	}
	
	return [list JID {copy} [list $jid "" "" "" ""]]
    } else {
	return {}
    }
}


proc disco::browser::entrydropcmd {bw target source pos op type data} {
    set jid [lindex $data 0]
    goto $bw $jid ""
}


proc disco::browser::history_move {bw shift} {
    variable browser

    set newpos [expr {$browser(histpos,$bw) + $shift}]

    if {$newpos < 0} {
	return
    }

    if {$newpos >= [llength $browser(hist,$bw)]} {
	return
    }

    set newjidnode [lindex $browser(hist,$bw) $newpos]
    set browser(histpos,$bw) $newpos

    lassign $newjidnode newjid newnode
    $bw.navigate.entry.e delete 0 end
    $bw.navigate.entry.e insert 0 $newjid
    $bw.navigate.node.e delete 0 end
    $bw.navigate.node.e insert 0 $newnode

    disco::request_items $newjid $newnode
    disco::request_info $newjid $newnode
}


proc disco::browser::history_add {bw jid} {
    variable browser

    set browser(hist,$bw) [lreplace $browser(hist,$bw) 0 \
			       [expr {$browser(histpos,$bw) - 1}]]
    
    lvarpush browser(hist,$bw) $jid
    set browser(histpos,$bw) 0
    debugmsg disco $browser(hist,$bw)
}

#proc disco::browser::item_balloon_text {jid category type name version} {
#    variable disco
#    set text [format [::msgcat::mc "%s: %s/%s, Description: %s, Version: %s\nNumber of children: %s"] \
#	    $jid $category $type $name $version $disco(nchilds,$jid)]
#    return $text
#}


proc disco::browser::register_feature_handler {feature handler args} {
    variable browser

    set node 0
    set desc ""

    foreach {attr val} $args {
	switch -- $attr {
	    -node {set node $val}
	    -desc {set desc $val}
	}
    }

    set browser(feature_handler,$feature) $handler
    set browser(feature_handler_node,$feature) $node
    if {$desc != ""} {
	set browser(feature_handler_desc,$feature) $desc
    }
}

hook::add postload_hook \
    {browser::register_ns_handler $::NS(disco_info) disco::browser::open_win \
	 -desc "[::msgcat::mc {Discover service}]"}
hook::add postload_hook \
    {browser::register_ns_handler $::NS(disco_items) disco::browser::open_win \
	 -desc "[::msgcat::mc {Discover service}]"}
