# MTR's config file for tkabber

set ssj::options(one-passphrase)  1
set ssj::options(sign-traffic)    1
set ssj::options(encrypt-traffic) 1

set debug_lvls                    [list zerobot]
set debug_winP                    1

set raise_new_tab                 0

set show_splash_window            1

set use_ispell                    1

proc debugmsg {module msg} {
    global debug_lvls w
    global debug_fd debug_winP

    if {![info exists debug_fd]} {
        catch { file rename -force -- ~/.tkabber/tkabber.log \
                                      ~/.tkabber/tkabber0.log }
        set debug_fd [open ~/.tkabber/tkabber.log \
                           { WRONLY CREAT TRUNC APPEND }]
        fconfigure $debug_fd -buffering line
    }

    puts $debug_fd [format "%s %-12.12s %s" \
                           [clock format [clock seconds] -format "%m/%d %T"] \
                           $module $msg]

    if {([lsearch -exact $debug_lvls $module] < 0) || (!$debug_winP)} {
        return
    }

    set dw $w.debug

    if {![winfo exists $dw]} {
        add_win $dw -title Debug -tabtitle debug -class Chat

        [ScrolledWindow $dw.sw] setwidget \
            [text $dw.body -yscrollcommand [list $dw.scroll set]]

        pack $dw.sw -side bottom -fill both -expand yes

        $dw.body tag configure module \
            -foreground [option get $dw theyforeground Chat]
        $dw.body tag configure proc   \
            -foreground [option get $dw meforeground Chat]
        $dw.body tag configure error  \
            -foreground [option get $dw errforeground Chat]
    }

    $dw.body insert end [format "%-12.12s" $module] module " "
    set tag normal
    switch -- $module {
        jlib {
            if {[set x [string first "(jlib::" $msg]] > 0} {
                set tag error
            }
            if {[set y [string first ")" $msg]] > 0} {
                $dw.body insert end \
                         [string range $msg [expr $x+7] [expr $y-1]] proc \
                         "\n"
                set msg [string trimleft \
                                [string range $msg [expr $y+1] end]]
            }
        }

        default {
        }
    }
    $dw.body insert end [string trimright $msg] $tag
    $dw.body insert end "\n"

    if {!$chat::options(stop_scroll)} {
        $dw.body see end
    }
}

set load_default_xrdb 0
option readfile ~/src/tkabber/tkabber/examples/dark.xrdb userDefault
option add *font fixed userDefault
switch -- [winfo screenwidth .]x[winfo screenheight .] {
    1400x1050
        -
    1280x1024 {
        option add Tkabber.geometry =788x550-0+0 userDefault    
    }

    1024x768
        -
    default {
        option add Tkabber.geometry =630x412-0+0 userDefault    
    }
}


proc postload {} {
# the autoaway module

    set plugins::autoaway::options(drop_priority) 0


# the chat module

    set chat::options(display_status_description) 0


# the conferenceinfo module

    set plugins::conferenceinfo::options(autoask)         1
    set plugins::conferenceinfo::options(interval)      300
    set plugins::conferenceinfo::options(err_interval) 3600


# the emoticon module

    emoteicons::load_dir ~/.tkabber/emoticons/rythmbox


# the georoster module

    source ~/src/tkabber/tkabber-plugins/georoster/georoster.tcl
#   source ~/.tkabber/proprietary/georoster-prop.tcl

    namespace eval georoster {
        variable mapnum 1
        variable mapwidth
        variable mapheight
        variable options

        set options(automatic)   1
        set options(check_vcard) 1
        set options(showcities)  none
        set options(show_last_known)  0

        switch -- [winfo screenwidth .]x[winfo screenheight .] {
            1400x1050
                -
            1280x1024 {
                set mapwidth  975
                set mapheight 506
            }

            1024x768
                -
            default {
                set mapwidth  650
                set mapheight 338

                set options(mapfile) \
                    ~/src/tkabber/tkabber-plugins/georoster/bwmap4.gif

                proc lo {x y} {expr {($x*2 - 649)*18/65 + 10}}
                proc la {x y} {expr {(371 - $y*2)*9/40}}

                proc x {lo la} {expr {(649+(($lo-10)*65/18))/2}}
                proc y {lo la} {expr {(371-($la * 40/9))/2}}
            }
        }


        variable M_PI       3.14159265358979323846
        variable M_PI_2     [expr $M_PI/2.0]
        variable deg_to_rad [expr $M_PI/180.0]
        variable TWO_PI     [expr $M_PI*2.0]
        variable M_DEG      [expr 180/$M_PI]
        variable M_INVDEG   [expr $M_PI/180]

        variable del_lon    [expr $TWO_PI/$mapwidth]
        variable del_lat    [expr $M_PI/$mapheight]

        variable lon_array
        for {set i 0} {$i < $mapwidth} {incr i} {
            set lon_array($i) [expr (($i+0.5)*$del_lon-$M_PI)]
        }

        variable lat_array
        for {set i 0} {$i < $mapheight} {incr i} {
            set lat_array($i) [expr ($M_PI_2 - ($i+0.5)*$del_lat)]
        }

        proc sp2px {lo la} {
            variable M_PI
            variable M_PI_2
            variable TWO_PI
            variable del_lon
            variable del_lat
            variable mapwidth
            variable mapheight

            if {$lo > $M_PI} {
                set lo [expr $lo-$TWO_PI]
            } elseif {$lo < -$M_PI} {
                set lo [expr $lo+$TWO_PI]
            }

            set x [expr round(($lo+$M_PI)/$del_lon + 0.5)]
            if {$x >= $mapwidth} {
                incr x -$mapwidth
            } elseif {$x < 0} {
                incr x $mapwidth
            }

            set y [expr round(($M_PI_2-$la)/$del_lat + 0.5)]
            if {$y >= $mapheight} {
                set y [expr $mapheight-1]
            }

            return [list $x $y]
        }

        proc refresh {} {
            variable mapcmd
            variable mapnum
            variable mapwidth
            variable mapheight

            if {![winfo exists .georoster.c]} {
                return [after [expr 60*1000] [namespace current]::refresh]
            }

            set file [file join [glob ~] .tkabber georoster_${mapnum}.gif]
            if {[catch { exec xplanet -geometry =${mapwidth}x${mapheight} \
                                      -projection rectangular \
                                      -output $file & } result]} {
                set_status "unable to create new georoster image: $result"
            } else {
                after [expr 60*1000] \
                      [list [namespace current]::refresh_aux $file]
            }
        }

        proc refresh_aux {file} {
            variable mapimage

            image delete $mapimage
            set mapimage [image create photo -file $file]
            catch { file delete -- $file }

            [set c .georoster.c] delete map
            $c create image 0 0 -image $mapimage -anchor nw -tag map
            $c configure -scrollregion [list 0 0 [image width $mapimage] \
                                                 [image height $mapimage]]

            proc x {lo la} {
                variable M_INVDEG

                lindex [sp2px [expr $lo*$M_INVDEG] [expr $la*$M_INVDEG]] 0
            }

            proc y {lo la} {
                variable M_INVDEG

                lindex [sp2px [expr $lo*$M_INVDEG] [expr $la*$M_INVDEG]] 1
            }

            proc lo {x y} {
                variable lon_array
                variable M_DEG
        
                if {[set x [expr int($x)]] < 0} {
                    set x 0
                } elseif {![info exists lon_array($x)]} {
                    return 180
                }
                return [expr $lon_array($x)*$M_DEG]
            }
    
            proc la {x y} {
                variable lat_array
                variable M_DEG
        
                if {[set y [expr int($y)]] < 0} {
                    set y 0
                } elseif {![info exists lat_array($x)]} {
                    return -90
                }
                return [expr $lat_array($y)*$M_DEG]
            }

            redraw $c

            after [expr 10*60*1000] [list [namespace current]::refresh]
        }
    }


# the ispell module

    set plugins::ispell::options(executable) ispell


# the login module

    global loginconf loginconf1 loginconf2

    set loginconf1(profile)     Default
    set loginconf1(user)        mrose

    set loginconf(password)      ""
    set loginconf(resource)      tkabber
    set loginconf(server)        jabber.dbc.mtview.ca.us
    set loginconf(port)          5222
    set loginconf(priority)      8
    set loginconf(usessl)        1
    set loginconf(sslport)       5223
    set loginconf(useproxy)      0
    set loginconf(httpproxy)     localhost
    set loginconf(httpproxyport) 3128

    array set loginconf          [array get loginconf1]


# the message module

    set message::options(headlines,cache) 1
    set message::options(headlines,multiple) 1


# the roster module

    set roster::show_only_online              1
    set roster::show_transport_icons          1
    set roster::show_transport_user_icons     1
    set roster::roster(collapsed,Conferences) 1
    set roster::roster(collapsed,Weather)     1
    set roster::roster(collapsed,Undefined)   1
    set roster::roster(collapsed,bots)        1
    set roster::roster(collapsed,transports)  1


# the sound module

    set sound::options(mute) 1


# special key bindings (due to KDE)

    bind . <Alt-Left>      {tab_move .nb -1}
    bind . <Alt-Right>     {tab_move .nb  1}
    bind . <Control-Left>  {current_tab_move .nb -1}
    bind . <Control-Right> {current_tab_move .nb  1}
    bind . <Control-Key-w> {
        if {[.nb raise] != ""} {
            eval destroy [pack slaves [.nb getframe [.nb raise]]]
            .nb delete [.nb raise] 1
            tab_move .nb 0
        }
    }
}


proc menuload {menudesc} {
    global version

return                                                                        \
[list                                                                         \
&TKabber "" "" 1                                                              \
      [list                                                                   \
            [list cascad  Presence                            "" presence 1   \
                  [list                                                       \
                        [list command Online               "" "" ""           \
                              -command "set userstatus available"]            \
                        [list command "Free to chat"          "" "" ""        \
                                      -command "set userstatus chat"]         \
                        [list command Away                    "" "" ""        \
                                      -command "set userstatus away"]         \
                        [list command "Extended Away"         "" "" ""        \
                                      -command "set userstatus xa"]           \
                        [list command Busy                    "" "" ""        \
                                      -command "set userstatus dnd"]          \
                        [list command Invisible               "" "" ""        \
                                      -command "set userstatus invisible"]    \
                        separator                                             \
                        [list command "Change priority"       "" "" ""        \
                                      -command change_priority_dialog]        \
                  ]                                                           \
            ]                                                                 \
            [list command "&Log in..."                        "" "" "Ctrl L"  \
                              -command show_login_dialog]                     \
            [list command "Log &out"                          "" "" ""        \
                              -command logout]                                \
            [list command "Log out &with Reason..."           "" "" ""        \
                              -command show_logout_dialog]                    \
            separator                                                         \
            [list command "Message archive..."                "" "" ""        \
                              -command message_archive::show_archive]         \
            separator                                                         \
            [list command "&My Information..."                "" "" ""        \
                              -command {                                      
userinfo::open ${loginconf(user)}@$loginconf(server)/$loginconf(resource) -editable 1
}]                                                                            \
            [list command "Change password..."                "" "" ""        \
                            -command change_password_dialog]                  \
            [list cascad  &Preferences                        "" preferences 1\
                [list                                                         \
                      [list checkbutton "Announce avatar"                     \
                                                              "" "" ""        \
                            -variable avatar::options(announce)]              \
                      [list checkbutton "Allow avatar to be downloaded"       \
                                                              "" "" ""        \
                            -variable avatar::options(share)]                 \
                      [list command "Store avatar on server"  "" "" ""        \
                            -command avatar::store_on_server]                 \
                      separator                                               \
                      [list checkbutton "Smart autoscroll"    "" "" ""        \
                            -variable chat::options(smart_scroll)]            \
                      [list checkbutton "Stop autoscroll"     "" "" ""        \
                            -variable chat::options(stop_scroll)]             \
                      [list checkbutton "Emphasize"           "" "" ""        \
                            -variable chat::options(emphasize)]               \
                      [list checkbutton "Default to chat"     "" "" ""        \
                            -onvalue  chat                                    \
                            -offvalue message                                 \
                            -variable chat::options(default_message_type)]    \
                      separator                                               \
                      [list checkbutton "Generate event messages" "" "" ""    \
                            -variable muc::options(gen_events)]               \
                      separator                                               \
                      [list checkbutton "Encrypt traffic (when possible)"     \
                                                              "" "" ""        \
                            -variable ssj::options(encrypt-traffic)]          \
                      [list checkbutton "Sign traffic"        "" "" ""        \
                            -variable ssj::options(sign-traffic)]             \
                      separator                                               \
                      [list cascad  JIDlink                   "" jidlink 1 ""]\
                      separator                                               \
                      [list cascad  &Roster                   "" roster  1    \
                            [list                                             \
                                  [list checkbutton                           \
                                     "Hide &Offline contacts" "" "" "Ctrl H"  \
                                     -command roster::redraw                  \
                                     -variable roster::show_only_online]      \
                                  [list checkbutton                           \
                                     "Use aliases"            "" "" ""        \
                                     -command roster::redraw                  \
                                     -variable roster::use_aliases]           \
                            ]                                                 \
                      ]                                                       \
                      separator                                               \
                      [list checkbutton "Mute Sound"          "" "" ""        \
                            -variable sound::options(mute)]                   \
                ]                                                             \
            ]                                                                 \
            [list command "Customize..."                      "" "" ""        \
                            -command "custom::open_window Tkabber"]           \
            separator                                                         \
            [list command E&xit                               "" "" "Ctrl Q"  \
                              -command quit]                                  \
      ]                                                                       \
                                                                              \
&Services "" "" 1                                                             \
      [list                                                                   \
            [list command "New Blank &Message"                "" "" ""        \
                              -command message::send_dialog]                  \
            separator                                                         \
            [list command "&Add Contact..."                   "" "" "Ctrl U"  \
                              -command message::send_subscribe_dialog]        \
            [list command "Add &Group..."                     "" "" ""        \
                              -command add_group_dialog]                      \
            [list command "Browse Agents/IM Systems..."       "" "" "Ctrl B"  \
                              -command browser::open]                         \
            [list command "Discover..."                       "" "" ""        \
                              -command disco::browser::open_win]              \
            [list command "Show user info..."                 "" "" ""        \
                              -command userinfo::show_info_dialog]            \
            separator                                                         \
            [list command "Add group by regexp on JIDs..."    "" "" ""        \
                             -command roster::add_group_by_jid_regexp_dialog] \
            [list cascad  "Export roster..."                                  \
                             export_roster export_roster 0 ""]                \
            [list cascad  "Import roster..."                                  \
                             import_roster import_roster 0 ""]                \
            separator                                                         \
            [list command "Join Group &Chat..."               "" "" "Ctrl C"  \
                              -command join_group_dialog]                     \
            [list command "Jabber Message &Rules"             "" "" ""        \
                              -command filters::open]                         \
            [list command "Privacy rules..."                  "" "" ""        \
                            -command privacy::request_lists]                  \
      ]                                                                       \
                                                                              \
&Help "" "" 1                                                                 \
      [list                                                                   \
            [list command "&Quick Help..."                "" "" ""            \
                              -command {
help_window "Quick Help" "
Tabs:
    C-F4                Close tab
    C-Left/Right        Move tab left/right
    A-Left/Right        Go to previous/next tab
    A-N         Show tab #N (1-10)
    C-r         Hide/Show roster 

Chats:
    TAB         Complete nickname
    C-Up/Dn     Go to previous/next history message
    A-e         Show emoticons
    C-z         Undo
    C-Z         Redo
    A-PgUp/Dn   Scroll chat window up/down
    Right-click Correct word
"}]                                                                           \
            [list command "&About..."                     "" "" ""            \
                              -command about_window]                          \
            [list cascad   &Debug                            "" debug 1       \
                [debug_buttons]                                               \
            ]                                                                 \
      ]                                                                       \
]
}

proc debug_buttons {} {
    global debug_modules debug_lvls

    set buttons {}
    foreach l [list avatar       \
                    browser      \
                    chat         \
                    conference   \
                    disco        \
                    emoticons    \
                    filetransfer \
                    filters      \
                    georoster    \
                    hook         \
                    iface        \
                    iq           \
                    jidlink      \
                    jlib         \
                    logger       \
                    login        \
                    message      \
                    negotiate    \
                    nick         \
                    plugins      \
                    presence     \
                    register     \
                    roster       \
                    search       \
                    ssj          \
                    tkabber      \
                    userinfo     \
                    utils        \
                    warning      \
                    zerobot] {
        if {[lsearch -exact $debug_lvls $l] >= 0} {
            set debug_modules($l) 1
        } else {
            set debug_modules($l) 0
        }

        lappend buttons \
                [list checkbutton $l {} {} {} \
                      -variable debug_modules($l) -command debug_update]
    }

    return $buttons
}

proc debug_update {} {
    global debug_modules debug_lvls
    
    set debug_lvls {}
    foreach {k v} [array get debug_modules] {
        if {$v} {
            lappend debug_lvls $k
        }
    }
}


proc roster_user_popup_info {info connid user} {
    set text [set $info]
    if {([set x [string first "(" $text]] > 0) \
            && ([string compare [string index $text end] ")"] == 0) \
            && ([string first "\n" [string range $text $x end]] > 0)} {
        set start [string range $text 0 [expr $x-1]]
        if {[set y [string last ":" $start]] > 0} {
            set start [string range $start 0 [expr $y-1]]
        }
        set $info $start
        append $info "\n    " 
        append $info [string map [list "\n" "\n    "] \
                             [string range $text [expr $x+1] end-1]]
    }
}

hook::add roster_user_popup_info_hook \
          [namespace current]::roster_user_popup_info 1


namespace eval jbot {
    proc open_chat_post {chatid type} {
        global usetabbar

        if {[cequal [chat::get_nick [chat::get_jid $chatid] $type]/$type \
                    jbot/chat]} {
            set cw [chat::winid $chatid]
            pack forget $cw.csw
            pack $cw.csw -expand yes -fill both -side left
            destroy $cw.status $cw.input $cw.pw0
            if {$usetabbar} {
                .nb itemconfigure [crange [win_id tab $cw] 1 end] \
                    -text jbot \
                    -raisecmd "tab_set_updated [list $cw]
                               hook::run raise_chat_tab_hook [list $cw] [list $chatid]"
            }

            return stop
        }
    }

    proc draw_message {chatid from type body x} {
        if {[cequal [chat::get_nick $from $type]/$type jbot/chat]} {
            set cw [chat::chat_win $chatid]
            foreach line [split [string trimright $body] "\n"] {
                if {[cequal [string index $line 15] " "]} {
                    $cw insert end [string range $line 0 15] me
                    set line [string range $line 16 end]
                    if {([set d [string first " " $line]] > 0) \
                            && (([string first ": " $line] > $d)
                                    || ([string first "last message repeated" \
                                                $line] > $d))} {
                        $cw insert end [string range $line 0 $d] they
                        set line [string range $line [expr $d+1] end]
                    }
                }
                if {[set d [string first ": " $line]] > 0} {
                    $cw insert end [string range $line 0 $d] me
                    set line [string range $line [expr $d+1] end]
                }
                $cw insert end "$line\n" ""
            }

            return stop
        }
    }

    proc normalize_chat_id {chatidvar type} {
        upvar 2 $chatidvar chatid

        if {[cequal [chat::get_nick [set jid [chat::get_jid $chatid]] \
                                    $type]/$type \
                    jbot/chat]} {
            set chatid [chat::chatid [chat::get_connid $chatid] \
                            [node_and_server_from_jid $jid]/syslog]
        }
    }

    hook::add open_chat_post_hook    [namespace current]::open_chat_post     1
    hook::add draw_message_hook      [namespace current]::draw_message       1
    hook::add normalize_chat_id_hook [namespace current]::normalize_chat_id  1
}


if {(![file exists [set file .jsendrc.tcl]]) \
        && (![file exists [set file ~/.jsendrc.tcl]])} {
    return
}
source $file

namespace eval zerobot {
    proc examine_message {from id type subject body err thread priority x} {
        global userstatus

        switch -- $userstatus {
            away
                -
            xa {
                if {([string length [set body [checkP $from $type $subject \
                                                     $body $x]]] > 0) \
                        && ([catch { notify $from $body } result])} {
                    debugmsg zerobot "notify: $result"
                }
            }

            default {
                reset
            }
        }
    }

    hook::add examine_message_hook   [namespace current]::examine_message   10
}


proc finload {} {
    georoster::refresh

    catch { destroy .mainframe.topf }
}


proc browseurl {url} {
    exec konqueror $url &
}


proc connload {connid} {
    return

    foreach g [list xmpp] {
        join_group ${g}@ietf.xmpp.org -nick mrose -connection $connid
    }
    join_group wgchairs@conference.psg.com -nick mrose -connection $connid
}

hook::add connected_hook connload 1000


return

# temporary, until a general solution is decided...
foreach {jid la lo} [list usca0967@pogoda.chrome.pl 38.52 -121.50 \
                          usca0982@pogoda.chrome.pl 32.73 -117.17 \
                          usmn0503@pogoda.chrome.pl 44.88  -93.22] {
    georoster::update_jid .georoster.c $jid $la $lo
}
