# $Id: joingrdialog.tcl,v 1.36 2003/11/08 20:10:35 aleksey Exp $

#set gr_nick $user
set gr_group "talks"
if {[info exists loginconf(server)]} {
    set gr_server conference.$loginconf(server)
} else {
    set gr_server conference.jabber.org
}
set gr_passwd ""

custom::defvar gr_nick_list {} \
        [::msgcat::mc "Join group dialog data (nicks)."] -group Hidden
custom::defvar gr_group_list {} \
        [::msgcat::mc "Join group dialog data (groups)."] -group Hidden
custom::defvar gr_server_list {} \
        [::msgcat::mc "Join group dialog data (servers)."] -group Hidden

proc ecursor_entry {e} {
    $e icursor end
}

proc pack_input {fr row var lab args} {

    label $fr.l$var -text $lab
    ecursor_entry [eval entry $fr.$var -textvar $var $args]

    grid $fr.l$var -row $row -column 0 -sticky e
    grid $fr.$var  -row $row -column 1 -sticky ew
}

proc pack_combo {fr row var lab args} {

    label $fr.l$var -text $lab
    ecursor_entry [eval ComboBox $fr.$var -textvariable $var $args].e

    grid $fr.l$var -row $row -column 0 -sticky e
    grid $fr.$var  -row $row -column 1 -sticky ew
}

proc update_combo_list {list entry num} {

    set ind [lsearch -exact $list $entry]
    if {$ind >= 0} {
	set newlist [linsert [lreplace $list $ind $ind] 0 $entry]
    } else {
	set newlist [linsert $list 0 $entry]
    }
    if {[llength $newlist] > $num} {
	return [lreplace $newlist end end]
    } else {
	return $newlist
    }
}

proc join_group_dialog {args} {
    global gr_nick gr_group gr_server gr_connid
    global gr_nick_list gr_group_list gr_server_list

    foreach {opt val} $args {
	switch -- $opt {
	    -server     {set server $val}
	    -group      {set group $val}
	    -nick       {set nick $val}
	    -connection {set connid $val}
	}
    }

    set gw .joingroup
    catch { destroy $gw }

    Dialog $gw -title [::msgcat::mc "Join group"] -separator 1 -anchor e \
	    -default 0 -cancel 1

    set gf [$gw getframe]
    grid columnconfigure $gf 1 -weight 1

    if {[info exists group]} {
	set gr_group $group
#	set gr_group_list [update_combo_list $gr_group_list $gr_group 20]
    } elseif {[llength $gr_group_list]} {
	set gr_group [lindex $gr_group_list 0]
    }
    if {[info exists server]} {
	set gr_server $server
#	set gr_server_list [update_combo_list $gr_server_list $gr_server 10]
    } elseif {[llength $gr_server_list]} {
	set gr_server [lindex $gr_server_list 0]
    }
    if {[info exists nick]} {
	set gr_nick $nick
#	set gr_nick_list [update_combo_list $gr_nick_list $gr_nick 10]
    } else {
	set gr_nick [get_group_nick ${gr_group}@$gr_server $gr_nick]
    }
    if {![info exists connid]} {
	set connid [jlib::route ${gr_group}@$gr_server]
    }
    set gr_connid [jlib::connection_jid $connid]

    pack_combo $gf 0 gr_nick [::msgcat::mc "Nick:"] -values $gr_nick_list
    pack_combo $gf 1 gr_group [::msgcat::mc "Group:"] -values $gr_group_list
    pack_combo $gf 2 gr_server [::msgcat::mc "Server:"] -values $gr_server_list
    pack_input $gf 3 gr_passwd [::msgcat::mc "Password:"] -width 30 -show *

    if {[llength [jlib::connections]] > 1} {
	foreach c [jlib::connections] {
	    lappend connections [jlib::connection_jid $c]
	}
	pack_combo $gf 5 gr_connid [::msgcat::mc "Connection:"] \
	    -values $connections
    }

    $gw add -text [::msgcat::mc "Join"] -command [list join_group1 $gw]
	    
    $gw add -text [::msgcat::mc "Cancel"] -command [list destroy $gw]

    $gw draw $gf.gr_nick
}

proc join_group1 {gw} {
    global gr_nick gr_group gr_server gr_connid
    global gr_nick_list gr_group_list gr_server_list

    destroy $gw

    set gr_nick_list [update_combo_list $gr_nick_list $gr_nick 10]
    set gr_group_list [update_combo_list $gr_group_list $gr_group 20]
    set gr_server_list [update_combo_list $gr_server_list $gr_server 10]
    set custom::saved(::::gr_nick_list) $gr_nick_list
    set custom::saved(::::gr_group_list) $gr_group_list
    set custom::saved(::::gr_server_list) $gr_server_list
    custom::store

    set connid [jlib::route ${gr_group}@$gr_server]
    foreach c [jlib::connections] {
	if {[jlib::connection_jid $c] == $gr_connid} {
	    set connid $c
	}
    }

    join_group ${gr_group}@$gr_server -nick $gr_nick -connection $connid
}

proc join_group {jid args} {
    global gr_nick

    foreach {opt val} $args {
	switch -- $opt {
	    -connection {set connid $val}
	    -nick       {set nick $val}
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route $jid]
    }
    if {![info exists nick]} {
	set nick [get_group_nick $jid $gr_nick]
    }

    muc::request_negotiation $connid $jid
    muc::wait_for_negotiation $jid

    if {[muc::is_compatible $jid]} {
	global gr_passwd
	muc::join_group $connid $jid $nick $gr_passwd
    } else {
	jlib::send_presence -to ${jid}/${nick} -connection $connid
	set chatid [chat::chatid $connid $jid]
	set_our_groupchat_nick $chatid $nick
	chat::open_window $chatid groupchat
    }
}

proc set_our_groupchat_nick {group nick} {
    global groupchats

    set group [tolower_node_and_domain $group]
    set groupchats(nick,$group) $nick
    debugmsg conference [array get groupchats]
}

proc get_our_groupchat_nick {group} {
    global groupchats
    
    debugmsg conference [array get groupchats]
    debugmsg conference "GET NICK: [list $group]"
    return $groupchats(nick,$group)
}

proc add_group_dialog {} {
    global gra_group gra_server gra_connid

    set gw .addgroup
    catch { destroy $gw }

    Dialog $gw -title [::msgcat::mc "Add group"] -separator 1 -anchor e \
	    -default 0 -cancel 1

    set gf [$gw getframe]

    label $gf.lgroup -text [::msgcat::mc "Group:"]
    ecursor_entry [entry $gf.group -textvariable gra_group]
    label $gf.lserver -text [::msgcat::mc "Server:"]
    ecursor_entry [entry $gf.server -textvariable gra_server]

    grid $gf.lgroup  -row 0 -column 0 -sticky e
    grid $gf.group   -row 0 -column 1 -sticky ew
    grid $gf.lserver -row 1 -column 0 -sticky e
    grid $gf.server  -row 1 -column 1 -sticky ew

    set gra_connid ""
    if {[llength [jlib::connections]] > 1} {
	foreach c [jlib::connections] {
	    lappend connections [jlib::connection_jid $c]
	}
	set gra_connid [jlib::connection_jid [lindex [jlib::connections] 0]]
	pack_combo $gf 2 gra_connid [::msgcat::mc "Connection:"] \
	    -values $connections
    }
    

    $gw add -text [::msgcat::mc "Add"] -command "add_conference $gw"
    $gw add -text [::msgcat::mc "Cancel"] -command "destroy $gw"

    $gw draw $gf.group
}

proc add_conference {gw} {
    global gra_group gra_server gra_connid

    destroy $gw

    set connid [jlib::route ${gra_group}@$gra_server]
    foreach c [jlib::connections] {
	if {[jlib::connection_jid $c] == $gra_connid} {
	    set connid $c
	}
    }

    jlib::send_iq set \
	[jlib::wrapper:createtag query \
	     -vars {xmlns jabber:iq:roster} \
	     -subtags [list [jlib::wrapper:createtag item \
				 -vars [list jid ${gra_group}@$gra_server \
					    category conference] \
				 -subtags [list [jlib::wrapper:createtag \
						     group \
						     -chdata Conferences]]]]] \
	-connection $connid

}

