# $Id: presence.tcl,v 1.50 2003/11/04 20:59:01 aleksey Exp $


proc client:presence {connid from type x args} {
    global presence

    debugmsg presence "PRESENCE: $from; $type; $x; $args"

    set from [tolower_node_and_domain $from]

    switch -- $type {
	error -
	unavailable {
            if {[cequal $type unavailable]} {
	        presence_process_x $connid $from $type $x
	    }

	    catch { unset presence(type,$connid,$from) }
	    catch { unset presence(status,$connid,$from) }
	    catch { unset presence(priority,$connid,$from) }
	    catch { unset presence(meta,$connid,$from) }
	    catch { unset presence(icon,$connid,$from) }
	    catch { unset presence(show,$connid,$from) }
	    catch { unset presence(loc,$connid,$from) }
	    catch { unset presence(x,$connid,$from) }
	    catch { unset presence(signed,$connid,$from) }

	    set user [node_and_server_from_jid $from]
	    if {[info exists presence(user_jids,$connid,$user)]} {
		set idx [lsearch -exact $presence(user_jids,$connid,$user) $from]
		set presence(user_jids,$connid,$user) \
		    [lreplace $presence(user_jids,$connid,$user) $idx $idx]
	    }
	    cache_preferred_jid_on_unavailable $connid $from $user
	    cache_user_status $connid $user

	    foreach {attr val} $args {
		if {[cequal $attr -status]} {
		    set presence(status,$connid,$from) $val
		    if {[get_user_status $connid $user] == "unavailable"} {
			set presence(status,$connid,$user) $val
		    }
		}
	    }

	    roster::on_change_jid_presence $connid $from
	    debugmsg presence "$connid $from unavailable"
	    chat::change_presence $connid $from $type
	}
	subscribe {eval [list message::show_subscribe_dialog $from $x] $args}
	subscribed {}
	unsubscribe {}
	unsubscribed {
	    MessageDlg .unsubscribed -aspect 50000 -icon info \
		-title [format [::msgcat::mc "Unsubscribed from %s"] $from] \
		-message [format \
			      [::msgcat::mc "We unsubscribed from %s"] $from] \
		-type user -buttons {ok} -default 0 -cancel 0
	}
	probe {}
	default {
	    set presence(type,$connid,$from)     available
	    set presence(status,$connid,$from)   ""
	    set presence(priority,$connid,$from) 0
	    set presence(meta,$connid,$from)     ""
	    set presence(icon,$connid,$from)     ""
	    set presence(show,$connid,$from)     available
	    set presence(loc,$connid,$from)      ""
	    set presence(x,$connid,$from)        $x
	    
	    foreach {attr val} $args {
		switch -- $attr {
		    -status   {set presence(status,$connid,$from)   $val}
		    -priority {set presence(priority,$connid,$from) $val}
		    -meta     {set presence(meta,$connid,$from)     $val}
		    -icon     {set presence(icon,$connid,$from)     $val}
		    -show     {set presence(show,$connid,$from)     $val}
		    -loc      {set presence(loc,$connid,$from)      $val}
		}
	    }
	    
	    set presence(show,$connid,$from) [normalize_show $presence(show,$connid,$from)]
	    set show $presence(show,$connid,$from)

	    set user [node_and_server_from_jid $from]
	    if {![info exists presence(user_jids,$connid,$user)] || \
		    ![lcontain $presence(user_jids,$connid,$user) $from]} {
		lappend presence(user_jids,$connid,$user) $from
	    }

	    cache_preferred_jid_on_available $connid $from $user
	    cache_user_status $connid $user

	    presence_process_x $connid $from available $x

	    roster::on_change_jid_presence $connid $from
	    chat::change_presence $connid $from $show
	}
    }
    
    hook::run client_presence_hook $connid $from $type $x $args
}



proc get_jids_of_user {connid user} {
    global presence

    if {[info exists presence(user_jids,$connid,$user)]} {
	return $presence(user_jids,$connid,$user)
    } elseif {![cequal [resource_from_jid $user] ""]} {
	if {[info exists presence(type,$connid,$user)]} {
	    return [list $user]
	}
    }
    return {}
}

proc get_jid_of_user {connid user} {
    global presence

    if {[info exists presence(preferred_jid,$connid,$user)]} {
	return $presence(preferred_jid,$connid,$user)
    } else {
	return $user
    }
}

proc cache_preferred_jid_on_available {connid jid user} {
    global presence

    if {[info exists presence(maxpriority,$connid,$user)]} {
	set maxpri $presence(maxpriority,$connid,$user)
    } else {
	cache_preferred_jid $connid $user
	return
    }
    
    set pri $presence(priority,$connid,$jid)

    if {$pri > $maxpri} {
	set presence(maxpriority,$connid,$user) $pri
	set presence(preferred_jid,$connid,$user) $jid
    }
}

proc cache_preferred_jid_on_unavailable {connid jid user} {
    global presence

    if {![info exists presence(maxpriority,$connid,$user)]} {
	cache_preferred_jid $connid $user
	return
    }
    
    if {$presence(preferred_jid,$connid,$user) == $jid} {
	unset presence(preferred_jid,$connid,$user)
	unset presence(maxpriority,$connid,$user)
	cache_preferred_jid $connid $user
    }
}

proc cache_preferred_jid {connid user} {
    global presence

    set jids [get_jids_of_user $connid $user]

    if {$jids != {}} {
	set rjid [lindex $jids 0]
	set pri $presence(priority,$connid,$rjid)

	foreach jid $jids {
	    if {$presence(priority,$connid,$jid) > $pri} {
		set pri $presence(priority,$connid,$jid)
		set rjid $jid
	    }
	}

	set presence(maxpriority,$connid,$user) $pri
	set presence(preferred_jid,$connid,$user) $rjid
    }
}


proc get_jid_status {connid jid} {
    global presence

    set j $jid
    if {[info exists presence(show,$connid,$j)]} {
	return $presence(show,$connid,$j)
    } else {
	return unavailable
    }
}

proc get_jid_presence_info {param connid jid} {
    global presence

    if {[info exists presence($param,$connid,$jid)]} {
	return $presence($param,$connid,$jid)
    } else {
	return ""
    }
}

proc get_user_status {connid user} {
    global presence

    if {[info exists presence(cachedstatus,$connid,$user)]} {
	return $presence(cachedstatus,$connid,$user)
    } elseif {[info exists presence(show,$connid,$user)]} {
	return $presence(show,$connid,$user)
    } else {
	return unavailable
    }
}

proc cache_user_status {connid user} {
    global presence

    set jid [get_jid_of_user $connid $user]
    if {[info exists presence(show,$connid,$jid)]} {
	set presence(cachedstatus,$connid,$user) $presence(show,$connid,$jid)
    } else {
	set presence(cachedstatus,$connid,$user) unavailable
    }
}

proc get_user_status_desc {connid user} {
    global presence

    set jid [get_jid_of_user $connid $user]
    if {[info exists presence(status,$connid,$jid)]} {
	return $presence(status,$connid,$jid)
    } else {
	return ""
    }
}

array set status_priority {
    stalker     0
    unavailable 1
    xa          2
    away        3
    dnd         4
    available   5
    chat        6
}

proc compare_status {s1 s2} {
    global status_priority
    set p1 $status_priority($s1)
    set p2 $status_priority($s2)
    if {$p1 > $p2} {
	return 1
    } elseif {$p1 == $p2} {
	return 0
    } else {
	return -1
    }
}

proc max_status {s1 s2} {
    global status_priority
    set p1 $status_priority($s1)
    set p2 $status_priority($s2)
    if {$p1 >= $p2} {
	return $s1
    } else {
	return $s2
    }
}

set userpriority 0
set curuserstatus [set userstatus available]
set curtextstatus [set textstatus ""]

set userstatusdesc [::msgcat::mc "Not logged in"]

set statusdesc(available) [::msgcat::mc "Online"]
set statusdesc(chat) [::msgcat::mc "Free to chat"]
set statusdesc(away) [::msgcat::mc "Away"]
set statusdesc(xa) [::msgcat::mc "Extended Away"]
set statusdesc(dnd) [::msgcat::mc "Do not disturb"]
set statusdesc(invisible) [::msgcat::mc "Invisible"]
set statusdesc(unavailable) [::msgcat::mc "Offline"]


proc change_priority_dialog {} {
    global tmppriority
    global userpriority

    set tmppriority $userpriority

    set w .change_priority
    if {[winfo exists $w]} {
	focus -force $w
	return
    }

    Dialog $w -title [::msgcat::mc "Change Presence Priority"] \
	-modal none -separator 1 -anchor e -default 0 -cancel 1

    $w add -text [::msgcat::mc "OK"] \
	-command [list do_change_priority $w]
    $w add -text [::msgcat::mc "Cancel"] -command [list destroy $w]
    
    set f [$w getframe]
    label $f.lpriority -text [::msgcat::mc "Priority:"]
    Spinbox $f.priority -1000 1000 1 tmppriority

    grid $f.lpriority -row 0 -column 0 -sticky e
    grid $f.priority  -row 0 -column 1 -sticky ew

    grid columnconfigure $f 0 -weight 1 
    grid columnconfigure $f 1 -weight 1

    $w draw

}

proc do_change_priority {w} {
    global tmppriority
    global userpriority

    destroy $w
    if {![cequal $userpriority $tmppriority]} {
        set userpriority $tmppriority
        change_our_presence userpriority {} w
    }
}

trace variable userstatus w change_our_presence

proc change_our_presence {name1 name2 op} {
    global userstatus curuserstatus statusdesc userstatusdesc
    global textstatus curtextstatus
    global userpriority

    if {(![cequal $userstatus $curuserstatus]) \
	    || (![cequal $textstatus $curtextstatus]) \
	    || [cequal $name1 userpriority]} {
	if {[lsearch -exact [array names statusdesc] $userstatus] < 0} {
	    error [cconcat [::msgcat::mc "invalid userstatus value "] $userstatus]
	}

	set userstatusdesc $statusdesc($userstatus)
	set status $textstatus
	if {$::ssj::options(sign-traffic) && [cequal $status {}]} {
	    set status $userstatusdesc
	}

	set p $userpriority
	set x [get_our_presence_xlist $status]

	switch -- $userstatus {
	    available {set command [list jlib::send_presence \
					-xlist $x -pri $p]}
            unavailable -
	    invisible {set command [list jlib::send_presence \
					-type $userstatus -xlist $x -pri $p]}
	    default {
		set command [list jlib::send_presence \
				 -show $userstatus -xlist $x -pri $p]
	    }
	}
        if {![cequal $status ""]} {
	    lappend command -stat $status
	}
	debugmsg presence $command

	foreach connid [jlib::connections] {
	    eval $command -connection $connid
	}
	if {$userstatus != "invisible"} {
	    foreach chatid [array names chat::opened] {
		set connid [chat::get_connid $chatid]
		set group [chat::get_jid $chatid]
	        if {[cequal $chat::chats(type,$chatid) groupchat]} {
		    eval $command -to [list $group] -connection $connid
		}
	    }
	} else {
	    foreach chatid [array names chat::opened] {
		set connid [chat::get_connid $chatid]
		set group [chat::get_jid $chatid]
	        if {[cequal $chat::chats(type,$chatid) groupchat]} {
		    jlib::send_presence \
		        -to $group/[get_our_groupchat_nick $group] \
			-connection $connid \
			-xlist $x
		}
	    }
	}

	set curuserstatus $userstatus
	set curtextstatus $textstatus
	hook::run change_our_presence_post_hook $userstatus
    }
}

proc send_first_presence {connid} {
    global userstatus curuserstatus statusdesc userstatusdesc
    global textstatus curtextstatus
    global userpriority
    global loginconf

    if {[lsearch -exact [array names statusdesc] $userstatus] < 0} {
	error [cconcat [::msgcat::mc "invalid userstatus value "] $userstatus]
    }

    set userstatusdesc $statusdesc($userstatus)
    set status $textstatus
    if {$::ssj::options(sign-traffic) && [cequal $status {}]} {
	set status $userstatusdesc
    }

    set p [set userpriority $loginconf(priority)]
    set x [get_our_presence_xlist $status]

    switch -- $userstatus {
	available {set command [list jlib::send_presence \
				    -xlist $x -pri $p]}
	unavailable -
	invisible {set command [list jlib::send_presence \
				    -type $userstatus -xlist $x -pri $p]}
	default {
	    set command [list jlib::send_presence \
			     -show $userstatus -xlist $x -pri $p]
	}
    }
    if {![cequal $status ""]} {
	lappend command -stat $status
    }
    debugmsg presence $command

    eval $command -connection $connid

    set curuserstatus $userstatus
    set curtextstatus $textstatus
    if {[cequal $userstatus unavailable]} {
	set curuserstatus available
        set userstatus available
    } else {
	set curuserstatus $userstatus
	set userstatus $userstatus
    }

    hook::run change_our_presence_post_hook $userstatus
}

proc send_custom_presence {jid status} {
    global statusdesc
    global userpriority

    if {$::ssj::options(sign-traffic)} {
	set stat $statusdesc($status)
    } else {
	set stat ""
    }
    set p $userpriority
    set x [get_our_presence_xlist $stat]

    switch -- $status {
	available {set command [list jlib::send_presence -to $jid \
				    -xlist $x -pri $p]}
	unavailable {set command [list jlib::send_presence -to $jid \
				      -type $status -xlist $x -pri $p]}
	default {
	    set command [list jlib::send_presence -to $jid \
			     -show $status -xlist $x -pri $p]
	}
    }
    if {![cequal $stat ""]} {
	lappend command -stat $stat
    }

    debugmsg presence $command
    eval $command
}

proc get_our_presence_xlist {status} {
    set xs {}

    foreach x [list [avatar::get_presence_x] \
		    [make_signature $status]] {
	if {$x != {}} {
	    lappend xs $x
	}
    }

    return $xs
}

proc normalize_show {show} {
    set res $show
    
    switch -- $show {
	away        {}
	chat        {}
    	dnd         {}
	xa          {}
	unavailable {}
	stalker     {}
	default     {set res available}
    }
    return $res
}


proc presence_process_x {connid from type xs} {
    global presence
    # TODO: use connid
    catch { unset presence(signed,$connid,$from) }
    foreach x $xs {
	jlib::wrapper:splitxml $x tag vars isempty chdata children
	switch -- [jlib::wrapper:getattr $vars xmlns] {
	    jabber:x:avatar {
		avatar::set_hash $from $children
	    }

	    jabber:x:signed {
		check_signature $connid $from $chdata
	    }

	    "http://jabber.org/protocol/muc#user" {
		muc::process_gc_user $connid $from $type $children
	    }
	}
    }
}

proc check_signature {connid from signature} {
    global presence

# in case the sender didn't check the exit code from gpg...
    if {([cequal $signature ""]) \
	    || ([cequal [info commands ::ssj::signed:input] ""])} {
	return
    }

    set presence(signed,$connid,$from) \
	[ssj::signed:input $from $signature $presence(status,$connid,$from) \
		"Presence information"]
}

proc make_signature {status} {
    if {(![cequal [info commands ::ssj::signed:output] ""]) \
	    && (![catch { ssj::signed:output $status } chdata]) \
	    && (![cequal $chdata ""])} {
	return [jlib::wrapper:createtag x -vars {xmlns jabber:x:signed} \
			-chdata $chdata]
    }
}


proc clear_presence_info {connid} {
    global presence

    if {$connid == {}} {
	array unset presence
    } else {
	# TODO
	array unset presence type,$connid,*
	array unset presence status,$connid,*
	array unset presence priority,$connid,*
	array unset presence meta,$connid,*
	array unset presence icon,$connid,*
	array unset presence show,$connid,*
	array unset presence loc,$connid,*
	array unset presence x,$connid,*
	array unset presence user_jids,$connid,*
	array unset presence preferred_jid,$connid,*
	array unset presence cachedstatus,$connid,*
	array unset presence maxpriority,$connid,*
    }
}
hook::add disconnected_hook clear_presence_info
