#!/bin/sh
# the next line restarts using the correct interpreter \
exec wish "$0" -name tkabber "$@"

# $Id: tkabber.tcl,v 1.195 2003/12/18 19:23:40 aleksey Exp $

lappend auto_path [file dirname [info script]]

package require msgcat
if {[info exists ::env(LC_MESSAGES)]} {
    ::msgcat::mclocale $::env(LC_MESSAGES)
}
package require BWidget

tk appname tkabber

set version 0.9.6beta



if {$tcl_platform(platform) == "unix"} {
    set debug_lvls {jlib warning}
} else {
    set debug_lvls {}
}

proc debugmsg {level msg} {
    global debug_lvls

    if {[lsearch -exact $debug_lvls $level] >= 0} {
	puts "$level: $msg"
    }
}


proc rescmd {id res ls} {
    puts "RESULT: $id $res $ls"
}

set rootdir [file dirname [info script]]
proc fullpath {args} {
    global rootdir
    return [eval file join $rootdir $args]
}

proc pixmap {args} {
    global pixmaps_theme

    if {[cequal [cindex $pixmaps_theme end] /]} {
	set p [eval file join [list $pixmaps_theme] $args]
    } else {
	set p [eval fullpath pixmaps $pixmaps_theme $args]
    }
    if {[file exists $p]} {
	return $p
    } else {
	return [eval fullpath pixmaps default $args]
    }
}

proc load_source {args} {
    set fullpath [eval fullpath $args]

    debugmsg tkabber "Loading $fullpath"
    uplevel #0 source $fullpath
}

proc quit {{status 0}} {
    hook::run quit_hook

    destroy .
    exit $status
}

namespace eval ssj {}
load_source hooks.tcl

load_source default.tcl

hook::add postload_hook postload
hook::add finload_hook finload

if {[file exists ~/.tkabber/config.tcl]} {
    source ~/.tkabber/config.tcl
}

if {$tcl_platform(platform) == "unix" && \
	(![info exists load_default_xrdb] || $load_default_xrdb)} {
    option readfile [fullpath default.xrdb] startupFile
}

set sysenc [encoding system]
encoding system utf-8
::msgcat::mcload [file join $rootdir msgs]
foreach pr [::msgcat::mcpreferences] {
    set f [file join $rootdir msgs "$pr.rc"]
    if {[file exists $f]} {
	option read $f
	break
    }
}
foreach pr [::msgcat::mcpreferences] {
    set f [file join $::BWIDGET::LIBRARY "lang" "$pr.rc"]
    if {[file exists $f]} {
	option read $f
	break
    }
}
encoding system $sysenc
unset sysenc pr f

if {[catch { package require Tclx }]} {
    load_source Tclx.tcl
}

package require jabberlib 0.8.4
load_source xmppmime.tcl

foreach {opt val} $argv {
    switch -- $opt {
	-mime {set mime_file $val}
	-user {set loginconf(user) $val}
	-password {set loginconf(password) $val}
	-resource {set loginconf(resource) $val}
	-port {set loginconf(port) $val}
	-autologin {set autologin $val}
	-chat {xmppmime::send_event [list chat $val]}
	-message {xmppmime::send_event [list message $val]}
	-conference {xmppmime::send_event [list groupchat $val]}
    }
}

if {[info exists mime_file]} {
    xmppmime::load $mime_file
}
if {[xmppmime::is_done]} exit

if {![info exists show_splash_window] || $show_splash_window} {
    load_source splash.tcl
}


proc ::LOG {text} {
    debugmsg jlib $text
}

if {[catch { package require Img }]} {
    debugmsg tkabber \
        "unable to load the Img package, so no PNG/JPEG image support!

The IMG package is available at http://www.xs4all.nl/~nijtmans/img.html"
}

load_source custom.tcl
load_source utils.tcl
load_source plugins.tcl
load_source balloon.tcl
load_source presence.tcl
load_source iq.tcl
load_source roster.tcl
load_source itemedit.tcl
load_source sound.tcl
load_source messages.tcl
load_source textundo dkflib.tcl
load_source textundo textundo.tcl
load_source chats.tcl
load_source joingrdialog.tcl
load_source muc.tcl
load_source emoticons.tcl
load_source login.tcl
load_source browser.tcl
load_source disco.tcl
load_source userinfo.tcl
load_source datagathering.tcl
load_source negotiate.tcl
load_source mclistbox-1.02 mclistbox.tcl
load_source search.tcl
load_source register.tcl
load_source jidlink.tcl
load_source filetransfer.tcl
load_source filters.tcl
load_source privacy.tcl
load_source avatars.tcl
load_source gpgme.tcl
load_source bwidget_workarounds.tcl
load_source [file join aniemoteicons aniemoteicons.tcl]

plugins::load [file join plugins general]
plugins::load [file join plugins $tcl_platform(platform)]
plugins::load_dir ~/.tkabber/plugins

hook::run postload_hook

load_source iface.tcl

#cmdtrace 22

hook::run finload_hook

if {$usetabbar && ($tcl_platform(platform) == "windows")} {
    set state [option get . mainwindowstate Tkabber]
    if {$state == "zoomed"} {
	wm state . zoomed
    }
}
wm deiconify .

if {(![info exist autologin]) || ($autologin == 0)} {
    show_login_dialog
} elseif {$autologin > 0} {
    logout
    update
    login
}
