/****************************************************************************
    Copyright (C) 1987-2005 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#include <stdio.h>
#include <string.h>
#include "config.h"

char *strend(char *s)
{
    return s + strlen(s);
}

/*
    return the cpu type.
*/
char *GetSysType()
{
  static char *sys_name = 0;

  if (!sys_name) {
    char buf[1024];
    FILE *p;

    if ((p = popen("uname","r"))) {
      char *x;
      fgets(buf,1024,p);
      pclose(p);
      if ((x = strrchr(buf,'\n'))) *x = 0;
    } else
      strcpy(buf,"unknown");
    sys_name = strdup(buf);
  }

  return sys_name;
}

char *skipfield(char *s)
{
    while (*s == ' ' || *s == '\t' || *s == '\n') s++;
    while (*s && *s != ' ' && *s != '\t' && *s != '\n') s++;

    return s;
}

char *quoteChars(char *buf,char *str,char *qlist)
{
  char *p = buf;

  for (;*str;str++) {
    if (strchr(qlist,*str))
      *p++ = '\\';
    *p++ = *str;
  }
  *p = 0;

  return buf;
}
