/****************************************************************************
    Copyright (C) 1987-2004 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#ifndef __config_h
#define __config_h

/*
  The TkGate Version number
 */
#define TKGATE_VERSION		"1.8.7"
 
/*
  The language support option for TkGate.  Possible values are:

  "auto"        Set configuration based on LANG environment variable.
  "en"		Basic Western-Language support.
  "ujp"		Unicode-based Japanese.
  "jp"		Obsolete tk8.0jp based support.

  Note: editing of circuit comments in other than Japanese or English
  may not work correctly with "ujp".
 */
#define TKGATE_LANG			"auto"

/*
  Tcl/Tk Version numbers to use.
*/
#define TKGATE_TCLTK_VERSIONS		"8.4 8.3 8.2 8.1 8.0"

/*
  Japanese Tcl/Tk Version numbers to use.
*/
#define TKGATE_JP_TCLTK_VERSIONS	"8.0jp"

/*
  List of directories in which include files might be.  New directories
  should be added to the beginning of this list.  The list must be in 
  double quotes and should be all one one line.  This list is used to
  find X11, tcl and tk.
*/
#define TKGATE_INCDIRS		"/usr/X11R6/include /usr/X11/include /pkgs/include /usr/local/include /usr/openwin/include /usr/X/include /usr/include /sw/include"

/*
  List of directories to search for tcl library.  The list must be in 
  double quotes and should be all one one line.
*/
#define TKGATE_LIBDIRS		"/usr/X11R6/lib /usr/X11/lib /pkgs/lib /usr/local/lib /usr/lib /sw/lib"

/*
  Required libraries.  TkGate will not compile unless these libraries are found.
*/
#define TKGATE_REQLIBNAMES	"X11"

/*
  Additional libraries we might need in some Unix implementations.  The 'JP'
  variable is for the list for use with old-style 8.0jp Japanese support.
*/
#define TKGATE_OPTLIBNAMES	"dl socket nsl m"
#define TKGATE_JPOPTLIBNAMES	"xpg4 dl socket nsl m"


/*
  The default base name for the tkgate home directory.  The actual
  primary home directory is formed by appending "tkgate-" plus the
  version number to this path.  You can override the default by
  uncommenting the defintion of TKGATE_HOMEDIR below.
 */
#define TKGATE_HOMEDIRBASE	"/usr/X11R6/lib"

/*
  The location of the tkgate and gmac executables.  If you change this, you will
  need to run the configure script again.
 */
#define TKGATE_BINDIR		/usr/X11R6/bin

/*
  The location of the tkgate and gmac man pages.  If you change this, you will
  need to run the configure script again.
 */
#define TKGATE_MANDIR		/usr/X11R6/man/man1

/*
  Digital circuit editor and simulator.
 */
#define TKGATE_DESCRIPTION	"Digital Circuit Editor and Simulator"

/*
  URL for local documentation
 */
#define TKGATE_LOCALDOC		"file:/usr/X11R6/lib/tkgate-" TKGATE_VERSION "/doc/index.html"

/*
  The TkGate Copyright message.
 */
#define TKGATE_COPYRIGHT	"Copyright (C) 1987-2007 by Jeffery P. Hansen"

/*
  E-Mail contact for author
 */
#define TKGATE_MAILCONTACT	"hansen@tkgate.org"

/*
  URL for the TkGate homepage
 */
#define TKGATE_HOMEPAGE		"http://www.tkgate.org"

/*
  compile flags to use for gcc.  If you change this, you will
  need to run the configure script again.
 */
#define TKGATE_GCCFLAGS		-O

/*
  compile flags to use for cc.  If you change this, you will
  need to run the configure script again.
 */
#define TKGATE_CCFLAGS		

/*
  Set this to '1' if you get an error about Tk_ConfigureWidget
  when running tkgate.
 */
#define TKGATE_BROKENCONFIGWIDGET	0

/*
  Maximum number of delay parameters for a gate
 */
#define MAXDELAYS		16

/*
  Bus width symbol adjustment.  These values are used to tweek the position
  of the bus width "slash" on vertical and horizontal busses due to variations
  in X implementations.
 */
#define TKGATE_BUSW_VERT 0	/* x tweek for vertical busses */
#define TKGATE_BUSW_HORZ 0	/* y tweek for vertical busses */

/*
  Wire tweeks.  These tweeks are used to adjust the length of wire endpoints
  to compensate for variations in X implementations.
 */
#define TKGATE_WIRETWEEK_RIGHT		1
#define TKGATE_WIRETWEEK_LEFT		0
#define TKGATE_WIRETWEEK_TOP		0
#define TKGATE_WIRETWEEK_BOTTOM		1

/*
 * Set this to 32 or 64 depending on whether you have a 32-bit or 64-bit machine.
 */
#define TKGATE_ARCHITECTURE		32

/*
 * Set this to one if you want tkgate to generate code to select a printer tray
 * with a specific paper size.  This feature seems to cause problems in 'gv'
 * for some paper sizes and on some printers (e.g., A4) and so this feature
 * is now disabled by default.
 */
#define TKGATE_PSPAGESIZING		0


/******************* override parameters **************************/
/* Paremeters in this section can be uncommented to override values
 * found by the configure script.
 */

/*
 * Set this to this to the your compiler command.
 *
 * #define TKGATE_CC		gcc
 */

/*
 * Set this to non-zero if getopt() uses the optreset variable on
 * your system.
 *
 * #define OPTRESET		1
 */

/*
 * Set this to non-zero if the 64-bit "long long" type is supported
 * on your machine.
 *
 * #define USELONGLONG		1
 */

/*
 * Set this to the list of library directories to search
 *
 * #define TKGATE_LPATH		-L/usr/local/lib -L/usr/X11R6/lib -L/usr/lib
 */

/*
 * Set this to the list of include file directories to search
 *
 * #define TKGATE_IPATH		-I/usr/local/include/tk8.0 -I/usr/local/include/tcl8.0 -I/usr/X11R6/include
 */

/*
 * Set this to the list of libraries to link with
 *
 * #define TKGATE_LIBS		-ltk80 -ltcl80 -lX11 -lm
 */


/*
 *  The location of files tkgate needs to run including bitmaps, tcl
 *  script files, and the simulator executable.  This directory
 *  name must be in quotes.  If you change this, you will need to run
 *  the configure script again.
 *
 * #define TKGATE_HOMEDIR	"/usr/home/tkgate"
 */

/*
 * Set this to a backup directory to search for the tkgate home directory.
 * Normally this is the directory in which you compile tkgate.
 *
 * #define TKGATE_SECONDARYHOME	"/usr/home/sanjiyan"
 */

/*
 * Set this to non-zero if signal() handlers need to be reinstalled
 * afer each invocation.
 *
 * #define TKGATE_RESIGNAL		0
 */

/*
 * Set this non-zero if you need to use sigset() instead of signal()
 *
 * #define TKGATE_SIGSET		0
 */

/*
 * Set this to the command for yacc (or bison)
 *
 * #define TKGATE_YACC		bison -y
 */

/*
 * Set this to the command for lex (or flex)
 *
 * #define TKGATE_LEX		flex -l
 */

/*
 * Set this to non-zero if yyrestart() is used.
 *
 * #define TKGATE_NOYYRESTART	0
 *
 */

/*
 * Set this to non-zero to compile with Japanese support.  You must also compile
 * and link with the Japanese version of tcl/tk to use this feature.
 *
 * #define TKGATE_JSUPPORT		0
 */

/*
 * Set this to non-zero to compile with unicode-based Japanese support.  This should
 * only be used when running tkgate with a unicode-based version of tcl/tk.
 *
 * #define TKGATE_UNICODE_JSUPPORT	0
 */

/*
 * Set this to non-zero to use the iconv() package for converting between euc-jp and
 * unicode.  This is primarily used for Japanese support.
 *
 * #define USE_ICONV	0
 */

/*
 * If the tcl script files are in a non-standard location on yout machine, you
 * may need to uncomment this define and set it to the correct location.
 * Alternatively, you can use the environment variable TCL_LIBRARY to set the
 * location.  WARNING:  If you compile with this option and the tcl library is
 * moved back to the standard location, tkgate will be unable to find it without
 * setting the TCL_LIBRARY envornment variable.
 *
 * #define TCL_LIBRARY		"/usr/local/lib/tcl8.0"
 */

/*
 * If the tk script files are in a non-standard location on yout machine, you
 * may need to uncomment this define and set it to the correct location.
 * Alternatively, you can use the environment variable TK_LIBRARY to set the
 * location.  WARNING:  If you compile with this option and the tk library is
 * moved back to the standard location, tkgate will be unable to find it without
 * setting the TK_LIBRARY envornment variable.
 *
 * #define TK_LIBRARY		"/usr/local/lib/tk8.0"
 */

/*****************************************************************************/
/******************* end of configurable parameters **************************/
/*****************************************************************************/

/*** BEGIN-AUTO - automatically generated section - do not edit ***/
#ifndef TKGATE_CC
#define TKGATE_CC		gcc
#endif
#ifndef OPTRESET
#define OPTRESET		1
#endif
#ifndef USELONGLONG
#define USELONGLONG		1
#endif

#ifndef TKGATE_LPATH
#define TKGATE_LPATH		 -L/usr/local/lib -L/usr/X11R6/lib -L/usr/lib
#endif
#ifndef TKGATE_IPATH
#define TKGATE_IPATH		 -I/usr/local/include/tk8.4 -I/usr/local/include/tcl8.4 -I/usr/X11R6/include
#endif
#ifndef TKGATE_LIBS
#define TKGATE_LIBS		 -ltk84 -ltcl84 -lX11 -lm
#endif

#ifndef TKGATE_HOMEDIR
#define TKGATE_HOMEDIR		"/usr/X11R6/lib/tkgate-1.8.7"
#endif

#ifndef TKGATE_SECONDARYHOME
#define TKGATE_SECONDARYHOME	"/usr/home/hansen/tkgate/tkgate-1.8.7"
#endif

#ifndef TKGATE_RESIGNAL
#define TKGATE_RESIGNAL		0
#endif
#ifndef TKGATE_SIGSET
#define TKGATE_SIGSET		0
#endif

#ifndef TKGATE_YACC
#define TKGATE_YACC		yacc
#endif
#ifndef TKGATE_LEX
#define TKGATE_LEX		flex -l
#endif
#ifndef TKGATE_NOYYRESTART
#define TKGATE_NOYYRESTART	0
#endif

#ifndef TKGATE_JSUPPORT
#define TKGATE_JSUPPORT		0
#endif

#ifndef USE_ICONV
#define USE_ICONV		0
#endif

#ifndef TKGATE_UNICODE_JSUPPORT
#define TKGATE_UNICODE_JSUPPORT		0
#endif

#define TKGATE_GDF		gdf/default.gdf
#define TKGATE_BITMAPS		bitmaps/Makefile bitmaps/Udemuxord1.gif bitmaps/Udemuxord2.gif bitmaps/Udemuxsel1.gif bitmaps/Udemuxsel2.gif bitmaps/Uff.gif bitmaps/Uled_bar.gif bitmaps/Uled_bit.gif bitmaps/Uled_dec.gif bitmaps/Uled_direct.gif bitmaps/Uled_hex.gif bitmaps/Umuxord1.gif bitmaps/Umuxord2.gif bitmaps/Umuxsel1.gif bitmaps/Umuxsel2.gif bitmaps/Urff.gif bitmaps/add.b bitmaps/anallogo.xbm bitmaps/analyze.gif bitmaps/analyze.xpm bitmaps/and.b bitmaps/arshift.b bitmaps/back.gif bitmaps/back.xpm bitmaps/bat.b bitmaps/bigcurs.b bitmaps/biggatelogo.gif bitmaps/biggatelogo.xbm bitmaps/blk_close.gif bitmaps/blk_close.xpm bitmaps/blk_open.gif bitmaps/blk_open.xpm bitmaps/buf.b bitmaps/bus.b bitmaps/clock.b bitmaps/concat.b bitmaps/cut_curs.b bitmaps/dash.b bitmaps/del_curs.b bitmaps/demuxord1.gif bitmaps/demuxord2.gif bitmaps/demuxsel1.gif bitmaps/demuxsel2.gif bitmaps/dip.b bitmaps/divide.b bitmaps/dot.b bitmaps/edit_brotate.gif bitmaps/edit_brotate.xpm bitmaps/edit_rotate.gif bitmaps/edit_rotate.xpm bitmaps/ff.gif bitmaps/ff.xpm bitmaps/file_new.gif bitmaps/file_new.xpm bitmaps/file_open.gif bitmaps/file_open.xpm bitmaps/file_print.gif bitmaps/file_print.xpm bitmaps/file_save.gif bitmaps/file_save.xpm bitmaps/flipflop.b bitmaps/forward.gif bitmaps/forward.xpm bitmaps/gatelogo.xbm bitmaps/ground.b bitmaps/ichip.gif bitmaps/ichipdir.gif bitmaps/inout.b bitmaps/inv_curs.b bitmaps/iodarrow.b bitmaps/joint.b bitmaps/lab_curs.b bitmaps/large-trek.b bitmaps/led.b bitmaps/led7seg.b bitmaps/led_bar.gif bitmaps/led_bit.gif bitmaps/led_dec.gif bitmaps/led_direct.gif bitmaps/led_hex.gif bitmaps/ledinside.b bitmaps/ledseg1.b bitmaps/ledseg2.b bitmaps/ledseg3.b bitmaps/ledseg4.b bitmaps/ledseg5.b bitmaps/ledseg6.b bitmaps/ledseg7.b bitmaps/lprobe.b bitmaps/misc.b bitmaps/module.gif bitmaps/mov_curs.b bitmaps/mult.b bitmaps/mux.b bitmaps/muxord1.gif bitmaps/muxord2.gif bitmaps/muxsel1.gif bitmaps/muxsel2.gif bitmaps/nmos.b bitmaps/oldzoom_in.gif bitmaps/or.b bitmaps/plus.b bitmaps/pmos.b bitmaps/probe.b bitmaps/ram.b bitmaps/reg.b bitmaps/regLR.b bitmaps/regTB.b bitmaps/rff.gif bitmaps/rff.xpm bitmaps/rflipflop.b bitmaps/roll.b bitmaps/rom.b bitmaps/rotation0_S.gif bitmaps/rotation0_S.xpm bitmaps/rotation180_S.gif bitmaps/rotation180_S.xpm bitmaps/rotation270_S.gif bitmaps/rotation270_S.xpm bitmaps/rotation90_S.gif bitmaps/rotation90_S.xpm bitmaps/rungate1.xbm bitmaps/rungate10.xbm bitmaps/rungate11.xbm bitmaps/rungate12.xbm bitmaps/rungate13.xbm bitmaps/rungate14.xbm bitmaps/rungate2.xbm bitmaps/rungate3.xbm bitmaps/rungate4.xbm bitmaps/rungate5.xbm bitmaps/rungate6.xbm bitmaps/rungate7.xbm bitmaps/rungate8.xbm bitmaps/rungate9.xbm bitmaps/rungateA.xbm bitmaps/rungateB.xbm bitmaps/rungateC.xbm bitmaps/scroll.b bitmaps/seg7.b bitmaps/shift.b bitmaps/show_xhair.gif bitmaps/show_xhair.xpm bitmaps/sim_break.gif bitmaps/sim_break.xpm bitmaps/sim_break2.b bitmaps/sim_clock.gif bitmaps/sim_clock.xpm bitmaps/sim_dump.gif bitmaps/sim_dump.xpm bitmaps/sim_go.b bitmaps/sim_go.gif bitmaps/sim_load.gif bitmaps/sim_load.xpm bitmaps/sim_pause.b bitmaps/sim_pause.gif bitmaps/sim_script.gif bitmaps/sim_script.xpm bitmaps/sim_step.b bitmaps/sim_step.gif bitmaps/sim_stop.b bitmaps/sim_stop.gif bitmaps/simstart.gif bitmaps/simstart.xpm bitmaps/size_curs.b bitmaps/smallcurs.b bitmaps/smalldot.b bitmaps/smalllogo.xbm bitmaps/strek.b bitmaps/switch.b bitmaps/tap.b bitmaps/trek.b bitmaps/tty.b bitmaps/txtcurs.b bitmaps/vdd.b bitmaps/xor.b bitmaps/zoom_in.gif bitmaps/zoom_in.xpm bitmaps/zoom_out.gif bitmaps/zoom_out.xpm
#define TKGATE_SCRIPTS		scripts/action.tcl scripts/bitedit.tcl scripts/blocklist.tcl scripts/circuit.tcl scripts/commands.tcl scripts/cpath.tcl scripts/dip.tcl scripts/dragger.tcl scripts/dropbox.tcl scripts/editgate.tcl scripts/editnets.tcl scripts/elistbox.tcl scripts/errbox.tcl scripts/frame.tcl scripts/gcanvas.tcl scripts/helpon.tcl scripts/license.tcl scripts/menu.tcl scripts/message.tcl scripts/misc.tcl scripts/nameframe.tcl scripts/options.tcl scripts/parms.tcl scripts/portlist.tcl scripts/print.tcl scripts/scope.tcl scripts/shortcuts.tcl scripts/simtty.tcl scripts/simulator.tcl scripts/status.tcl scripts/tkgate.tcl scripts/toolbar.tcl scripts/tree.tcl
#define TKGATE_DOCS		doc/gateEdit.html doc/gateGmac.html doc/gateIntro.html doc/gateSim.html doc/index.html doc/adding_gate_types.txt doc/license.txt doc/symbols.txt doc/menagerie.gm
#define TKGATE_DOCFIGS		doc/fig/anallogo.gif doc/fig/analopts.gif doc/fig/analyze.gif doc/fig/arrow.gif doc/fig/arrow4.gif doc/fig/back.gif doc/fig/balloon.gif doc/fig/biggatelogo.gif doc/fig/blk_close.gif doc/fig/blk_open.gif doc/fig/break.gif doc/fig/chdir.gif doc/fig/circprop.gif doc/fig/coloropts.gif doc/fig/connect1a.gif doc/fig/connect1b.gif doc/fig/connect1c.gif doc/fig/connect1d.gif doc/fig/connect2a.gif doc/fig/connect2b.gif doc/fig/connect2c.gif doc/fig/connect2d.gif doc/fig/cpathcirc.gif doc/fig/cpathdlg.gif doc/fig/create1.gif doc/fig/create2.gif doc/fig/create3.gif doc/fig/create4.gif doc/fig/cretin.gif doc/fig/cretinout.gif doc/fig/cretout.gif doc/fig/cut_curs.gif doc/fig/cutters.gif doc/fig/del_curs.gif doc/fig/dipval.gif doc/fig/edbreak.gif doc/fig/edclock.gif doc/fig/edcomment.gif doc/fig/eddelay.gif doc/fig/edgat.gif doc/fig/ednet.gif doc/fig/edpnet.gif doc/fig/edport.gif doc/fig/file_new.gif doc/fig/file_open.gif doc/fig/file_print.gif doc/fig/file_save.gif doc/fig/filemenu.gif doc/fig/fileopen.gif doc/fig/forward.gif doc/fig/g_add.gif doc/fig/g_and.gif doc/fig/g_arshift.gif doc/fig/g_block.gif doc/fig/g_buf.gif doc/fig/g_bufif.gif doc/fig/g_clock.gif doc/fig/g_comment.gif doc/fig/g_demux.gif doc/fig/g_dip.gif doc/fig/g_div.gif doc/fig/g_ff.gif doc/fig/g_frame.gif doc/fig/g_ground.gif doc/fig/g_led.gif doc/fig/g_lshift.gif doc/fig/g_merge.gif doc/fig/g_mul.gif doc/fig/g_mux.gif doc/fig/g_nmos.gif doc/fig/g_or.gif doc/fig/g_pmos.gif doc/fig/g_ram.gif doc/fig/g_red.gif doc/fig/g_reg.gif doc/fig/g_roll.gif doc/fig/g_rom.gif doc/fig/g_rshift.gif doc/fig/g_supply.gif doc/fig/g_switch.gif doc/fig/g_tap.gif doc/fig/g_tty.gif doc/fig/g_xor.gif doc/fig/gatelogo.gif doc/fig/gateport.gif doc/fig/gatewin.gif doc/fig/gatewin_11.gif doc/fig/gatwin.gif doc/fig/genopts.gif doc/fig/icextract.gif doc/fig/inout.gif doc/fig/inv_curs.gif doc/fig/invaddel.gif doc/fig/label.gif doc/fig/logic.gif doc/fig/logic0.gif doc/fig/logic1.gif doc/fig/logicH.gif doc/fig/logicL.gif doc/fig/logicx.gif doc/fig/logicz.gif doc/fig/makeand.gif doc/fig/manual.gif doc/fig/modcreate.gif doc/fig/mov_curs.gif doc/fig/movgat1.gif doc/fig/movgat2.gif doc/fig/movgrp1.gif doc/fig/movgrp2.gif doc/fig/movgrp3.gif doc/fig/movgrp4.gif doc/fig/nihongo.gif doc/fig/options.gif doc/fig/popcreate.gif doc/fig/powerbsd.gif doc/fig/printdlg.gif doc/fig/printopts.gif doc/fig/ptr.gif doc/fig/rungate1.gif doc/fig/rungate2.gif doc/fig/scope.gif doc/fig/search.gif doc/fig/showval.gif doc/fig/sim_break.gif doc/fig/sim_clock.gif doc/fig/sim_dump.gif doc/fig/sim_go.gif doc/fig/sim_load.gif doc/fig/sim_pause.gif doc/fig/sim_script.gif doc/fig/sim_step.gif doc/fig/sim_stop.gif doc/fig/simerr.gif doc/fig/simopts.gif doc/fig/simprint.gif doc/fig/simstart.gif doc/fig/size_curs.gif doc/fig/small_tkgate.gif doc/fig/smallgatwin.gif doc/fig/smallgenopts.gif doc/fig/solder.gif doc/fig/text.gif doc/fig/tkgate.gif doc/fig/wsize.gif doc/fig/xmark.gif doc/fig/zoom_in.gif doc/fig/zoom_out.gif
/*** END-AUTO - end of automatically generated section ***/

#define PassCDebugFlags

/*
#if TKGATE_CC == gcc
#define PassCDebugFlags
#else
#define PassCDebugFlags		TKGATE_CCFLAGS
#endif
*/

#define STR(X) #X


#ifdef IMAKE_TEMPLATE
/* Imakefile-only configure options */

#ifndef RemoveFile
#define RemoveFile(file) $(RM) file
#endif /* RemoveFile */

#ifndef RemoveFiles
#define RemoveFiles(files) $(RM) files
#endif /* RemoveFiles */

#ifndef LinkRule
#define LinkRule(program,options,objects,libraries) \
$(CCLINK) -o program options objects libraries $(EXTRA_LOAD_FLAGS)
#endif /* LinkRule */

#ifndef ProgramTargetName
#define ProgramTargetName(target) target
#endif

#ifndef ProgramTargetHelperNoMan
#define ProgramTargetHelperNoMan(program,srcs,objs,deplib,locallib,syslib) @@\
ProgramTargetName(program): $(objs) $(deplib)				@@\
	RemoveTargetProgram($@)						@@\
	LinkRule($@,$(LDOPTIONS),$(objs),locallib $(LDLIBS) syslib)	@@\
									@@\
									@@\
InstallProgram(program,$(BINDIR))
#endif


#ifndef ComplexProgramTargetNoMan
#define ComplexProgramTargetNoMan(program)				@@\
        PROGRAM = program						@@\
									@@\
AllTarget(program)							@@\
									@@\
ProgramTargetHelperNoMan(program,SRCS,OBJS,DEPLIBS,$(LOCAL_LIBRARIES),NullParameter) @@\
									@@\
DependTarget()								@@\
LintTarget()								@@\
									@@\
clean::									@@\
	RemoveFile(ProgramTargetName(program))
#endif

#ifndef LexFileExplicit
#if HasClearmake		/* provide a place to hang ClearmakeOSName */
#define LexFileExplicit(file)						@@\
file.c: file.l								@@\
	ClearmakeOSName \
	$(LEX) $(LFLAGS) file.l						@@\
	$(MV) lex.yy.c file.c
#else
#define LexFileExplicit(file) /* the default rule is fine */
#endif
#endif

#ifndef LexFile
#define LexFile(file)							@@\
LexFileExplicit(file)							@@\
									@@\
depend:: file.c								@@\
									@@\
clean::									@@\
	RemoveFiles(lex.yy.c file.c)
#endif /* LexFile */

#ifndef YaccFile
#if HasGnuMake
#define YaccFile(file,flags)						@@\
depend:: file.c								@@\
									@@\
file.h: file.c								@@\
									@@\
file.c: file.y								@@\
	$(YACC) flags file.y						@@\
	$(MV) y.tab.c file.c						@@\
	@if [ -f y.tab.h ]; then set -x; $(MV) y.tab.h file.h; \	@@\
	else exit 0; fi							@@\
									@@\
clean::									@@\
	RemoveFiles(y.tab.c y.tab.h file.h file.c)
#else
#define YaccFile(file,flags)						@@\
depend:: file.c								@@\
									@@\
file.h file.c: file.y							@@\
	$(YACC) flags file.y						@@\
	$(MV) y.tab.c file.c						@@\
	@if [ -f y.tab.h ]; then set -x; $(MV) y.tab.h file.h; \	@@\
	else exit 0; fi							@@\
									@@\
clean::									@@\
	RemoveFiles(y.tab.c y.tab.h file.h file.c)
#endif
#endif /* YaccFile */

YACC=TKGATE_YACC
LEX=TKGATE_LEX

BINDIR=TKGATE_BINDIR
MANDIR=TKGATE_MANDIR

CC=TKGATE_CC

#if TKGATE_CC == gcc
CCOPTIONS=
CDEBUGFLAGS=			TKGATE_GCCFLAGS
#else
CCOPTIONS=
CDEBUGFLAGS=			TKGATE_CCFLAGS
#endif


HOMEDIR=			TKGATE_HOMEDIR

#else
/* C-only configure options */

#if TKGATE_NOYYRESTART
#define yyrestart(f) { extern FILE *yyin; yyin = f; }
#endif

#if TKGATE_SIGSET
#define signal(a,b)	sigset(a,b)
#endif

/* end of C-only configure options */
#endif

#endif
