namespace eval about {
    variable about

    # Define the options database.
    option add *About.borderwidth 1
    option add *About.relief flat

    # Define the about data structure
    set about(dialog) ""
    switch $tkWorld(ostype) {
	windows {
	    set about(font.title) {helvetica 12 bold}
	    set about(font.message) {helvetica 10}
	    set about(font.info) {helvetica 10 italic}
	    set about(font.contact) {helvetica 10}
	}
	default {
	    set about(font.title) {helvetica 14 bold}
	    set about(font.message) {helvetica 12}
	    set about(font.info) {helvetica 12 italic}
	    set about(font.contact) {helvetica 12}
	}
    }
}

# about::create --
#
#   Method to create an About information dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc about::create { } {
    global tkWorld
    variable about

    set w [toplevel .about -class About]

    # Determine where to place the message popup. Notice the use
    # of .about instead of $w due to the callback in the global space.
    after idle {
	update idletasks

	set xmax [winfo screenwidth .about]
	set ymax [winfo screenheight .about]
	
	set x0 [expr ($xmax - [winfo reqwidth .about])/2]
	set y0 [expr ($ymax - [winfo reqheight .about])/2]

	wm geometry .about "+$x0+$y0"
    }

    # Create the elements of the placard.
    set img [image create photo \
	    -file [file join $tkWorld(image_dir) tkWorld.gif]]

    label $w.icon \
	    -image $img
    label $w.title \
	    -text "tkWorld-$tkWorld(version)" \
	    -foreground red \
	    -font $about(font.title)
    label $w.message \
	    -text "A graphical user interface to\n \
	    shell commands, tasks, and programming" \
	    -font $about(font.message)
    label $w.info \
	    -text "$tkWorld(copyright)" \
	    -font $about(font.info)
    label $w.contact \
	    -text "$tkWorld(email)\n$tkWorld(www)" \
	    -foreground blue \
	    -font $about(font.contact)
    button $w.ok \
	    -text Ok \
	    -width 5 \
	    -command [list destroy $w]

    # Build the placard with the tkWorld icon.
    grid $w.icon \
	    -row 0 \
	    -column 0 \
	    -rowspan 5 \
	    -padx 5 \
	    -pady 5 \
	    -sticky n
    grid $w.title \
	    -row 0 \
	    -column 1 \
	    -padx 10 \
	    -sticky new
    grid $w.message \
	    -row 1 \
	    -column 1 \
	    -padx 5 \
	    -pady 2 \
	    -sticky ew
    grid $w.info \
	    -row 2 \
	    -column 1 \
	    -padx 5 \
	    -pady 2 \
	    -sticky ew
    grid $w.contact \
	    -row 3 \
	    -column 1 \
	    -padx 5 \
	    -pady 2 \
	    -sticky ew
    grid [seperator::create $w.s1] \
	    -row 4 \
	    -column 0 \
	    -columnspan 2 \
	    -pady 5 \
	    -sticky ew
    grid $w.ok \
	    -row 5 \
	    -column 0 \
	    -columnspan 2 \
	    -padx 5 \
	    -pady 5

    update idletasks

    # Configure the window manager for unix.
    switch $tkWorld(ostype) {
	unix {
	    wm title .about "About tkWorld"
	}
    }
}
    