# arch-tag: tla buildpackage version parsing support
# Copyright (C) 2003 John Goerzen
#               2008 Hubert Chathi
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

import re
import extcmd
import apt_pkg
apt_pkg.init_system()

tbp_version = '0.9.12+hc2'

def print_tbp_version(progname):
    if progname != 'tla-buildpackage':
        progname = progname + ' (tla-buildpackage)'
    print """%s %s
Copyright (C) 2003 John Goerzen
              2008 Hubert Chathi
tla-buildpackage comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it under the terms
of the GNU General Public License version 2 or later.""" % (progname, tbp_version)

def splitver(version):
    """Takes a full version number version and returns a tuple consisting
    of (epoch, upstream, debian) versions.  If no Debian version is present,
    the 1st and 3rd elements of the tuple are None. If there is no epoch
    version, the 1st element will be None."""
    try:
        epoch, epochless = version.split(':')
    except ValueError:
        epoch, epochless = None, version
    try:
        upstream, debian = epochless.split('-')
    except ValueError:
        upstream, debian = epochless, None
    return epoch, upstream, debian

def getepochver(version):
    return splitver(version)[0]

def getupstreamver(version):
    return splitver(version)[1]

def getdebianver(version):
    return splitver(version)[2]

def getverfromchangelog():
    return extcmd.extractline('dpkg-parsechangelog', 'Version')

def getpackagefromchangelog():
    return extcmd.extractline('dpkg-parsechangelog', 'Source')

def vercmp(v1, v2):
    return apt_pkg.version_compare(v1, v2)
