/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/param.h>
#include <gtk/gtk.h>
#include <signal.h>
#include <gdk/gdk.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/extensions/scrnsaver.h>
#include <gdk/gdkx.h>
static Display *display = NULL;

#include "xmms-info.h"

void autoaway_check();
gboolean autoaway_callback(gpointer data);
gboolean autoaway_init();
gint autoaway_query_ss_idle_time(Display *d);
/*
 * Used by most functions
 */
struct
{
  GTimer *timer;
  guint timeout_id;
} optAutoAway;

#include "interface.h"
#include "support.h"
#include "windows.h"
#include "conffile.h"
#include "messages.h"
#include "lista.h"
#include "users.h"
#include "groups.h"
#ifndef DISABLE_DOCKLET
#include "docklet.h"
#endif
#include "utils.h"
#include "jabby.h"


GtkWidget *window1;
GtkWidget *window_login;
GtkWidget *window_profiles;
GtkWidget *window_profile;
GtkWidget *window_search;
GtkWidget *window_message;
GtkWidget *default_chat_window;
GtkWidget *window_archive;
GtkWidget *window_prefs;
GtkWidget *window_card;
GtkWidget *window_pic;
GtkWidget *window_contacts;
GtkWidget *window_desc;
GtkWidget *fileselection;
GtkWidget *colorselection;
GtkWidget *treeview1, *notebook1, *scroll1;
#ifndef DISABLE_DOCKLET
GtkWidget *status_docklet = NULL;
#endif
GtkWidget *window_gg;
GtkWidget *window_sms;

struct tlen_session *session;//sesja tlenu
gchar *pname;//nazwa profilu
gchar *desc;//opis
gchar *desc_time;//opis czasu
gchar *desc_xmms;//opis z xmms
struct profile *profile;
gint status;
gint posx,posy, width, height;
gint away_min, away_sec, ext_away_min, ext_away_sec;
gint desc_num;
gchar *datefg, *nickfg, *textfg, *textbg;
//gchar *jabberjid, *jabberpassword;
//gchar *login, *password;//tlen
gchar *sounds[MAX_SOUNDS], *playpath, *smspath;
GtkWidget *icons[MAX_ICONS];
GtkWidget *j_icons[J_MAX_ICONS];//ikonki jabbera
GtkWidget *wp_icons[J_MAX_ICONS];//ikonki wpkontakt
GtkWidget *gg_icons[J_MAX_ICONS];//ikonki gg
GList *users_list;
GList *groups_list;
GList *expanders_list;
GList *pubdir_list;
GList *talks_list;//lista otwartych okienek z rozmowami
GList *profiles_list;
GList *chat_list;
GList *contacts_list;
GList *messages_list;
GList *desc_list;
gint chatbuf;
gboolean cant_stop;
gboolean online, beep;
gboolean autoaway = TRUE;

gint timerid, timerid2, timerid3;
guint32 preferences;//preferencje

gchar *job[] = {
  "",
  "ucze",
  "student",
  "rolnik",
  "meneder",
  "specjalista",
  "urzdnik",
  "bezrobotny",
  "emeryt,rencista",
  "gospodyni",
  "nauczyciel",
  "lekarz",
  "inny"
};
gchar *plans[] = {
  "", "kino"
};

gchar *opisy[7]={"Dostpny", "Wrc pniej", "Zaraz wracam",
  "Jestem zajty", "Porozmawiajmy" , "Niewidoczny", "Niedostpny"};

gchar *statusy[7]={"dostpny", "wrc pniej", "zaraz wracam",
  "jestem zajty", "porozmawiajmy" , "niewidoczny", "niedostpny"};

gchar *j_statusy[]={"Dostpny", "Porozmawiajmy", "Jestem zajty",
  "Zaraz wracam", "Wrc pniej", "Niewidoczny", "Niedostpny"};


//emoticons
gchar *emots_str[]={
  ":)",
  ":-)",
  "<cfaniak>",
  "8-)",
  "8)",
  ":-|",
  ":|",
  ";-)",
  ";)",
  "<placze>",
  ":'(",
  ":-'(",
  "<przerazony>",
  " :0",
  ":-0",
  ":-(",
  ":(",
  ":-/",
  " :/",
  ":D",
  ":-D",
  ":[",
  ":-[",
  NULL
};

gint emots_num[]={
  EMOTS_SMILE,
  EMOTS_SMILE,
  EMOTS_CFANIAK,
  EMOTS_CFANIAK,
  EMOTS_CFANIAK,
  EMOTS_OBOJETNY,
  EMOTS_OBOJETNY,
  EMOTS_OCZKO,
  EMOTS_OCZKO,
  EMOTS_PLACZ,
  EMOTS_PLACZ,
  EMOTS_PLACZ,
  EMOTS_PRZERAZONY,
  EMOTS_PRZERAZONY,
  EMOTS_PRZERAZONY,
  EMOTS_SMUTEK,
  EMOTS_SMUTEK,
  EMOTS_ZDEGUSTOWANY,
  EMOTS_ZDEGUSTOWANY,
  EMOTS_ZEBY,
  EMOTS_ZEBY,
  EMOTS_ZLOSC,
  EMOTS_ZLOSC
};


gchar *emots_files[]={
  "usmiech.png",
  "cfaniak.png",
  "obojetny.png",
  "oczko.png",
  "placz.png",
  "przerazony.png",
  "smutek.png",
  "zdegustowany.png",
  "zeby.png",
  "zlosc.png",
  NULL
};

GtkWidget *emots_pics[EMOTS_END];

void emots_create_pics()
{
  gint i;

  for (i=0; i< EMOTS_END; i++)
  {
    emots_pics[i] = create_pixmap(window1, emots_files[i]);
    gtk_widget_show(emots_pics[i]);
  }
}

void clear_lists()
{
  chat_list_flush();
  messages_list_clear();//FIXME zapisz nieprzeczytane wiadomosci do pliku
  expanders_list_clear();
  talks_list_clear();
  contacts_list_clear();
  groups_list_clear();
  users_list_clear();
  desc_list_clear();
}

void clear_pointers()
{
  gint i;

  if(desc)
  {
    g_free(desc);
    desc=NULL;
  }
  if(pname)
  {
    g_free(pname);
    pname=NULL;
  }
  g_free(datefg);
  datefg = NULL;
  g_free(nickfg);
  nickfg = NULL;
  g_free(textfg);
  textfg = NULL;
  g_free(textbg);
  textbg = NULL;
  g_free(playpath);
  playpath = NULL;
  g_free(smspath);
  smspath = NULL;
  for(i=0; i<MAX_SOUNDS; i++)
  {
    g_free(sounds[i]);
    sounds[i] = NULL;
  }
  profile = NULL;
}

static void create_icons()
{
  gint i;

  icons[0]=create_icon(0);
  icons[1]=create_icon(1);
  for(i = TLEN_STATUS_AVAILABLE; i <= TLEN_STATUS_UNAVAILABLE; i++)
  {
    icons[i]=create_icon(i);
    gtk_widget_show(icons[i]);
  }
  for (i = JABBY_PRESENCE_UNAVAILABLE; i <= JABBY_PRESENCE_INVISIBLE; i++)
  {
    j_icons[i] = j_create_icon(i);
    gtk_widget_show(j_icons[i]);
    wp_icons[i] = wp_create_icon(i);
    gtk_widget_show(wp_icons[i]);
    gg_icons[i] = gg_create_icon(i);
    gtk_widget_show(gg_icons[i]);
  }
}

int
main (int argc, char *argv[])
{

  signal(SIGCHLD, SIG_IGN);//zeby zapobiec procesom zombie
  gtk_set_locale ();
  gtk_init (&argc, &argv);
  if (!g_thread_supported ()) g_thread_init (NULL);
  else
  {
    g_print("no threads in glib\n");
    exit(1);
  }


  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
  add_pixmap_directory (g_strdup_printf("%s/.tleenx/pixmaps",getenv("HOME")));
  
  //ikonki
  create_icons();
  emots_create_pics();
  autoaway_init();
#ifndef DISABLE_DOCKLET
  create_docklet();
#endif





  if(last_login())
  {
    load_profiles();
    window1_open();
  }
  else
    my_create_window_login ();

  gtk_main ();
  return 0;
}




//autoaway code
gboolean autoaway_init()
{
  gint unused;
  Bool useXss = False;
  /*
   *  Find out whether there actually is a server on the other side...
   */
  if(!(display = XOpenDisplay(0))) /* = intended */
  {
    g_warning("autoaway_init: couldn't connect to %s", XDisplayName(0));
    return FALSE;
  }
  if(!(useXss = XScreenSaverQueryExtension(display, &unused, &unused)))
    {
      g_warning("autoaway_init: could not initialise XScreenSaver");
      return FALSE;
    }
  g_message("autoaway_init: using XSS for autoaway time");
  /* set recursive function */
  optAutoAway.timeout_id = g_timeout_add(1000,
                                         autoaway_callback,
                                         NULL);
  return TRUE;
}

gboolean autoaway_term()
{
  return TRUE;
}

void autoaway_check()
{
  gint time = 0; /* in ms */

  /* find out current idle time */
  docklet_show();
  if(!session || (!online))
    return;
  if(!autoaway)
    return;
  if(!(preferences & PREF_AUTOAWAY))
    return;
  time = (gint) (autoaway_query_ss_idle_time(display)/1000.0);
//  g_print("away time %d\n", time);
  if(time > (away_min*60+away_sec))
  {
    if(status == TLEN_STATUS_AVAILABLE)
    {
      g_free(desc_time);
      desc_time = get_localtime(NULL);
      status = TLEN_STATUS_AWAY;
      set_status(TLEN_STATUS_AWAY);
    }
    if(time > (ext_away_min*60+ext_away_sec))
      if(status == TLEN_STATUS_AWAY)
      {
        g_free(desc_time);
        desc_time = get_localtime(NULL);
        status = TLEN_STATUS_EXT_AWAY;
        set_status(TLEN_STATUS_EXT_AWAY);
      }
  }
  else
    if((status == TLEN_STATUS_AWAY) ||(status == TLEN_STATUS_EXT_AWAY))
    {
      g_free(desc_time);
      desc_time = NULL;
      status = TLEN_STATUS_AVAILABLE;
      set_status(TLEN_STATUS_AVAILABLE);
    }
}

gint autoaway_query_ss_idle_time(Display *d)
{
  Time idleTime = 0; /* millisecs since last input event */
  static XScreenSaverInfo *mitInfo = 0;
  if(!mitInfo)
    mitInfo = XScreenSaverAllocInfo();

  XScreenSaverQueryInfo(d, DefaultRootWindow (d), mitInfo);
  idleTime = mitInfo->idle;
  return idleTime;
}

gboolean autoaway_callback(gpointer data)
{
  /* return FALSE to stop
     calling this function */
  /* do check */
  autoaway_check();
  return TRUE;
}
