/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/




#ifndef __USERS_H__
#define __USERS_H__
#include <gtk/gtk.h>


enum user_type{
  USER_TLEN,
  USER_JABBER,
  USER_WP,
  USER_GG,
  USER_AGENT
};

struct user
{
  gchar *name, *jid, *group, *subscription, *description, *ask;
  int status;
  enum user_type type;
};

struct talk
{
  GtkWidget *window;
  gchar *jid;
};


void add_user(gchar *name, gchar *jid, gchar *group, gchar *subscription,
              gchar *description, gchar *ask, int status, enum user_type type);
void del_user(gchar *jid);
struct user *get_user(const gchar *jid);
gchar *user_subscription(const gchar *jid);
void users_list_clear();
void talks_list_clear();
gint users_list_count(GList *l);
gint users_list_count_online(GList *l);
gchar *get_user_name(const gchar *jid);
gint get_status(struct user *u);
gint get_type(gchar *id);
gchar* user_del_res(gchar *jid);
gboolean subscription_to(struct user *u);
gboolean subscription_from(struct user *u);
gchar *user_description(struct user *user);

#endif
