/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#ifndef __CONFFILE_H__
#define __CONFFILE_H__

#include <gtk/gtk.h>
#include <time.h>

#define MAX_SNAME 40 //maksymalna dlugosc nazwy sekcji w pliku konf
#define MAX_CHATBUF 10000 //maksymalna dlugosc kolejki (ilosc bajtow)
//wiadomosci do zapisu
#define MAX_VARNAME 30 //maksymalna dlugosc zmiennej w pliku preferencji
#define MAX_VALLEN 120 //maksymalna dlugosc zmiennej w pliku preferencji
#define MAX_LLEN (MAX_VARNAME+MAX_VALLEN+2) //maksymalna dlugosc linii w pliku konf razem ze znakiem
//konca linii
#define MAX_ARCH_LEN 400000 //maksymalna dlugosc pliku archiwum w bajtach

#define PREF_NEWMAIL (1<<0)
#define PREF_SAVESTAT (1<<1)
#define PREF_BEEPONM (1<<2)//powiadomienie gdy jest nowa wiadomosc
#define PREF_BEEPONS (1<<3)//dostepna nowa osoba
#define PREF_GROUPS_NONE (1<<4)
#define PREF_GROUPS_TABS_UP (1<<5)
#define PREF_GROUPS_TABS_LEFT (1<<6)
#define PREF_GROUPS_LIST (1<<7)
#define PREF_INFO_MENU (1<<8)// tu tak naprawde chodzi o opisy na liscie
#define PREF_BEEPONA (1<<9)//prosba o autoryzacje
#define PREF_BEEPONN (1<<10)//nowa poczta
#define PREF_BEEPONW (1<<11)//wiadomosc wyslana z bramki
#define PREF_ENTERON (1<<12)//zapamietuje wcisniety enter
#define PREF_DEBUGON (1<<13)//wypisuje komunikaty na konsole
#define PREF_LIST_EXPANDED (1<<14)//domyslnie rozwija liste kontaktow
#define PREF_HIDE_OFFLINE (1<<15)//ukrywa niedostepnych
#define PREF_JABBER_CONNECT (1<<16)//laczy z serwerem jabbera przy logowaniu
#define PREF_EMOTS (1<<17) // wlacza pokazywanie emotikon w oknie rozmowy
#define PREF_BEEPONT (1<<18)//powiadamiaj podczas rozmowy
#define PREF_LASTLOGIN (1<<19)//ustaw biezacy profil jako domyslny
#define PREF_AUTOAWAY (1<<20)//automatycznie zmieniaj status
#define PREF_XMMS_INFO (1<<21)//pobiera aktualnie grana piosenkle z xmms-info

#define MESSAGE_FROM 0
#define MESSAGE_TO 1

#define MAX_SOUNDS 6
enum{SOUNDM, SOUNDT, SOUNDS, SOUNDA, SOUNDN, SOUNDW};

struct profile
{
  gchar *pname;
  //tlen
  gchar *login;
  gchar *password;
  //jabber
  gchar *jserver;
  gchar *jlogin;
  gchar *jpassword;
  gchar *jresource;
  //gg
  gchar *ggnumber;
  gchar *ggpassword;
  gchar *ggserver;
  //jid bramki sms
  gchar *sms;
  //id do bramki sms
  gchar *smsid;
  //haslo do bramki sms
  gchar *smspassword;
};

struct chat
{
  gchar *jid;
  gint from;
  struct tm time;
  gchar *message;
};

int create_dir();
int create_file();
void profile_jabber(const gchar *pname, const gchar *jserver,
                    const gchar *jlogin,
                    const gchar *jpassword,
                    const gchar *jresource);
void profile_gg(const gchar *pname,
                const gchar *ggnumber,
                const gchar *ggpassword);
void profile_sms(const gchar *pname,
                 const gchar *id,
                 const gchar *password);
void add_profile(const gchar *pname,
                 const gchar *login, const gchar *password);
void del_profile(const gchar *pname);
void profiles_list_clear();
void load_profiles();
struct profile *get_profile(const gchar *pname);
void load_combo();
int save_message(const gchar *jid, gchar *message, gint from);
void queue_chat(const gchar *jid, gchar *message, gint from);
int chat_list_flush();
int save_preferences();
int read_preferences();
gboolean arch_too_big(const gchar *filename);
void arch_move();
gboolean last_login();

gint file_write_expanded_groups();
gint file_load_expanded_groups();


#endif
