from typing import Any

class Base:
    def as_dict(self, drop_empty: bool = ...) -> Dict[str, Any]: ...
    def as_json(self, drop_empty: bool = ...) -> str: ...
    def __init__(self) -> None: ...

class Input(Base):
    url: Optional[str] = ...
    path: Optional[str] = ...
    type: str = ...
    name: Optional[str] = ...
    description: Optional[str] = ...
    content: Any = ...
    def __init__(self, url: Optional[str], path: Optional[str], type: Optional[str], name: Optional[str], description: Optional[str], content: Any) -> None: ...

class Output(Base):
    url: Optional[str] = ...
    path: Optional[str] = ...
    type: str = ...
    name: Optional[str] = ...
    description: Optional[str] = ...
    def __init__(self, url: Optional[str], path: Optional[str], type: Optional[str], name: Optional[str], description: Optional[str]) -> None: ...

class Resources(Base):
    cpu_cores: int = ...
    ram_gb: Union[float, int, None] = ...
    disk_gb: Union[float, int, None] = ...
    preemptible: Optional[bool] = ...
    zones: Optional[List[str]] = ...
    def __init__(self, cpu_cores: int, ram_gb: Union[float, int, None], disk_gb: Union[float, int, None], preemptible: Optional[bool], zones: Optional[List[str]]) -> None: ...

class Executor(Base):
    image: str = ...
    command: str = ...
    workdir: Optional[str] = ...
    stdin: Optional[str] = ...
    stdout: Optional[str] = ...
    stderr: Optional[str] = ...
    env: Optional[Dict[str, str]] = ...
    def __init__(self, image: str, command: str, workdir: Optional[str], stdin: Optional[str], stdout: Optional[str], stderr: Optional[str], env: Optional[Dict[str, str]]) -> None: ...

class ExecutorLog(Base):
    start_time: Optional[datetime] = ...
    end_time: Optional[datetime] = ...
    stdout: Optional[str] = ...
    stderr: Optional[str] = ...
    exit_code: Optional[int] = ...
    def __init__(self, start_time: Optional[datetime], end_time: Optional[datetime], stdout: Optional[str], stderr: Optional[str], exit_code: Optional[int]) -> None: ...

class OutputFileLog(Base):
    url: Optional[str] = ...
    path: Optional[str] = ...
    size_bytes: Optional[int] = ...
    def __init__(self, url: Optional[str], path: Optional[str], size_bytes: Optional[int]) -> None: ...

class TaskLog(Base):
    start_time: Optional[datetime] = ...
    end_time: Optional[datetime] = ...
    metadata: Optional[Dict[str, Any]] = ...
    logs: Optional[List[ExecutorLog]] = ...
    outputs: Optional[List[OutputFileLog]] = ...
    system_logs: Optional[List[str]] = ...
    def __init__(self, start_time: Optional[datetime], end_time: Optional[datetime], metadata: Optional[Dict[str, Any]], logs: Optional[List[ExecutorLog]], outputs: Optional[List[OutputFileLog]], system_logs: Optional[List[str]]) -> None: ...

class Task(Base):
    id: Optional[str] = ...
    state: Optional[str] = ...
    name: Optional[str] = ...
    description: Optional[str] = ...
    inputs: Optional[List[Input]] = ...
    outputs: Optional[List[Output]] = ...
    resources: Optional[Resources] = ...
    executors: Optional[List[Executor]] = ...
    volumes: Optional[List[str]] = ...
    tags: Optional[List[str]] = ...
    logs: Optional[List[TaskLog]] = ...
    creation_time: Optional[datetime] = ...
    def is_valid(self) -> Tuple[bool, Optional[BaseException]]: ...
    def __init__(self, id: Optional[str], state: Optional[str], name: Optional[str], description: Optional[str], inputs: Optional[List[Input]], outputs: Optional[List[Output]], resources: Optional[Resources], executors: Optional[List[Executor]], volumes: Optional[List[str]], tags: Optional[List[str]], logs: Optional[List[TaskLog]], creation_time: Optional[datetime]) -> None: ...

class GetTaskRequest(Base):
    id: Optional[str] = ...
    view: Optional[str] = ...
    def __init__(self, id: Optional[str], view: Optional[str]) -> None: ...

class CreateTaskResponse(Base):
    id: Optional[str] = ...
    def __init__(self, id: Optional[str]) -> None: ...

class ServiceInfoRequest(Base):
    def __init__(self) -> None: ...

class ServiceInfo(Base):
    name: Optional[str] = ...
    doc: Optional[str] = ...
    storage: Optional[List[str]] = ...
    def __init__(self, name: Optional[str], doc: Optional[str], storage: Optional[List[str]]) -> None: ...

class CancelTaskRequest(Base):
    id: Optional[str] = ...
    def __init__(self, id: Optional[str]) -> None: ...

class CancelTaskResponse(Base):
    def __init__(self) -> None: ...

class ListTasksRequest(Base):
    project: Optional[str] = ...
    name_prefix: Optional[str] = ...
    page_size: Optional[int] = ...
    page_token: Optional[str] = ...
    view: Optional[str] = ...
    def __init__(self, project: Optional[str], name_prefix: Optional[str], page_size: Optional[int], page_token: Optional[str], view: Optional[str]) -> None: ...

class ListTasksResponse(Base):
    tasks: Optional[List[Task]] = ...
    next_page_token: Optional[str] = ...
    def __init__(self, tasks: Optional[List[Task]], next_page_token: Optional[str]) -> None: ...
