#!/usr/bin/make -f
# Derived from sample debian/rules that uses debhelper.
# GNU copyright 1997 to 1999 by Joey Hess.

TARGET :=__TARGET__
PACKAGE :=gdb-__TARGET__

DEB_BUILD_GNU_TYPE := $(shell dpkg-architecture -qDEB_BUILD_GNU_TYPE)
DEB_HOST_GNU_TYPE  := $(shell dpkg-architecture -qDEB_HOST_GNU_TYPE)

CONFARGS = \
	--host=$(DEB_HOST_GNU_TYPE) \
	--build=$(DEB_BUILD_GNU_TYPE) \
	--prefix=/usr \
	--mandir='\$${prefix}/share/man' \
	--infodir='\$${prefix}/share/info' \
	--target=$(TARGET)

# Uncomment this to turn on verbose mode.
#export DH_VERBOSE=1

# This is the debhelper compatability version to use.
export DH_COMPAT=3


unpack: unpack-stamp
unpack-stamp:
	tar xjf /usr/src/toolchain/gdb.tar.bz2
	mv gdb* src
	mkdir build
	touch unpack-stamp

include /usr/src/toolchain/patches/gdb/rules.patch
patch-stamp:
	$(MAKE) -C src -f ../debian/rules patched-stamp
	touch $@

configure: configure-stamp
configure-stamp: unpack-stamp patch-stamp
	dh_testdir
	cd build && env CC="gcc" ../src/configure $(CONFARGS)
	touch configure-stamp

build: configure-stamp build-stamp
build-stamp:
	dh_testdir
	cd build && $(MAKE)
	touch build-stamp

clean:
	dh_testdir
	dh_testroot
	rm -f build-stamp configure-stamp unpack-stamp patch-stamp
	rm -rf src build
	dh_clean

install: build
	dh_testdir
	dh_testroot
	dh_clean -k
	dh_installdirs
	# install the package into debian/tmp.
	cd build && $(MAKE) install prefix=$(CURDIR)/debian/tmp/usr

# Build architecture-independent files.
binary-indep: build install

# Build architecture-dependent files.
binary-arch: build install
	dh_testdir
	dh_testroot

	dh_movefiles
	dh_installdocs -n
	dh_installchangelogs 
	dh_link
	dh_strip
	dh_compress
	dh_fixperms
	dh_installdeb
	dh_shlibdeps

	# Update toolchain-source version reference (won't work as it's a source dependency)
	#touch debian/substvars
	#-grep -v '^toolchain-source-version=' debian/substvars > debian/substvars.tmp
	#mv debian/substvars.tmp debian/substvars
	#echo >> debian/substvars
	#echo -n 'toolchain-source-version=' >> debian/substvars
	#dpkg -s toolchain-source | grep Version: | sed -e 's/Version: //' >> debian/substvars

	dh_gencontrol
	dh_md5sums
	dh_builddeb

binary: binary-indep binary-arch
.PHONY: build clean binary-indep binary-arch binary install configure
