/***************************************************************************
                          date.h  -  description
                             -------------------
    begin                : Sun Jun 3 2001
    copyright            : (C) 2001 by Pierre-Michel THEVENY
    email                : pmth@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATE_H
#define DATE_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>


/***************************************************************************
* Some preprocessor constants
 ***************************************************************************/

/* Difference between jd origin and 17d/11m/1858y  */
#define OFFSET_JD         -2400000.5L
/* Difference between jd origin and 01d/01m/1992y */
#define  OFFSET_LOP      48622.0L
/* Difference between jd origin and 01d/01m/1950y */
#define  OFFSET_CNES   33282.0L
/* Difference between jd origin and 24d/05m/1968y */
#define  OFFSET_NASA   40000.0L
/* Difference between jd origin and 01d/01m/1958y  */
#define OFFSET_CCSDS  36204.0L


/* Beguining of the first cycle in mjd */
#define  FIRST_CYCLE_MJD      48888.1515625L	/* 23d/09m/1992y 03:38:15 */
/* Duration of a pass in seconds */
#define  PASS_DURATION_S      3372.87973L

/* Limits for date conversions */

#define MIN_JD        0.0L	/* Julian day 0 : conversion don't work with negative jd */
#define MAX_JD      4643365.5L	/* 01d/01m/8000y 00:00:00 */

#define MIN_MJD     -2400000.5L	/* Julian day 0 : conversion don't work with negative jd */
#define MAX_MJD    2243365.0L	/* 01d/01m/8000y 00:00:00 */

#define MIN_LOP_JD      -2448622.5L	/* Julian day 0 : conversion don't work with negative jd */
#define MAX_LOP_JD    2194743.0L	/* 01d/01m/8000y 00:00:00 */

#define MIN_CNES_JD     -2433282.5L	/* Julian day 0 : conversion don't work with negative jd */
#define MAX_CNES_JD   2210083.0L	/* 01d/01m/8000y 00:00:00 */

#define MIN_NASA_JD     -2440000.5L	/* Julian day 0 : conversion don't work with negative jd */
#define MAX_NASA_JD   2203365.0L	/* 01d/01m/8000y 00:00:00 */

#define MIN_CCSDS_JD    -2436204.5L	/* Julian day 0 : conversion don't work with negative jd */
#define MAX_CCSDS_JD   2207161L	/* 01d/01m/8000y 00:00:00 */

#define MAX_CYCLE 500		/* Arbitrary maximum cycle */


/***************************************************************************
* Type def declarations
 ***************************************************************************/

typedef struct G_DATE
{
    gint day;
    gint month;
    gint year;
    gint hour;
    gint min;
    gdouble sec;
}
G_DATE;


/***************************************************************************
* Get current GMT date and time
 ***************************************************************************/

G_DATE *get_current_time (void);


/***************************************************************************
* Is a gregorian year is leap ?
 ***************************************************************************/

gboolean is_leap (const gint year);


/*********************************************************************************
Conversion from Gregorian date to mofified Julian day and vice-versa are
derived from the Communications of the ACM (CACM, volume 11, number
10, October 1968, p.657) Henry F. Fliegel and Thomas C. Van Flandern
*********************************************************************************/
/***************************************************************************
* Convertion G_Date to Mjd
 ***************************************************************************/

gdouble gregorian_to_mjd (G_DATE * gDate);


/***************************************************************************
* Convertion Mjd to G_Date
 ***************************************************************************/

G_DATE mjd_to_gregorian (gdouble mjd);

#endif
