/***************************************************************************
                          msg.c  -  description
                             -------------------
    begin                : Mon Jun 4 2001
    copyright            : (C) 2001 by Pierre-Michel THEVENY
    email                : pmt@mnhn.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "msg.h"
#include "utils.h"


/***************************************************************************
* Display a dialog box with message in and Ok button
 ***************************************************************************/

void
display_msg (gchar * msg)
{
    GtkWidget *msg_dialog;
    GtkWidget *label;
    GtkWidget *hbuttonbox;
    GtkWidget *ok;

    g_return_if_fail (msg != NULL);

    msg_dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (msg_dialog), _("TP time"));
    gtk_window_set_position (GTK_WINDOW (msg_dialog), GTK_WIN_POS_CENTER);
    gtk_window_set_policy (GTK_WINDOW (msg_dialog), FALSE, FALSE, TRUE);

    label = gtk_label_new (msg);
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_FILL);
    gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
    gtk_misc_set_padding (GTK_MISC (label), 10, 10);
    gtk_container_add (GTK_CONTAINER (GTK_DIALOG (msg_dialog)->vbox), label);
    gtk_widget_show (label);

    hbuttonbox = gtk_hbutton_box_new ();
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (msg_dialog)->action_area),
                        hbuttonbox, TRUE, TRUE, 0);
    gtk_widget_show (hbuttonbox);

    ok = gtk_button_new_with_label (_("Ok"));
    gtk_container_add (GTK_CONTAINER (hbuttonbox), ok);
    GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
    gtk_widget_show (ok);


    /* Signal connection handling */


    gtk_signal_connect (GTK_OBJECT (msg_dialog), "destroy",
                        GTK_SIGNAL_FUNC (destroy_grab_widget), NULL);

    gtk_signal_connect (GTK_OBJECT (msg_dialog), "delete_event",
                        GTK_SIGNAL_FUNC (destroy_grab_widget), NULL);

    gtk_signal_connect_object (GTK_OBJECT (ok), "clicked",
                               GTK_SIGNAL_FUNC (destroy_grab_widget),
                               GTK_OBJECT (msg_dialog));


    /* Focus and grabs  */


    gtk_widget_grab_default (ok);

    gtk_grab_add (msg_dialog);

    gtk_widget_show (msg_dialog);
}
