/***************************************************************************
                          utils.h  -  description
                             -------------------
    begin                : Fri Jun 15 2001
    copyright            : (C) 2001 by Pierre-Michel THEVENY
    email                : pmt@mnhn.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef UTILS_H
#define UTILS_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>


/***************************************************************************
*  Standard gettext macros.
 ***************************************************************************/

#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif


/***************************************************************************
*  Function extracted from support.c from GLADE
 ***************************************************************************/

GtkWidget *lookup_widget (GtkWidget * widget, const gchar * widget_name);


/***************************************************************************
* GtK signal function used to destroy widget when has focus grab
 ***************************************************************************/

void destroy_grab_widget (GtkWidget * widget, gpointer data);

#endif
