# -*- coding: UTF-8 -*-
"""マクロの例です。"""
from trac.util import escape

def execute(hdf, txt, env):
    # Currently hdf is set only when the macro is called
    # From a wiki page
    if hdf:
        hdf['wiki.macro.greeting'] = 'Hello World'
        
    # args will be `None` if the macro is called without parenthesis.
    args = txt or '(引数が指定されませんでした)'

    # then, as `txt` comes from the user, it's important to guard against
    # the possibility to inject malicious HTML/Javascript, by using `escape()`:
    return 'Hello World, args = ' + escape(args)
