<!DOCTYPE html
    PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="ja" xml:lang="ja">
 <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><?cs
  if:project.name ?>
  <title><?cs if:title ?><?cs var:title ?> - <?cs /if ?><?cs
    var:project.name?> - Trac</title><?cs
  else ?>
  <title>Trac: <?cs var:title ?></title><?cs
  /if ?><?cs
  if:html.norobots ?>
  <meta name="ROBOTS" content="NOINDEX, NOFOLLOW" /><?cs
  /if ?><?cs
  each:rel = links ?><?cs each:link = rel ?>
  <link rel="<?cs var:name(rel) ?>" href="<?cs var:link.href ?>"<?cs
   if:link.title ?> title="<?cs var:link.title ?>"<?cs /if ?><?cs
   if:link.type ?> type="<?cs var:link.type ?>"<?cs /if ?> /><?cs
  /each ?><?cs /each ?>
  <style type="text/css">
   @import url(<?cs var:htdocs_location ?>css/trac.css);
   <?cs if:html.stylesheet ?>@import url(<?cs var:htdocs_location ?><?cs
     var:html.stylesheet ?>);<?cs /if ?>
   <?cs include "site_css.cs" ?>
  </style>
  <script src="<?cs var:htdocs_location ?>trac.js" type="text/javascript"></script>
 </head>
<body>
<?cs include "site_header.cs" ?>
<div id="banner">

<div id="header">
  <a id="logo" href="<?cs var:header_logo.link ?>"><img src="<?cs var:header_logo.src ?>"
      width="<?cs var:header_logo.width ?>" height="<?cs var:header_logo.height ?>"
      alt="<?cs var:header_logo.alt ?>" /></a>
  <hr />
</div>

<form id="search" action="<?cs var:trac.href.search ?>" method="get">
 <?cs if:trac.acl.SEARCH_VIEW ?><div>
  <label for="proj-search">検索文字列:</label>
  <input type="text" id="proj-search" name="q" size="10" value="" />
  <input type="submit" value="検索実行" />
  <input type="hidden" name="wiki" value="on" />
  <input type="hidden" name="changeset" value="on" />
  <input type="hidden" name="ticket" value="on" />
 </div><?cs /if ?>
</form>

<div id="metanav" class="nav">
 <h2>ナビゲーション</h2>
 <ul>
  <li class="first"><?cs if:trac.authname == "anonymous" || !trac.authname ?>
    <a href="<?cs var:trac.href.login ?>">ログイン</a>
  <?cs else ?>
    <?cs var:trac.authname ?> としてログイン中</li>
    <li><a href="<?cs var:trac.href.logout ?>">ログアウト</a>
  <?cs /if ?></li>
  <li><a href="<?cs var:trac.href.settings ?>">ユーザ設定</a></li>
  <li><a accesskey="6" href="<?cs var:trac.href.wiki ?>/TracGuide">ヘルプ</a></li>
  <li style="display: none"><a accesskey="5" href="http://projects.edgewall.com/trac/wiki/TracFaq">FAQ</a></li>
  <li style="display: none"><a accesskey="0" href="<?cs var:trac.href.wiki ?>/TracAccessibility">アクセラレータ</a></li>
  <li class="last"><a accesskey="9" href="<?cs var:trac.href.about ?>">Tracについて</a></li>
 </ul>
</div>

</div>

<?cs def:navlink(text, href, id, aclname, accesskey) ?><?cs
 if $aclname ?><li><a href="<?cs var:href ?>"<?cs 
  if $id == $trac.active_module ?> class="active"<?cs
  /if ?><?cs
  if:$accesskey!="" ?> accesskey="<?cs var:$accesskey ?>"<?cs 
  /if ?>><?cs var:text ?></a></li><?cs 
 /if ?><?cs
/def ?>

<?cs if $trac.active_module == "wiki" ?><?cs
  set:$wiki_view="wiki" ?><?cs
 else  ?><?cs
  set:$wiki_view="attachment" ?><?cs
 /if  ?><?cs
 if $trac.active_module == "ticket" ?><?cs
  set:$ticket_view="ticket" ?><?cs
 elif $trac.active_module == "query" ?><?cs
  set:$ticket_view="query" ?><?cs
 else ?><?cs
  set:$ticket_view="report" ?><?cs
 /if  ?><?cs
 if $trac.active_module == "log" ?><?cs
  set:$browser_view="log" ?><?cs
 elif $trac.active_module == "file" ?><?cs
  set:$browser_view="file" ?><?cs
 else  ?><?cs
  set:$browser_view="browser" ?><?cs
 /if  ?><?cs
 if $trac.active_module == "milestone" ?><?cs
  set:$roadmap_view="milestone" ?><?cs
 else ?><?cs
  set:$roadmap_view="roadmap" ?><?cs 
 /if ?>

<div id="mainnav" class="nav">
 <ul><?cs
  call:navlink("Wiki", trac.href.wiki, wiki_view,
               trac.acl.WIKI_VIEW, "1") ?><?cs
  call:navlink("タイムライン", trac.href.timeline, "timeline",
               trac.acl.TIMELINE_VIEW, "2") ?><?cs
  call:navlink("ロードマップ", trac.href.roadmap, roadmap_view,
               trac.acl.ROADMAP_VIEW, "3") ?><?cs
  call:navlink("リポジトリブラウザ", trac.href.browser, browser_view,
               trac.acl.BROWSER_VIEW, "") ?><?cs
  call:navlink("チケットを見る", trac.href.report, ticket_view,
               trac.acl.REPORT_VIEW, "") ?><?cs
  call:navlink("チケット登録", trac.href.newticket, "newticket",
               trac.acl.TICKET_CREATE, "7") ?><?cs
  call:navlink("検索", trac.href.search, "search",
               trac.acl.SEARCH_VIEW, "4") ?></ul>
</div>

<div id="main">
