<?cs set:html.stylesheet = 'css/wiki.css' ?>
<?cs include "header.cs" ?>
<?cs include "macros.cs" ?>

<div id="ctxtnav" class="nav">
 <h2>Wikiナビゲーション</h2>
 <ul>
  <li><a href="<?cs var:$trac.href.wiki ?>">スタートページ</a></li>
  <li><a href="<?cs var:$trac.href.wiki ?>/TitleIndex">ページ一覧</a></li>
  <li><a href="<?cs var:$trac.href.wiki ?>/RecentChanges">最近更新されたページ</a></li>
  <?cs if:wiki.history_href ?>
   <li class="last"><a href="<?cs var:wiki.history_href ?>">ページ履歴</a></li>
  <?cs else ?>
   <li class="last">ページ履歴</li>
  <?cs /if ?>
 </ul>
 <hr />
</div>

<div id="content" class="wiki">

 <?cs if:wiki.action == "diff" ?>
  <h1>バージョン <?cs var:wiki.edit_version?> での変更箇所: <a href="<?cs
    var:wiki.current_href ?>"><?cs var:wiki.page_name ?></a></h1>
  <form method="post" id="prefs" action="<?cs var:wiki.current_href ?>">
   <div>
    <input type="hidden" name="mode" value="wiki" />
    <input type="hidden" name="diff" value="yes" />
    <input type="hidden" name="version" value="<?cs var:wiki.edit_version?>" />
    <input type="hidden" name="update" value="yes" />
    <label for="type">diffの表示方法</label>
    <select name="style" onchange="this.form.submit()">
     <option value="inline"<?cs
       if:diff.style == 'inline' ?> selected="selected"<?cs
       /if ?>>インライン</option>
     <option value="sidebyside"<?cs
       if:diff.style == 'sidebyside' ?> selected="selected"<?cs
       /if ?>>並べて表示</option>
    </select>
    <noscript><div class="buttons">
     <input type="submit" value="変更" />
    </div></noscript>
   </div>
  </form>
  <dl id="overview">
   <dt class="author">更新者:</dt>
   <dd><?cs var:wiki.diff.author ?></dd>
   <dt class="time">更新日時:</dt>
   <dd><?cs var:wiki.diff.time ?></dd>
   <?cs if:wiki.diff.comment ?>
    <dt class="comment">コメント:</dt>
    <dd><?cs var:wiki.diff.comment ?></dd>
   <?cs /if ?>
  </dl>
  <div class="diff">
   <div id="legend">
    <h3>Legend:</h3>
    <dl>
     <dt class="unmod"></dt><dd>変更無し</dd>
     <dt class="add"></dt><dd>追加</dd>
     <dt class="rem"></dt><dd>削除</dd>
     <dt class="mod"></dt><dd>更新</dd>
    </dl>
   </div>
   <ul>
    <li>
     <h2><?cs var:wiki.diff.name.new ?></h2>
     <?cs if:diff.style == 'sidebyside' ?>
      <table class="sidebyside" summary="Differences">
       <colgroup class="base">
        <col class="lineno" /><col class="content" />
       <colgroup class="chg">
        <col class="lineno" /><col class="content" />
       </colgroup>
       <thead><tr>
        <th colspan="2">Version <?cs var:wiki.diff.rev.old ?></th>
        <th colspan="2">Version <?cs var:wiki.diff.rev.new ?></th>
       </tr></thead>
       <?cs each:change = wiki.diff.changes ?>
        <tbody>
         <?cs call:diff_display(change, diff.style) ?>
        </tbody>
       <?cs /each ?>
      </table>
     <?cs else ?>
      <table class="inline" summary="Differences">
       <colgroup>
        <col class="lineno" />
        <col class="lineno" />
        <col class="content" />
       </colgroup>
       <thead><tr>
        <th title="Version <?cs var:wiki.diff.rev.old ?>">v<?cs
          var:wiki.diff.rev.old ?></th>
        <th title="Version <?cs var:wiki.diff.rev.new ?>">v<?cs
          var:wiki.diff.rev.new ?></th>
        <th></th>
       </tr></thead>
       <?cs each:change = wiki.diff.changes ?>
        <?cs call:diff_display(change, diff.style) ?>
       <?cs /each ?>
      </table>
     <?cs /if ?>
    </li>
   </ul>
  </div>

 <?cs elif wiki.action == "history" ?>
  <h1><a href="<?cs var:wiki.current_href ?>"><?cs
    var:wiki.page_name ?></a>の更新履歴</h1>
  <?cs if:wiki.history ?>
   <table id="wikihist" class="listing" summary="Change history">
    <thead><tr>
     <th class="date">更新日時</th>
     <th class="version">バージョン</th>
     <th class="author">更新者</th>
     <th class="comment">コメント</th>
    </tr></thead>
    <tbody><?cs each:item = wiki.history ?>
     <tr class="<?cs if:name(item) % #2 ?>even<?cs else ?>odd<?cs /if ?>">
      <td class="date"><?cs var:item.time ?></td>
      <td class="version">
       <a href="<?cs var:item.url ?>" title="このバージョンを閲覧する"><?cs
         var:item.version ?></a>
       (<a href="<?cs var:item.diff_url ?>" title="前のバージョンと比較する">diff</a>)
      </td>
      <td class="author" title="IPアドレス: <?cs var:item.ipaddr ?>">
       <?cs var:item.author ?>
      </td>
      <td class="comment"><?cs var:item.comment ?></td>
     </tr>
    <?cs /each ?></tbody>
   </table>
  <?cs /if ?>
 
 <?cs else ?>
  <?cs if wiki.action == "edit" || wiki.action == "preview" ?>
   <h3>"<?cs var:wiki.page_name ?>"を編集中です</h3>
   <form id="edit" action="<?cs var:wiki.current_href ?>#preview" method="post">
    <fieldset class="iefix">
     <input type="hidden" name="edit_version" value="<?cs
       var:wiki.edit_version ?>" />
     <input type="hidden" id="scroll_bar_pos" name="scroll_bar_pos" value="<?cs
       var:wiki.scroll_bar_pos ?>" />
     <div id="rows">
      <label for="editrows">編集領域の高さを変更:</label>
      <select size="1" name="editrows" id="editrows" tabindex="43"
        onchange="resizeTextArea('text', this.options[selectedIndex].value)"><?cs
       loop:rows = 8, 42, 4 ?>
        <option value="<?cs var:rows ?>"<?cs
          if:rows == wiki.edit_rows ?> selected="selected"<?cs /if ?>><?cs
          var:rows ?></option><?cs
       /loop ?>
      </select>
     </div>
     <p><textarea id="text" name="text" cols="80" rows="<?cs
       var:wiki.edit_rows ?>"><?cs var:wiki.page_source ?></textarea></p>
     <?cs call:wiki_toolbar('text') ?>
     <script type="text/javascript">
       var scrollBarPos = document.getElementById("scroll_bar_pos");
       var text = document.getElementById("text");
       addEvent(window, "load", function() {
         if (scrollBarPos.value) text.scrollTop = scrollBarPos.value;
       });
       addEvent(text, "blur", function() { scrollBarPos.value = text.scrollTop });
     </script>
    </fieldset>
    <div id="help">
     <b>Note:</b> Wikiページ編集のヘルプは <a href="<?cs var:$trac.href.wiki
?>/WikiFormatting">WikiFormatting</a> および <a href="<?cs var:$trac.href.wiki
?>/TracWiki">TracWiki</a> を参照してください。
    </div>
    <fieldset id="changeinfo">
     <legend>更新情報</legend>
     <div class="field">
      <label for="author">メールアドレスまたはユーザ名:</label>
      <br /><input id="author" type="text" name="author" size="30" value="<?cs
        var:wiki.author ?>" />
     </div>
     <div class="field">
      <label for="comment">この変更についてのコメント (非必須):</label>
      <br /><input id="comment" type="text" name="comment" size="60" value="<?cs
        var:wiki.comment?>" />
     </div><br />
     <?cs if trac.acl.WIKI_ADMIN ?>
      <div class="options">
       <input type="checkbox" name="readonly" id="readonly"<?cs
         if wiki.readonly == "1"?>checked="checked"<?cs /if ?> />
       <label for="readonly">このページを読み込み専用にする</label>
      </div>
     <?cs /if ?>
    </fieldset>
    <div class="buttons">
     <input type="submit" name="save" value="保存" />&nbsp;
     <input type="submit" name="preview" value="プレビュー" />&nbsp;
     <input type="submit" name="cancel" value="取り消し" />
    </div><?cs
    if wiki.action == "preview" ?>
     <fieldset id="preview">
      <legend>プレビュー</legend>
      <div class="wikipage"><?cs var:wiki.page_html ?></div>
     </fieldset><?cs
    /if ?>
   </form>
  <?cs /if ?>
  <?cs if wiki.action == "view" ?>
   <div class="wikipage">
    <div id="searchable"><?cs var:wiki.page_html ?></div>
   </div>
   <?cs if $wiki.attachments.0.name ?>
    <h3 id="tkt-changes-hdr">添付ファイル</h3>
    <ul class="tkt-chg-list">
    <?cs each:a = wiki.attachments ?>
      <li class="tkt-chg-change"><a href="<?cs var:a.href ?>">
      <?cs var:a.name ?></a> (<?cs var:a.size ?>) -
      <?cs var:a.descr ?>,
      登録者:<?cs var:a.author ?>, 登録日時:<?cs var:a.time ?></li>
    <?cs /each ?>
  </ul>
  <?cs /if ?>
  <?cs if wiki.action == "view" && (trac.acl.WIKI_MODIFY || trac.acl.WIKI_DELETE)
      && (wiki.readonly == "0" || trac.acl.WIKI_ADMIN) ?>
   <div class="buttons">
    <?cs if:trac.acl.WIKI_MODIFY ?>
     <form method="get" action=""><div>
      <input type="hidden" name="edit" value="yes" />
      <input type="submit" value="このページを編集" />
     </div></form>
     <form method="get" action="<?cs var:wiki.attach_href ?>"><div>
      <input type="submit" value="このページにファイルを添付" />
     </div></form>
    <?cs /if ?>
    <?cs if:trac.acl.WIKI_DELETE ?>
     <form method="post" action=""><div id="delete">
      <input type="hidden" name="edit_version" value="<?cs
        var:wiki.edit_version?>" />
       <input type="submit" name="delete_ver" id="delete_ver" value="このバージョンを削除" onclick="return confirm('このページのバージョン<?cs var:wiki.edit_version?>を本当に削除してもいいですか?\n一度削除したバージョンは復活できません!')" />
       <input type="submit" name="delete_page" value="このページを削除" onclick="return confirm('このページの全バージョンを本当に削除してもいいですか?\n一度削除したページは復活できません!')" />
     </div></form>
    <?cs /if ?>
   </div>
  <?cs /if ?>
 <?cs /if ?>
 <?cs /if ?>
</div>
<?cs include "footer.cs" ?>
