/*
	**
	** limit-report.c
	**
	** Routines to limit the number of hosts and/or peers in a report
	**
	** Copyright 1998-1999 Damien Miller <dmiller@ilogic.com.au>
	**
	** This software is licensed under the terms of the GNU General 
	** Public License (GPL). Please see the file COPYING for details.
	** 
	** $Id: limit-report.h,v 1.3 1999/02/10 11:16:47 dmiller Exp $
	**
 */

#ifndef _LIMIT_REPORT_H
#define _LIMIT_REPORT_H

#include "report.h"

void limit_hosts_by_number(host_t **root, unsigned int n_hosts);
void limit_peers_by_number(host_t *h, unsigned int n_peers);
void limit_hosts_by_address(report_t *r, int mode, u_int32_t address, u_int32_t mask);
void trim_peers(host_t *root);

#define EXCLUDE_UNSPECIFIED		1
#define EXCLUDE_SPECIFIED			2
#define EXCLUDE_NONE					0

#endif /* _LIMIT_REPORT_H */
