from Tribler.Core.CacheDB.sqlitecachedb import SQLiteCacheDB
from Tribler.Test.test_as_server import AbstractServer
from Tribler.dispersy.util import blocking_call_on_reactor_thread


class TestSqliteCacheDB(AbstractServer):

    @blocking_call_on_reactor_thread
    def setUp(self):
        AbstractServer.setUp(self)
        self.sqlite_test = SQLiteCacheDB.getInstance()
        self.db_path = ':memory:'

    @blocking_call_on_reactor_thread
    def tearDown(self):
        AbstractServer.tearDown(self)
        SQLiteCacheDB.getInstance().close_all()
        SQLiteCacheDB.delInstance()

    @blocking_call_on_reactor_thread
    def test_open_db(self):
        self.sqlite_test.openDB(self.db_path, 0)

    @blocking_call_on_reactor_thread
    def test_create_db(self):
        sql = "create table person(lastname, firstname);"
        self.sqlite_test.createDBTable(sql, self.db_path)

    @blocking_call_on_reactor_thread
    def test_get_del_instance(self):
        SQLiteCacheDB.delInstance()
        sqlite_test2 = SQLiteCacheDB.getInstance()

        assert sqlite_test2 != self.sqlite_test

    @blocking_call_on_reactor_thread
    def test_insert(self):
        self.test_create_db()

        self.sqlite_test.insert('person', lastname='a', firstname='b')
        assert self.sqlite_test.size('person') == 1

    @blocking_call_on_reactor_thread
    def test_fetchone(self):
        self.test_insert()
        one = self.sqlite_test.fetchone('select * from person')
        assert one == ('a', 'b')

        one = self.sqlite_test.fetchone("select lastname from person where firstname == 'b'")
        assert one == 'a'

        one = self.sqlite_test.fetchone("select lastname from person where firstname == 'c'")
        assert one is None

    @blocking_call_on_reactor_thread
    def test_insertmany(self):
        self.test_create_db()

        values = []
        for i in range(100):
            value = (str(i), str(i ** 2))
            values.append(value)
        self.sqlite_test.insertMany('person', values)
        assert self.sqlite_test.size('person') == 100

    @blocking_call_on_reactor_thread
    def test_fetchall(self):
        self.test_insertmany()

        all = self.sqlite_test.fetchall('select * from person')
        assert len(all) == 100

        all = self.sqlite_test.fetchall("select * from person where lastname=='101'")
        assert all == []

    @blocking_call_on_reactor_thread
    def test_insertorder(self):
        self.test_insertmany()

        self.sqlite_test.insert('person', lastname='1', firstname='abc')
        one = self.sqlite_test.fetchone("select firstname from person where lastname == '1'")
        assert one == '1' or one == 'abc'

        all = self.sqlite_test.fetchall("select firstname from person where lastname == '1'")
        assert len(all) == 2

    @blocking_call_on_reactor_thread
    def test_update(self):
        self.test_insertmany()

        self.sqlite_test.update('person', "lastname == '2'", firstname='56')
        one = self.sqlite_test.fetchone("select firstname from person where lastname == '2'")
        assert one == '56', one

        self.sqlite_test.update('person', "lastname == '3'", firstname=65)
        one = self.sqlite_test.fetchone("select firstname from person where lastname == '3'")
        assert one == 65, one

        self.sqlite_test.update('person', "lastname == '4'", firstname=654, lastname=44)
        one = self.sqlite_test.fetchone("select firstname from person where lastname == 44")
        assert one == 654, one
